unit Helper_ValueEdit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, CrossEdit, Math;

type
  TForm_ValueEdit = class(TForm)
    group:      TGroupBox;
    btn_ok:     TButton;
    btn_cancel: TButton;
    lbl_current: TLabel;
    edit_current: TEdit;
    lbl_new:    TLabel;
    lbl_offset: TLabel;
    lbl_datatype: TLabel;
    edit_offset: TEdit;
    edit_datatype: TEdit;
    procedure btn_cancelClick(Sender: TObject);
    procedure btn_okClick(Sender: TObject);
    procedure MakeVarInput(objectname: String; offset: LongWord;
      datatype: Word; current: String; caller: TObject);
    procedure FormCreate(Sender: TObject);
  private
  public
    edit_new:   TCrossEdit;
  end;

var
  Form_ValueEdit: TForm_ValueEdit;


implementation

uses Tool_BinEdit, Tool_RawEdit, Code_DataStructures, Main;

{$R *.dfm}

var
  caller_win_dat: TForm_BinEdit;
  caller_win_raw: TForm_RawEdit;
  _datatype: Word;
  _offset: LongWord;




procedure TForm_ValueEdit.MakeVarInput(objectname: String; offset: LongWord;
  datatype: Word; current: String; caller: TObject);
begin
  caller_win_dat := nil;
  caller_win_raw := nil;
  if Pos('rawedit', TComponent(caller).Name) > 0 then
    caller_win_raw := TForm_RawEdit(caller)
  else
    caller_win_dat := TForm_BinEdit(caller);
  Form_Main.Enabled := False;
  Self.Visible := True;
  group.Caption := 'Edit value';
  _datatype := datatype;
  _offset := offset;
  if Length(objectname) > 0 then
    group.Caption := group.Caption + ' for ' + objectname;
  edit_offset.Text := '0x' + IntToHex(offset, 8);
  edit_datatype.Text := GetDataType(datatype);
  edit_current.Text := current;
  edit_new.EditType := etString;
  edit_new.Text := '';
  edit_new.LimitCheck := False;
  edit_new.MaxLength := 0;
  edit_new.Max := 0;
  edit_new.BorderStyle := bsSingle;
  Self.Width := 300;
  case datatype of
    1..4:
    begin
      edit_new.EditType := etUnsignedInt;
      edit_new.LimitCheck := True;
      edit_new.Max := Int(Power(256, datatype)) - 1;
    end;
    5..8:
    begin
      edit_new.MaxLength := 2 * (datatype - 4);
      edit_new.EditType  := etHex;
    end;
    9:
    begin
      edit_new.EditType   := etFloat;
      edit_new.LimitCheck := False;
    end;
    10:
    begin
      edit_new.EditType   := etBinary;
      edit_new.LimitCheck := False;
      edit_new.MaxLength  := 8;
    end;
    13..16:
    begin
      Exit;
      edit_new.EditType := etInteger;
      edit_new.LimitCheck := True;
      edit_new.Max := Int((Power(256, datatype - 13)) / 2) - 1;
      edit_new.Min := 1 - Int((Power(256, datatype - 13)) / 2) - 1;
    end;
    10000..65535:
    begin
      edit_new.EditType := etString;
      edit_new.LimitCheck := False;
      edit_new.MaxLength := datatype - 10000;
      Self.Width := 700;
    end;
  end;
  edit_new.SetFocus;
  edit_new.SelectAll;
end;




procedure TForm_ValueEdit.btn_okClick(Sender: TObject);
begin
  if not edit_new.NoValidValue then
  begin
    Form_Main.Enabled := True;
    Self.Visible  := False;
    if caller_win_dat = nil then
      caller_win_raw.SetNewValue(_datatype, _offset, edit_new.Text)
    else
      caller_win_dat.SetNewValue(_datatype, _offset, edit_new.Text);
  end;
end;




procedure TForm_ValueEdit.FormCreate(Sender: TObject);
begin
  edit_new := TCrossEdit.Create(Self);
  with edit_new do
  begin
    Left := 88;
    Top := 88;
    Width := 203;
    Height := 18;
    Anchors := [akLeft, akTop, akRight];
    AutoSize := False;
    BorderStyle := bsNone;
    Color := clWhite;
    Font.Charset := DEFAULT_CHARSET;
    Font.Color := clWindowText;
    Font.Height := -11;
    Font.Name := 'Tahoma';
    Font.Style := [];
    HideSelection := False;
    ParentFont := False;
    TabOrder := 5;
    Text := '0000';
    FocusAlignment := taLeftJustify;
    NoFocusAlignment := taLeftJustify;
    Precision := 15;
    Decimals := 4;
    FocusWidthInc := 0;
    EditType := etHex;
    NextDialogOnEnter := True;
    DialogOnCursorKeys := True;
    NextPriorStep := 1;
    AutoFocus := False;
    LimitCheck := True;
    Max := 2147483647.000000000000000000;
    FocusColor := clWhite;
    NoFocusColor := clWhite;
    ErrorColor := clRed;
    StringCharSet := scFull;
  end;
  Self.InsertControl(edit_new);
end;

procedure TForm_ValueEdit.btn_cancelClick(Sender: TObject);
begin
  Form_Main.Enabled := True;
  Self.Visible  := False;
end;

end.
