#include <time.h>

#include "Daodan_BSL.h"
#include "BFW_ScriptingLanguage.h"
#include <stdio.h>
#include "Oni.h"
#include "Oni_Character.h"
#include "dSFMT\dSFMT.h"

uint16_t ONICALL bsl_int32mul(void* dontuse0, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	if (numargs < 2)
		return 1;
	ret->value_int32 = args[0].value_int32 * args[1].value_int32;
	ret->type = sl_int32;
	return 0;
}

uint16_t ONICALL bsl_getkills(void* dontuse0, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{

	int index;
	if (numargs == 0) index = 0;
	else index = args[0].value_int32;
	int* killcount = ONgGameState + index * 0x16A0 +  0x1260 + 0x1670;
	ret->value_int32 = *killcount;
	ret->type = sl_int32;
	return 0;

}

uint16_t ONICALL bsl_getdamage(void* dontuse0, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{

	int index;
	if (numargs == 0) index = 0;
	else index = args[0].value_int32;
	int* killcount = ONgGameState + index * 0x16A0 +  0x1260 + 0x1674;
	ret->value_int32 = *killcount;
	ret->type = sl_int32;
	return 0;

}

uint16_t ONICALL bsl_mul(void* dontuse0, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	if (numargs < 2)
		return 1;
	
	double val1;
	double val2;
	
	if (args[0].type == sl_int32)
		val1 = args[0].value_int32;
	else
		val1 = args[0].value_float;
	
	if (args[1].type == sl_int32)
		val2 = args[1].value_int32;
	else
		val2 = args[1].value_float;
	
	ret->value_float = (float)(val1 * val2);
	ret->type = sl_float;
	return 0;
}

uint16_t ONICALL bsl_int32div(void* dontuse0, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	if (numargs < 2)
		return 1;
	ret->value_int32 = args[0].value_int32 / args[1].value_int32;
	ret->type = sl_int32;
	return 0;
}

uint16_t ONICALL bsl_div(void* dontuse0, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	if (numargs < 2)
		return 1;
	
	double val1;
	double val2;
	
	if (args[0].type == sl_int32)
		val1 = args[0].value_int32;
	else
		val1 = args[0].value_float;
	
	if (args[1].type == sl_int32)
		val2 = args[1].value_int32;
	else
		val2 = args[1].value_float;
	
	ret->value_float = (float)(val1 / val2);
	ret->type = sl_float;
	return 0;
}
uint16_t ONICALL bsl_sprintf(void* dontuse0, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	if (numargs < 2)
		return 1;
	
	char output[255];
	char temp[255];
	int i = 1;
	for(i; i < numargs; i++)	{
		sprintf(output, args[0].value_str32, args[i].value_str32);/*
		if(args[i].type == sl_int32 || args[i].type == sl_bool) {
			sprintf(temp, "%i",args[i].value_int32);
			sprintf(output, args[0].value_str32, temp); }
		else if(args[i].type == sl_float) {
			sprintf(temp, "%f",args[i].value_float);
			sprintf(output, args[0].value_str32, temp); }
		else */
	}
	
	ret->value_str32 = output;
	ret->type = sl_str32;
	return 0;
}


uint16_t ONICALL bsl_int32rand(void* dontuse0, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	if (numargs < 2)
		return 1;
	
	int32_t start = 0;
	int32_t end = 0;
	
	if (args[0].value_int32 == args[1].value_int32)
		return 1;
	else if (args[0].value_int32 > args[1].value_int32)
	{
		start = args[1].value_int32;
		end = args[0].value_int32;
	}
	else
	{
		start = args[0].value_int32;
		end = args[1].value_int32;
	}
	
	ret->value_int32 = start + (dsfmt_gv_genrand_uint32() % (uint32_t)(end - start + 1));
	ret->type = sl_int32;
	return 0;
}


void SLrDaodan_Initalize()
{
	SLrScript_Command_Register_ReturnType("int32mul", "Multiplies two numbers", "n1:int n2:int", sl_int32, bsl_int32mul);
	SLrScript_Command_Register_ReturnType("mul", "Multiplies two numbers", "[int1:int|float1:float] [int2:int|float2:float]", sl_float, bsl_mul);
	
	SLrScript_Command_Register_ReturnType("int32div", "Divides two numbers", "n1:int n2:int", sl_int32, bsl_int32div);
	SLrScript_Command_Register_ReturnType("div", "Divides two numbers", "[int1:int|float1:float] [int2:int|float2:float]", sl_float, bsl_div);

	
	SLrScript_Command_Register_ReturnType("sprintf", "sprintf", "str1:format str2:value [str3:...]", sl_str32, bsl_sprintf);

	SLrScript_Command_Register_ReturnType("chr_getkills","Gets the number of kills a character has", "[chrindex:int]", sl_int32, bsl_getkills);
	SLrScript_Command_Register_ReturnType("chr_getdamage","Gets the amount of damage a character has caused", "[chrindex:int]", sl_int32, bsl_getdamage);
	
	dsfmt_gv_init_gen_rand((uint32_t)time(NULL));
	SLrScript_Command_Register_ReturnType("int32rand", "Returns a pseudo-random number between two numbers (inclusive).", "start:int end:int", sl_int32, bsl_int32rand);

}
