#include <stdio.h>
#include <time.h>
#include <ffi.h>

#include "Daodan_BSL.h"
#include "Daodan_Utility.h"
#include "Daodan_Console.h"
#include "BFW_ScriptLang.h"
#include "Oni.h"
#include "Oni_Character.h"
#include "dSFMT\dSFMT.h"

uint16_t ONICALL bsl_int32mul(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	ret->value_int32 = args[0].value_int32 * args[1].value_int32;
	ret->type = sl_int32;
	return 0;
}

uint16_t ONICALL bsl_mul(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	double val1;
	double val2;
	
	if (args[0].type == sl_int32)
		val1 = args[0].value_int32;
	else
		val1 = args[0].value_float;
	
	if (args[1].type == sl_int32)
		val2 = args[1].value_int32;
	else
		val2 = args[1].value_float;
	
	ret->value_float = (float)(val1 * val2);
	ret->type = sl_float;
	return 0;
}

uint16_t ONICALL bsl_int32div(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	ret->value_int32 = args[0].value_int32 / args[1].value_int32;
	ret->type = sl_int32;
	return 0;
}

uint16_t ONICALL bsl_div(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	double val1;
	double val2;
	
	if (args[0].type == sl_int32)
		val1 = args[0].value_int32;
	else
		val1 = args[0].value_float;
	
	if (args[1].type == sl_int32)
		val2 = args[1].value_int32;
	else
		val2 = args[1].value_float;
	
	ret->value_float = (float)(val1 / val2);
	ret->type = sl_float;
	return 0;
}

uint16_t ONICALL bsl_int32rand(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	int32_t start = 0;
	int32_t end = 0;
	
	if (args[0].value_int32 == args[1].value_int32)
		return 1;
	else if (args[0].value_int32 > args[1].value_int32)
	{
		start = args[1].value_int32;
		end = args[0].value_int32;
	}
	else
	{
		start = args[0].value_int32;
		end = args[1].value_int32;
	}
	
	ret->value_int32 = start + (dsfmt_gv_genrand_uint32() % (uint32_t)(end - start + 1));
	ret->type = sl_int32;
	return 0;
}

uint16_t ONICALL bsl_getkills(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	int index;
	if (numargs == 0) index = 0;
	else index = args[0].value_int32;
	int* killcount = ONgGameState + index * 0x16A0 + 0x1260 + 0x1670;
	ret->value_int32 = *killcount;
	ret->type = sl_int32;
	return 0;
}

uint16_t ONICALL bsl_getdamage(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	int index;
	if (numargs == 0) index = 0;
	else index = args[0].value_int32;
	int* killcount = ONgGameState + index * 0x16A0 + 0x1260 + 0x1674;
	ret->value_int32 = *killcount;
	ret->type = sl_int32;
	return 0;
}
/*
uint16_t ONICALL bsl_sprintf(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	if (numargs < 2)
		return 1;
	
	char output[255];
	int i;
	for(i = 1; i < numargs; i++)	{
		sprintf(output, args[0].value_str32, args[i].value_str32);
	}
	
	ret->value_str32 = output;
	ret->type = sl_str32;
	return 0;
}
*/
uint16_t ONICALL bsl_sprintf(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	DDrConsole_PrintF("%d", numargs);
	
	if (numargs < 1 || args[0].type != sl_str32)
	{
		DDrConsole_PrintF("Func \"%s\", File \"%s\", Line %d: semantic error, \"%s\": parameter list does not match: format:string arg1 arg2 ...", callinfo->name, callinfo->calllocation, callinfo->linenumber, callinfo->name);
		return 0;
	}
	
	if (!args[0].value_str32)
		args[0].value_str32 = "";
	
	int ffi_ret;
	char* str = NULL;
	int size = 0;
	
	ffi_cif cif;
	ffi_type* ffi_args[256];
	void* values[256];
	
	ffi_args[0] = &ffi_type_pointer;
	values[0] = &str;
	ffi_args[1] = &ffi_type_uint32;
	values[1] = &size;
	
	int i;
	for(i = 2; i < numargs + 2; i ++)
	{
		if (args[i - 2].type == sl_float)
		{
			float value_float = args[i - 2].value_float;
			double* value_double = (double*)&(args[i - 2]);
			*value_double = value_float;
			
			ffi_args[i] = &ffi_type_double;
			values[i] = value_double;
		}
		else
		{
			ffi_args[i] = &ffi_type_pointer;
			values[i] = &(args[i - 2].value);
		}
	}
	
	if (ffi_prep_cif(&cif, FFI_DEFAULT_ABI, i, &ffi_type_sint32, ffi_args) != FFI_OK)
		return 1;
	ffi_call(&cif, (void*)snprintf, (void*)&ffi_ret, values);
	str = malloc(ffi_ret + 1);
	size = ffi_ret + 1;
	ffi_call(&cif, (void*)snprintf, (void*)&ffi_ret, values);
	ret->value_str32 = str;
	ret->type = sl_str32;
	return 0;
}

void SLrDaodan_Initalize()
{
	SLrScript_Command_Register_ReturnType("int32mul", "Multiplies two numbers", "n1:int n2:int", sl_int32, bsl_int32mul);
	SLrScript_Command_Register_ReturnType("mul", "Multiplies two numbers", "[int1:int|float1:float] [int2:int|float2:float]", sl_float, bsl_mul);
	
	SLrScript_Command_Register_ReturnType("int32div", "Divides two numbers", "n1:int n2:int", sl_int32, bsl_int32div);
	SLrScript_Command_Register_ReturnType("div", "Divides two numbers", "[int1:int|float1:float] [int2:int|float2:float]", sl_float, bsl_div);
	
	dsfmt_gv_init_gen_rand((uint32_t)time(NULL));
	SLrScript_Command_Register_ReturnType("int32rand", "Returns a pseudo-random number between two numbers (inclusive).", "start:int end:int", sl_int32, bsl_int32rand);
	
	SLrScript_Command_Register_ReturnType("chr_getkills","Gets the number of kills a character has", "[chrindex:int]", sl_int32, bsl_getkills);
	SLrScript_Command_Register_ReturnType("chr_getdamage","Gets the amount of damage a character has caused", "[chrindex:int]", sl_int32, bsl_getdamage);
	
	SLrScript_Command_Register_ReturnType("sprintf", "C-style sprintf.", "format:string arg1 arg2 ...", sl_str32, bsl_sprintf);
}
