#include <stdio.h>
#include <time.h>
#include <ffi.h>

#include "Daodan_BSL.h"
#include "Daodan_Utility.h"
#include "Daodan_Patch.h"
#include "Daodan_Console.h"
#include "BFW_ScriptLang.h"
#include "Oni.h"
#include "Oni_Character.h"
#include "oni_gl.h"
#include "dSFMT\dSFMT.h"
#include "Daodan_Character.h"

uint16_t ONICALL bsl_int32mul(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	ret->value_int32 = args[0].value_int32 * args[1].value_int32;
	ret->type = sl_int32;
	return 0;
}

uint16_t ONICALL bsl_mul(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	double val1;
	double val2;
	
	if (args[0].type == sl_int32)
		val1 = args[0].value_int32;
	else
		val1 = args[0].value_float;
	
	if (args[1].type == sl_int32)
		val2 = args[1].value_int32;
	else
		val2 = args[1].value_float;
	
	ret->value_float = (float)(val1 * val2);
	ret->type = sl_float;
	return 0;
}

uint16_t ONICALL bsl_int32div(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	ret->value_int32 = args[0].value_int32 / args[1].value_int32;
	ret->type = sl_int32;
	return 0;
}

uint16_t ONICALL bsl_div(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	double val1;
	double val2;
	
	if (args[0].type == sl_int32)
		val1 = args[0].value_int32;
	else
		val1 = args[0].value_float;
	
	if (args[1].type == sl_int32)
		val2 = args[1].value_int32;
	else
		val2 = args[1].value_float;
	
	ret->value_float = (float)(val1 / val2);
	ret->type = sl_float;
	return 0;
}

uint16_t ONICALL bsl_int32rand(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	int32_t start = 0;
	int32_t end = 0;
	
	if (args[0].value_int32 == args[1].value_int32)
		return 1;
	else if (args[0].value_int32 > args[1].value_int32)
	{
		start = args[1].value_int32;
		end = args[0].value_int32;
	}
	else
	{
		start = args[0].value_int32;
		end = args[1].value_int32;
	}
	
	ret->value_int32 = start + (dsfmt_gv_genrand_uint32() % (uint32_t)(end - start + 1));
	ret->type = sl_int32;
	return 0;
}

uint16_t ONICALL bsl_getkills(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	int index;
	if (numargs == 0) index = 0;
	else if (args[0].type == sl_str32) index = DDrGetCharacterIndexFromName(args[0].value_str32);
	else index = args[0].value_int32;
	int* killcount = ONgGameState + index * 0x16A0 + 0x1260 + 0x1670;
	ret->value_int32 = *killcount;
	ret->type = sl_int32;
	return 0;
}

uint16_t ONICALL bsl_getdamage(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	int index;
	if (numargs == 0) index = 0;
	else if (args[0].type == sl_str32) index = DDrGetCharacterIndexFromName(args[0].value_str32);
	else index = args[0].value_int32;
	int* killcount = ONgGameState + index * 0x16A0 + 0x1260 + 0x1674;
	ret->value_int32 = *killcount;
	ret->type = sl_int32;
	return 0;
}

uint16_t ONICALL bsl_powerup(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	int index;
	if (numargs < 2 || args[1].type != sl_str32) return 1;
	else if (args[0].type == sl_str32) index = DDrGetCharacterIndexFromName(args[0].value_str32);
	else index = args[0].value_int32;
	void* returnval;
	bool is_lsi = 0;
	Character* Chr = ONgGameState + 0x1260;
	if(!strcmp(args[1].value_str32,"ammo")) 
	{
		returnval = &(Chr[index].Inventory_.AmmoUsed);
	}
	else if(!strcmp(args[1].value_str32,"hypo")) 
	{
		returnval = &(Chr[index].Inventory_.HypoUsed);
	}
	else if(!strcmp(args[1].value_str32,"cells")) 
	{
		returnval = &(Chr[index].Inventory_.CellsUsed);
	}
	else if(!strcmp(args[1].value_str32,"invis")) 
	{
		returnval = &(Chr[index].Inventory_.CloakUsed);
	}
	else if(!strcmp(args[1].value_str32,"shield")) 
	{
		returnval = &(Chr[index].Inventory_.ShieldUsed);
	}
	else if(!strcmp(args[1].value_str32,"lsi")) 
	{
		returnval = &(Chr[index].Inventory_.hasLSI);
		is_lsi = 1;
	}
	else if(!strcmp(args[1].value_str32,"bossshield")) 
	{
		ret->value_int32 = Chr[index].Flags & char_bossshield;
		ret->type = sl_int32;
		if (numargs >=3) {
			if (Chr[index].Flags & char_bossshield) Chr[index].Flags = Chr[index].Flags & ~char_bossshield;
			else Chr[index].Flags = Chr[index].Flags | char_bossshield;
		}
		return 0;
	}
	else return 1;
	//todo, add setting
	
	if(is_lsi) ret->value_int32 = (int)*(bool*)returnval;
	else	ret->value_int32 = *(int*)returnval;
	ret->type = sl_int32;

	if (numargs >= 3) 
	{
		if(is_lsi) *(bool*)returnval = args[2].value_int32;
		else *(int*)returnval = args[2].value_int32;
	}
	
	
	return 0;
}

uint16_t ONICALL bsl_health(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	int index;
	if (numargs == 0) index = 0;
	else if (args[0].type == sl_str32) index = DDrGetCharacterIndexFromName(args[0].value_str32);
	else index = args[0].value_int32;
	Character* Chr = ONgGameState + 0x1260 ;
	int* health = &Chr[index].Health;

	ret->value_int32 = *health;
	ret->type = sl_int32;

	if (numargs >= 2) {
		*health = args[1].value_int32;
	}
	ret->value_int32 = *health;
	ret->type = sl_int32;
	return 0;
}

uint16_t ONICALL bsl_maxhealth(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	int index;
	if (numargs == 0) index = 0;
	else if (args[0].type == sl_str32) index = DDrGetCharacterIndexFromName(args[0].value_str32);
	else index = args[0].value_int32;
	Character* Chr = ONgGameState + 0x1260 ;
	int* maxhealth = &Chr[index].MaxHealth;
	int oldmaxhealth = Chr[index].MaxHealth;
	int oldhealth = Chr->Health;
	if (numargs >= 2) {
		*maxhealth = args[1].value_int32;
	}
	if (numargs >= 3 && args[2].value_bool) {
		Chr->Health = (int)(((float)args[1].value_int32 / (float)oldmaxhealth) * (float)oldhealth);
	}
	ret->value_int32 = oldmaxhealth;
	ret->type = sl_int32;
	return 0;
}

uint16_t ONICALL bsl_getattacker(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	//broken...not only does it sometimes blam, but it returns a string when i want an int so i can study it :<
	int index;
	if (numargs == 0) index = 0;
	else	if (args[0].type == sl_str32) index = DDrGetCharacterIndexFromName(args[0].value_str32);
	else index = args[0].value_int32;
	
	Character* Chr = ONgGameState + 0x1260;
	ActiveCharacter* Active = (ActiveCharacter*)ONrGetActiveCharacter(&Chr[index]);
	if ((int)Active == 0) return 1;
	ret->value_int32 = Active->LastDamageSourceCharacter;
	ret->type = sl_int32;
	return 0;
}



uint16_t ONICALL bsl_chrname(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	int index;
	if (numargs == 0) index = 0;
	else if (args[0].type == sl_str32) index = DDrGetCharacterIndexFromName(args[0].value_str32);
	else index = args[0].value_int32;
	if (index == -1) {
		ret->type = sl_str32;
		ret->value_str32 = "NULL";
		return 0;
	}
	char* name = ONgGameState + 0x1260  + index * 0x16A0 + 0x14;
	if (numargs == 2) {
		strncpy(name, (char*)args[1].value_str32, 31);
	}
	
	ret->type = sl_str32;
	ret->value_str32 = name;
	
	return 0;
}


uint16_t ONICALL bsl_count(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	//testing numargs...
	ret->type = sl_int32;
	ret->value_int32 = numargs;
	return 0;
}

uint16_t ONICALL bsl_dprintcolored(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	//TODO: figure out why our implementation of dprint shows after dev mode is turned off
	RGBA color;
	RGBA shade;
	
	if(numargs == 0) return 0;
	if(numargs > 1 ) color.R = (char)args[1].value_int32;
	else color.R = 255;
	if(numargs > 2 ) color.G = (char)args[2].value_int32;
	else color.G = 255;
	if(numargs > 3 ) color.B = (char)args[3].value_int32;
	else color.B = 255;
	color.A = 0;
	if(numargs > 5 ) shade.R = (char)args[5].value_int32;
	else shade.R = 0x3F;
	if(numargs > 6 ) shade.G = (char)args[6].value_int32;
	else shade.G = 0x3F;
	if(numargs > 7 ) shade.B = (char)args[7].value_int32;
	else shade.B = 0x3F;
	shade.A = 0; 

	DDrConsole_PrintColored(args[0].value_str32, 1, color, shade);
	return 0;
}


uint16_t ONICALL bsl_nametoindex(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	ret->type = sl_int32;
	ret->value_int32 = DDrGetCharacterIndexFromName(args[0].value_str32);
	return 0;
}

uint16_t ONICALL bsl_getactiveoffset(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	DDrConsole_PrintF("Character: 0x%x",(int)ONgGameState + 0x1260);
	DDrConsole_PrintF("ActiveChar: 0x%x",(int)ONrGetActiveCharacter((void*)((int)ONgGameState + 0x1260)));
	return 0;
}
/*
uint16_t ONICALL bsl_sprintf(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	if (numargs < 2)
		return 1;
	
	char output[255];
	int i;
	for(i = 1; i < numargs; i++)	{
		sprintf(output, args[0].value_str32, args[i].value_str32);
	}
	
	ret->value_str32 = output;
	ret->type = sl_str32;
	return 0;
}
*/
uint16_t ONICALL bsl_sprintf(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	DDrConsole_PrintF("%d", numargs);
	
	if (numargs < 1 || args[0].type != sl_str32)
	{
		DDrConsole_PrintF("Func \"%s\", File \"%s\", Line %d: semantic error, \"%s\": parameter list does not match: format:string arg1 arg2 ...", callinfo->name, callinfo->calllocation, callinfo->linenumber, callinfo->name);
		return 0;
	}
	
	if (!args[0].value_str32)
		args[0].value_str32 = "";
	
	int ffi_ret;
	char* str = NULL;
	int size = 0;
	
	ffi_cif cif;
	ffi_type* ffi_args[256];
	void* values[256];
	
	ffi_args[0] = &ffi_type_pointer;
	values[0] = &str;
	ffi_args[1] = &ffi_type_uint32;
	values[1] = &size;
	
	int i;
	for(i = 2; i < numargs + 2; i ++)
	{
		if (args[i - 2].type == sl_float)
		{
			float value_float = args[i - 2].value_float;
			double* value_double = (double*)&(args[i - 2]);
			*value_double = value_float;
			
			ffi_args[i] = &ffi_type_double;
			values[i] = value_double;
		}
		else
		{
			ffi_args[i] = &ffi_type_pointer;
			values[i] = &(args[i - 2].value);
		}
	}
	
	if (ffi_prep_cif(&cif, FFI_DEFAULT_ABI, i, &ffi_type_sint32, ffi_args) != FFI_OK)
		return 1;
	ffi_call(&cif, (void*)snprintf, (void*)&ffi_ret, values);
	str = malloc(ffi_ret + 1);
	size = ffi_ret + 1;
	ffi_call(&cif, (void*)snprintf, (void*)&ffi_ret, values);
	ret->value_str32 = str;
	ret->type = sl_str32;
	return 0;
}

// Widescreen patch for talking heads.
uint16_t ONICALL cinematic_start_patch(sl_callinfo* callinfo, unsigned int numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	args[1].value_int32 = (double)args[1].value_int32 / (double)(gl->DisplayMode.Width) * (4.0 / 3.0 * (double)(gl->DisplayMode.Height));
	return ((sl_func)(OniExe + 0x000f3830))(callinfo, numargs, args, dontuse1, dontuse2, ret);
}

void SLrDaodan_Initalize()
{
	SLrScript_Command_Register_ReturnType("int32mul", "Multiplies two numbers", "n1:int n2:int", sl_int32, bsl_int32mul);
	SLrScript_Command_Register_ReturnType("mul", "Multiplies two numbers", "[int1:int|float1:float] [int2:int|float2:float]", sl_float, bsl_mul);
	
	SLrScript_Command_Register_ReturnType("int32div", "Divides two numbers", "n1:int n2:int", sl_int32, bsl_int32div);
	SLrScript_Command_Register_ReturnType("div", "Divides two numbers", "[int1:int|float1:float] [int2:int|float2:float]", sl_float, bsl_div);
	
	dsfmt_gv_init_gen_rand((uint32_t)time(NULL));
	SLrScript_Command_Register_ReturnType("int32rand", "Returns a pseudo-random number between two numbers (inclusive).", "start:int end:int", sl_int32, bsl_int32rand);
	
	SLrScript_Command_Register_ReturnType("d_getkills","Gets the number of kills a character has", "[ai_name:str | script_id:int]", sl_int32, bsl_getkills);
	SLrScript_Command_Register_ReturnType("d_getdamage","Gets the amount of damage a character has caused", "[ai_name:string | script_id:int]", sl_int32, bsl_getdamage);
	SLrScript_Command_Register_ReturnType("d_name","Gets or sets a character's name", "[ai_name:str | script_id:int] [newname:string]", sl_str32, bsl_chrname);
	SLrScript_Command_Register_ReturnType("d_getindex","Converts a character's name to its index", "script_id:int", sl_int32, bsl_nametoindex);
	SLrScript_Command_Register_ReturnType("d_health","Gets or sets a character's health", "[ai_name:str | script_id:int] [newhealth:int]", sl_str32, bsl_health);
	SLrScript_Command_Register_ReturnType("d_maxhealth","Gets or sets a character's maximum health", "[ai_name:str | script_id:int] [newmaxhealth:int] [scalehealth:bool]", sl_str32, bsl_maxhealth);
	SLrScript_Command_Register_ReturnType("d_powerup","Gets or sets a character's powerups", "ai_name:str|script_id:int powerup:str", sl_int32, bsl_powerup);
	//broken. sometimes crashes, and sometimes returns a string... : /
	SLrScript_Command_Register_ReturnType("d_getattacker","Gets the last person to hurt a character", "[ai_name:string | script_id:int]", sl_int32, bsl_getattacker);
	
	SLrScript_Command_Register_ReturnType("d_active","Gets the last person to hurt a character", "[ai_name:string | script_id:int]", sl_int32, bsl_getactiveoffset);

	SLrScript_Command_Register_ReturnType("sprintf", "C-style sprintf.", "format:string arg1 arg2 ...", sl_str32, bsl_sprintf);
	SLrScript_Command_Register_ReturnType("dprintcolor", "prints to console in color", "text:string [color: r b g] [color: r b g]", sl_void, bsl_dprintcolored);



	SLrScript_Command_Register_ReturnType("d_dprint", "prints to console in color", "text:string [color: r b g] [color: r b g]", sl_void, bsl_dprintcolored);
}
void SLrDaodan_Patch()
{
	DDrPatch_Int32(OniExe + 0x000f3755, (int)cinematic_start_patch);
}

