#include "Flatline.h"

bool Net_Listen(uint16_t port, bool (*packet_callback)(char* data, int datalen, int from))
{
	int sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
	
	if (sock < 0)
	{
		DDrStartupMessage("could not create socket");
		return false;
	}
	
	sockaddr_in address;
	memset(&address, 0, sizeof(sockaddr_in));
	address.sin_family = AF_INET;
	address.sin_addr.s_addr = htonl(INADDR_ANY);
	address.sin_port = htons(port);
	
	if (bind(sock, (sockaddr*)&address, sizeof(sockaddr_in)) < 0)
	{
		DDrStartupMessage("could not bind port %d", port);
		closesocket(sock);
		return false;
	}
	
	char data[65537];
	data[sizeof(data) - 1] = '\0';
	sockaddr_in from;
	int recvlen;
	for (;;)
	{
		int fromlen = sizeof(sockaddr_in);
		memset(&from, 0, sizeof(sockaddr_in));
		recvlen = recvfrom(sock, data, sizeof(data) - 1, 0, (sockaddr*)&from, (void*)&fromlen);
		if (!packet_callback(data, recvlen, ntohl(from.sin_addr.s_addr)))
			break;
	}
	closesocket(sock);
	return true;
}

int Net_CreateSocket(uint16_t port)
{
	int sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
	
	if (sock < 0)
	{
		DDrStartupMessage("could not create socket");
		return -1;
	}
	
	sockaddr_in address;
	memset(&address, 0, sizeof(sockaddr_in));
	address.sin_family = AF_INET;
	address.sin_addr.s_addr = htonl(INADDR_ANY);
	address.sin_port = htons(port);
	
	if (bind(sock, (sockaddr*)&address, sizeof(sockaddr_in)) < 0)
	{
		DDrStartupMessage("could not bind port %d", port);
		return false;
	}
	
	unsigned long nonBlocking = 1;
	if (ioctlsocket(sock, FIONBIO, &nonBlocking))
	{
		DDrStartupMessage("failed to set non-blocking socket");
		return false;
	}
	
	return sock;
}

bool Net_Send(int socket, int ip, uint16_t port, char* data, int datalen)
{
	sockaddr_in address;
	memset(&address, 0, sizeof(sockaddr_in));
	address.sin_family = AF_INET;
	address.sin_addr.s_addr = ip;
	address.sin_port = htons(port);
	
	return sendto(socket, data, datalen, 0, (sockaddr*)&address, sizeof(address));
}

void Net_CloseSocket(int sock)
{
	closesocket(sock);
}

bool FLrListen_PacketCallback(char* data, int datalen, int from)
{
	static int recieved = 0;
	
	data[datalen] = '\0';
	if (!strcmp(data, "hi"))
		printf("\r%d packets recieved                                ", ++recieved);
	return true;
}

bool FLrListen_Run()
{
	return Net_Listen(27777, FLrListen_PacketCallback);
}
