#pragma once

#include <stdlib.h>
#include <stdio.h>
#define DDrStartupMessage printf

#include <string.h>
#include <stdbool.h>
#include <stdint.h>

#ifdef WIN32
#include <winsock2.h>
#include "Flatline_Win32.h"
#else
#include <sys/ioctl.h> 
#include <sys/types.h>
#include <sys/socket.h> 
#include <unistd.h> 
#include <stropts.h>
#include <arpa/inet.h>
#include <netinet/in.h>

#define NetPlatform_Initalize() /* */
#define NetPlatform_Shutdown() /* */
#define closesocket close
#define ioctlsocket ioctl
#endif

typedef struct sockaddr sockaddr;
typedef struct sockaddr_in sockaddr_in;

bool Net_Listen(uint16_t port, bool (*packet_callback)(char* data, int datalen, int from));
int Net_CreateSocket(uint16_t port);
bool Net_Send(int socket, int ip, uint16_t port, char* data, int datalen);
void Net_CloseSocket(int sock);
bool FLrListen_PacketCallback(char* data, int datalen, int from);
bool FLrListen_Run();
