unit Exporters;

interface

uses Classes, Dialogs, StrUtils, SysUtils, Math, Data, OniImgClass;

procedure ExportDatFile(fileid: LongWord; filename: String);
procedure ExportRawFile(fileid: LongWord; dat_offset: LongWord; filename: String);

function ExportSNDD(fileid: LongWord; filename: String; convert: Boolean): Integer;
function ExportTRAC(fileid: LongWord; filename: String; convert: Boolean): Integer;
function ExportTXAN(fileid: LongWord; filename: String; convert: Boolean): Integer;
function ExportTXMB(fileid: LongWord; filename: String; convert: Boolean): Integer;
function ExportTXMP(fileid: LongWord; filename: String; convert: Boolean): Integer;

var
  ExportHandlers: array[1..1] of TExportHandlers = (
    //    (Ext:'ABNA'; needed:False),
    //(Ext:'AGDB'; needed:False),
    (Ext: 'SNDD'; needed: True; Handler: ExportSNDD)
{    (Ext:'TRAC'; needed:True; Handler:ExportTRAC),
    (Ext:'TXAN'; needed:True; Handler:ExportTXAN),
    (Ext:'TXMB'; needed:True; Handler:ExportTXMB),
    (Ext:'TXMP'; needed:True; Handler:ExportTXMP)
});



implementation

uses Functions, DataStructures, OniDataClass;




procedure ExportDatFile(fileid: LongWord; filename: String);
var
  filestream: TFileStream;
  Data: Tdata;
begin
  Data := OniDataConnection.LoadDatFile(fileid);
  if FileExists(filename) then
  begin
    filestream := TFileStream.Create(filename, fmOpenReadWrite);
    filestream.Seek(0, soFromEnd);
  end
  else
  begin
    filestream := TFileStream.Create(filename, fmCreate);
  end;
  filestream.Write(Data[0], Length(Data));
  filestream.Free;
end;




procedure ExportRawFile(fileid: LongWord; dat_offset: LongWord; filename: String);
var
  filestream: TFileStream;
  Data: Tdata;
begin
  SetLength(Data, OniDataConnection.GetRawInfo(fileid, dat_offset).raw_size);
  OniDataConnection.LoadRawFile(fileid, dat_offset, @Data[0]);
  if FileExists(filename + '.raw0x' + IntToHex(dat_offset, 8)) then
  begin
    filestream := TFileStream.Create(filename + '.raw0x' + IntToHex(
      dat_offset, 8), fmOpenReadWrite);
    filestream.Seek(0, soFromEnd);
  end
  else
  begin
    filestream := TFileStream.Create(filename + '.raw0x' + IntToHex(dat_offset, 8), fmCreate);
  end;
  filestream.Write(Data[0], Length(Data));
  filestream.Free;
end;




function ExportSNDD;
{  CONST
    WAVheader:Array[0..0] OF Byte=(
        Ord('R'),Ord('I'),Ord('F'),Ord('F'),0,0,0,0,Ord('W'),Ord('A'),Ord('V'),Ord('E'),
        Ord('f'),Ord('m'),Ord('t'),Ord(' '),24,0,0,0,
      );
}  type
  TDatData = record
    {0x00}
    _fileid:   LongWord;
    level:     LongWord;
    Flag:      LongWord;
    FormatTag: Word;
    ChanNo:    Word;
    {0x10}
    SampleRate: LongWord;
    BytesPSec: LongWord;
    BPSample:  LongWord;
    BitsPS:    LongWord;
    {0x20}
    Unknown:   array[1..7] of LongWord;
    Unknown2:  Word;
    {0x40}
    RawSize:   LongWord;
    RawPos:    LongWord;
  end;
var
  filestream: TFileStream;

  DatData:     TDatData;
  //Wave Header Stuff
  ASCII_Group: LongWord; //"RIFF"
  WAV_Len:     LongWord;
  ASCII_WAV:   LongWord; //"WAVE"
  ASCII_FMT:   LongWord; //"fmt "
  WAV_FMT_Len: LongWord;
  ASCII_DATA:  LongWord; //"data"
  WAV_FolLen:  LongWord;

  Data: Tdata;
begin
  Result := export_noerror;
  OniDataConnection.LoadDatFilePart(fileid, 0, SizeOf(DatData), @DatData);
  with DatData do
  begin
    //Initializing Header vars
    ASCII_Group := 1179011410; // 'RIFF'
    WAV_Len     := RAWSize + 70;
    ASCII_WAV   := 1163280727;  // 'WAVE'
    ASCII_FMT   := 544501094;   // 'fmt '
    WAV_FMT_Len := 50;          // 50 bytes
    ASCII_DATA  := 1635017060;  // 'data'
    WAV_FolLen  := RAWSize;
    SetLength(Data, RAWSize);
    OniDataConnection.LoadRawFile(fileid, $44, Data);

    filestream := TFileStream.Create(filename + '.raw', fmCreate);
    filestream.Write(Data[0], Length(Data));
    filestream.Free;

    if convert then
    begin
      //Now start packing this into a neat wave...
      filestream := TFileStream.Create(filename + '.wav', fmCreate);
      filestream.Write(ASCII_Group, SizeOf(ASCII_Group));
      filestream.Write(WAV_Len, SizeOf(WAV_Len));
      filestream.Write(ASCII_WAV, SizeOf(ASCII_WAV));
      filestream.Write(ASCII_FMT, SizeOf(ASCII_FMT));
      filestream.Write(WAV_FMT_Len, SizeOf(WAV_FMT_Len));
      filestream.Write(ChanNo, SizeOf(ChanNo));
      filestream.Write(Samplerate, SizeOf(Samplerate));
      filestream.Write(BytesPSec, SizeOf(BytesPSec));
      filestream.Write(BPSample, SizeOf(BPSample));
      filestream.Write(BitsPS, SizeOf(BitsPS));
      filestream.Write(Unknown[1], SizeOf(Unknown));
      filestream.Write(Unknown2, SizeOf(Unknown2));
      filestream.Write(ASCII_DATA, SizeOf(ASCII_DATA));
      filestream.Write(WAV_FolLen, SizeOf(WAV_FolLen));
      filestream.Write(Data[0], Length(Data));
      filestream.Free;
    end;
  end;
end;




function ExportTRAC;
var
  link: LongWord;
  linkcount: Word;
  i: LongWord;
begin
  Result := export_noerror;

  OniDataConnection.LoadDatFilePart(fileid, $18, SizeOf(link), @link);
  link := link div 256;

  OniDataConnection.LoadDatFilePart(fileid, $1E, SizeOf(linkcount), @linkcount);
  for i := 1 to linkcount do
  begin
    OniDataConnection.LoadDatFilePart(fileid, $20 + (i - 1) * 12 + 8, SizeOf(link), @link);
    link := link div 256;
  end;
end;




function ExportTXAN;
var
  loop_speed, unknown: Word;
  linkcount: LongWord;
  link: LongWord;
  i: Byte;
begin
  Result := export_noerror;

  OniDataConnection.LoadDatFilePart(fileid, $14, SizeOf(loop_speed), @loop_speed);
  OniDataConnection.LoadDatFilePart(fileid, $16, SizeOf(unknown), @unknown);

  OniDataConnection.LoadDatFilePart(fileid, $1C, SizeOf(linkcount), @linkcount);
  for i := 0 to linkcount - 1 do
  begin
    OniDataConnection.LoadDatFilePart(fileid, $20 + i * 4, SizeOf(link), @link);
    link := link div 256;
    if link = 0 then
      link := fileid - 1;
  end;
end;




function ExportTXMB;
var
  filestream: TFileStream;
  //    img:TImgPackage;
  Data: Tdata;
begin
  Result := export_noerror;
  if convert then
  begin
{      img:=LoadTXMBconnected(fileid);
      data:=ImgdataToBmp(img.imgx,img.imgy,img.imgdepth,img.storetype,img.imgdata);
      filestream:=TFileStream.Create(filename+'.bmp',fmCreate);
      filestream.Write(data[0],Length(data));
      filestream.Free;
}    end;
end;




function ExportTXMP;
var
  filestream: TFileStream;
  //    img:TImgPackage;
begin
  Result := export_noerror;
{    img:=LoadImgData(fileid);

    filestream:=TFileStream.Create(filename+'.raw',fmCreate);
    filestream.Write(img.imgdata[0],Length(img.imgdata));
    filestream.Free;

    IF convert THEN BEGIN
      img.imgdata:=ImgdataToBMP(img.imgx,img.imgy,img.imgdepth,img.storetype,img.imgdata);
      filestream:=TFileStream.Create(filename+'.bmp',fmCreate);
      filestream.Write(img.imgdata[0],Length(img.imgdata));
      filestream.Free;
    END;
}  end;

end.