#include <stdlib.h>
#include <stdarg.h>
#include <stdint.h>

#include "Daodan_Console.h"
#include "BFW_Utility.h"

void DDrConsole_Print(const char* text)
{
	COrTextArea_Print(COgConsoleLines, 1, COgDefaultTextShade, COgDefaultTextShadow, text, 0, COgFadeTimeValue);
}

void DDrConsole_PrintColored(const char* text, int priority, RGBA color, RGBA shade)
{
	int* intcolor = (int*)&color;
	int* intshade = (int*)&shade;
	COrTextArea_Print(COgConsoleLines, 1, *intcolor, *intshade, text, 0, COgFadeTimeValue);
}

void DDrConsole_PrintF(const char* fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	char* buffer = malloc(vsnprintf(NULL, 0, fmt, ap) + 1);
	
	vsprintf(buffer, fmt, ap);
	va_end(ap);

	DDrConsole_Print(buffer);
	free(buffer);
	return;
}

TStColorFormattingCharacter DDrDSayColors[] = {
	{'r', 0, 0, 0xFFEB5050},	//red
	{'y', 0, 0, 0xFFFCFF1C},	//yellow
	{'b', 0, 0, 0xFF93BBE9},	//blue
	{'u', 0, 0, 0xFFF67603},	//umber
	{'g', 0, 0, 0xFFA2DAA5},	//green
	{'l', 0, 0, 0xFFBE90D9},	//lilac
	{'o', 0, 0, 0xFFFBA500},	//orange
	{'c', 0, 0, 0xFF93EAEB},	//cyan
								//New Colors Here...
	{'k', 0, 0, 0xFF000000},	//black
	{'v', 0, 0, 0xFFEB40EB},	//violet
	{'w', 0, 0, 0xFFFFFFFF},	//white...
	{'e', 0, 0, 0xFF505050},	//darkgrey
	{'f', 0, 0, 0xFFAAAAAA},	//grey
	{0}							//POWER RANGERS GO!
};

		