#pragma once

#include <stdlib.h>
#include <stdio.h>
#define DDrStartupMessage printf

#include <string.h>
#include <stdbool.h>
#include <stdint.h>

#define thread __thread

#ifdef WIN32
#include <winsock2.h>
#include "Flatline_Win32.h"
#else
#include <sys/ioctl.h> 
#include <sys/types.h>
#include <sys/socket.h> 
#include <unistd.h> 
#include <stropts.h>
#include <arpa/inet.h>
#include <netinet/in.h>

#define NetPlatform_Initalize() /* */
#define NetPlatform_Shutdown() /* */
#define closesocket close
#define ioctlsocket ioctl
#endif

#define pad1_size (sizeof(int64_t) - sizeof(short))
#define pad2_size (128 - (sizeof(short) + pad1_size + sizeof(int64_t)))

typedef struct {
	short ss_family;
	char pad1[pad1_size];
	uint64_t pad64;
	char pad2[pad2_size];
} sockaddr_storage;

typedef struct sockaddr sockaddr;
typedef struct sockaddr_in sockaddr_in;
typedef sockaddr_storage sockaddr_in6;

bool NetUDPServer_Listen(uint16_t port, bool (*packet_callback)(char* data, int datalen, int from));
bool NetUDPServer_Send(sockaddr* address, char* data, int datalen);

int NetUDPSocket_Create(uint16_t port);
bool NetUDPSocket_Send(int socket, const sockaddr* address, const char* data, int datalen);
void NetUDPSocket_Close(int sock);

typedef struct {
	char signature[8];
	uint16_t protocol_version;
	char data[0];
} handshake_packet;

typedef struct {
	char country[2];
	char name[256];
} connect_send; //signature="CONNECT\0"

typedef struct {
	char name[256];
	uint32_t numplayers; //signature="STATUS\0\0"
} status_recv;


bool FLrServer_PacketCallback(char* data, int datalen, int from);
bool FLrServer_Run();
