/***************************************************************************\
| Project: AE Installer														|
| By: Gumby & Iritscen														|
| File: Globals.h															|
| Function: Contains most of the includes needed by the source, and some	|
|			defines, structs, and prototypes that help bridge certain		|
|			source files that need to talk to each other.					|
| Created: 04/11/2009 21:05:00												|
\***************************************************************************/


#pragma mark INCLUDES
#include <fstream>
#include <string>
#include <stdio.h>
#include <iostream>
#include <cctype>
#include <vector>
#include <errno.h>
#include <sstream>
#include "boost/thread.hpp"
#include "boost/tokenizer.hpp"
#include "boost/lexical_cast.hpp" // int -> string
#include "boost/algorithm/string.hpp"
#include "boost/filesystem.hpp" // includes all needed Boost.Filesystem declarations
using namespace boost::filesystem;
using namespace std;
#ifdef WIN32
#include <windows.h>
#else // assume we're on Mac
#include <stdlib.h>
#include <dirent.h>
#endif
#include "wx/wxprec.h"
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#pragma mark DEFINES
#define INSTALLER_VERSION		 "1.1" // only place in source we need to set this
#define UPDATE_LOG_READ_ERR		-1
#define UPDATE_INST_REPL_ERR	-2
#define UPDATE_MNTH_REQD_ERR	-3
#define UPDATE_NO_UPD_AVAIL		 0
#define UPDATE_SIMP_AVAIL		 1
#define UPDATE_GLOB_AVAIL		 2
#define UPDATE_INST_AVAIL		 3
#define UPDATE_CONT_UPD			 4

#pragma mark STRUCTS
struct ModPackage
{
	bool	isInstalled; // replace with function 
	string	installerVersion;
	string	name;
	string	modStringName;
	int	modStringVersion;
	string	platform;
	bool	hasOnis;
	bool	hasDeltas;
	bool	hasBSL;
	bool	hasAddon;
	bool	hasDats;
	string	category;
	string	creator;
	bool	isEngine;
	string	readme;
	bool	globalNeeded;
	ModPackage();
	
	bool operator < (const ModPackage &fs) const
	{ return (name < fs.name);}
	
	bool operator > (const ModPackage &fs) const
	{ return (name > fs.name);}
	
	bool operator == (const ModPackage &fs) const
	{ return (name == fs.name);}
};

struct Install_info_cfg
{
	string AEVersion, InstallerVersion, DaodanVersion, OniSplitVersion, WinGUIVersion, MacGUIVersion;
	bool patch, globalizationRequired;
	vector<string> deleteList;
	
	Install_info_cfg();
};


#pragma mark PROTOTYPES
void recompileAll(vector<string>);
int globalizeData(void);
bool CheckForGlobalization(bool);
int GetUpdateStatus(Install_info_cfg *, Install_info_cfg *, bool *);
bool ProcessInstallerUpdate(Install_info_cfg *, Install_info_cfg *);
bool ProcessAEUpdate(Install_info_cfg *, Install_info_cfg *, bool *);
void callRefreshMods(void);
string escapePath(string input);
void setStatusArea(string);
void setProgressBar(int);
void copy_directory(const path &from_dir_ph, const path &to_dir_ph);
void copy(const path &from_file_ph, const path &to_file_ph);
