/***************************************************************************\
| Project: AE Installer														|
| By: Gumby & Iritscen														|
| File: Installer.h															|
| Function: Contains the real meat of the installation process.				|
| Created: 24/05/2009 19:39:00												|
\***************************************************************************/

#ifndef DOUBLE_HEADER
#define DOUBLE_HEADER

#include <string>
#include <vector>
#include <iostream>
#include "globals.h"
#ifdef WIN32
#ifndef __GUICON_H__
#define __GUICON_H__
#endif
#include <fstream>
#include <windows.h>
#include <stdio.h>
#include <fcntl.h>
#include <io.h>

void RedirectIOToConsole();
// maximum mumber of lines the output console should have
static const WORD MAX_CONSOLE_LINES = 500;
#endif


#pragma mark GLOBALS
static string SLASHSLASH = "//";
static string DIRSLASH = "\\";
extern bool busy;
extern string strInstallCfg;// = "../GameDataFolder/Add.cfg";
extern Install_info_cfg currentAE, updateAE;
extern bool splitInstances;
extern string strImportOption;
extern string strOniSplit;
extern vector<ModPackage> globalPackages;
extern string strEUFN; // I don't mind long variable names, but even I think strEditionUpdateFolderName is a bit much
#ifndef WIN32
void Sleep(int ms); // crudely converts the Windows sleep() call, which operates in ms, to the Mac sleep() call that operates in seconds
#endif


#pragma mark PROTOTYPES
int mainMenu(void);
vector<string> getInstallString(string = strInstallCfg);
int installPackages(void);
int uninstallPackages(void);
int listInstalledPackages(void);
int printInstallerInfo(void);
ModPackage fileToModPackage(fstream&, string);
bool StringIsLegalPathForDeletion(string);
vector<ModPackage> getPackages(string packageDir = "./packages");
void MakePathLocalToGlobalize(string*);
bool SortBySize(string, string);
void tokenize(const string&, vector<string>&, const string& delimiters = " ");
void StripNewlines(string *);
void clearOldDats(void);
void writeInstalledMods( vector<string> );
void copyBSL( string, vector<string>&, ModPackage );
bool ReadInstallInfoCfg(fstream *, Install_info_cfg *);

/* End of File */

//End of File

#endif
