#!/bin/bash

WXLIBNAME_ALL=libwx*2.8*.dylib
BOOSTLIBNAME_ALL=libboost*.dylib
WX_SUFFIX_MED=2.8.0.dylib
WX_SUFFIX_LONG=2.8.0.6.0.dylib
BOOST_SUFFIX=xgcc40-mt-1_39.dylib
BOOST_SUFFIX_2=xgcc40-mt.dylib
APPNAME="Installer"

WXLIBDIR=~/Programming/Third-Party/Development/wxMac-2.8.10/build-dynamic-universal-10.6/lib
BOOSTLIBDIR=~/Programming/Third-Party/Development/boost_1_39_0/build-dynamic-universal
BINDIR=/Games/Oni-Test/Edition/install/$APPNAME.app/Contents/MacOS
SYSLIBDIR=/usr/local/lib


echo "Copying dynamic libraries to " $BINDIR " ..."
cp -R $WXLIBDIR/$WXLIBNAME_ALL $BINDIR

for file in `cat ~/Programming/Release/AE_Installer/projects/xcode/AE_Installer-GUI/libnames-boost.txt`
do
   cp -R $BOOSTLIBDIR/$file$BOOST_SUFFIX $BINDIR
   cp -R $BOOSTLIBDIR/$file$BOOST_SUFFIX_2 $BINDIR
done

cp ~/Programming/Third-Party/Development/libiconv-1.13/build-static-universal/lib/libiconv.2.dylib $BINDIR

for file in `cat ~/Programming/Release/AE_Installer/projects/xcode/AE_Installer-GUI/libnames-wx.txt`
do
   echo "Patching " $file "..."
   for fileother in `cat ~/Programming/Release/AE_Installer/projects/xcode/AE_Installer-GUI/libnames-wx.txt`
   do
      # patch all library internal cross references
      echo "   Patching " $fileother " with " $file "..."
      install_name_tool -change $SYSLIBDIR/$file$WX_SUFFIX_MED @executable_path/$file$WX_SUFFIX_MED $BINDIR/$fileother$WX_SUFFIX_MED
   done
   # patch current library itself
   install_name_tool -id  @executable_path/$file$WX_SUFFIX_LONG $BINDIR/$file$WX_SUFFIX_LONG
   # patch binary
   echo "   Patching " $APPNAME " with " $file "..."
   install_name_tool -change $SYSLIBDIR/$file$WX_SUFFIX_MED @executable_path/$file$WX_SUFFIX_MED $BINDIR/$APPNAME;
done

for file in `cat ~/Programming/Release/AE_Installer/projects/xcode/AE_Installer-GUI/libnames-boost.txt`
do
   echo "Patching " $file "..."
   for fileother in `cat ~/Programming/Release/AE_Installer/projects/xcode/AE_Installer-GUI/libnames-boost.txt`
   do
      # patch all library internal cross references
      echo "   Patching " $fileother " with " $file "..."
      install_name_tool -change $file$BOOST_SUFFIX @executable_path/$file$BOOST_SUFFIX $BINDIR/$fileother$BOOST_SUFFIX
   done
   # patch current library itself
   install_name_tool -id  @executable_path/$file$BOOST_SUFFIX $BINDIR/$file$BOOST_SUFFIX
   # patch binary
   echo "   Patching " $APPNAME " with " $file "..."
   install_name_tool -change $file$BOOST_SUFFIX @executable_path/$file$BOOST_SUFFIX $BINDIR/$APPNAME;
done

install_name_tool -change /usr/lib/libiconv.2.dylib @executable_path/libiconv.2.dylib $BINDIR/$APPNAME