/***************************************************************************\
| Project: AE Installer														|
| By: Gumby & Iritscen														|
| File: Main_Window.cpp														|
| Function: Handles the GUI.												|
| Created: 07/05/2009 20:38:25												|
\***************************************************************************/

#ifndef NTDDI_VERSION           
#define NTDDI_VERSION NTDDI_WIN7
#endif
#ifdef WIN32
#include <windows.h>
#include <shobjidl.h>
HWND Handle;
ITaskbarList *pTaskbarList;
ITaskbarList3 *pTaskbarList3;
#endif

#include <boost/thread/mutex.hpp>
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
#include "about.h"
#include "main_window.h"
#include "installer.h"
////@end includes

////@begin XPM images
#include "aelogosmall.xpm"
#include "undo.xpm"
#include "fileopen.xpm"
#include "filesaveas.xpm"
#include "quit.xpm"
////@end XPM images

bool busy = false;
int updateStatus;
bool installerJustUpdated = false;
vector<string> globalInstalledMods;
vector<ModPackage> globalPackages;
// Variable declarations
#ifdef WIN32
bool splitInstances = false;
string strImportOption = "-import:nosep";
string strOniSplit = "Onisplit.exe";
#else
bool splitInstances = false;
string strImportOption = "-import:sep";
string strOniSplit = "mono Onisplit.exe";
#endif

/*
* MainWindow type definition
*/

IMPLEMENT_CLASS( MainWindow, wxFrame )


/*
* MainWindow event table definition
*/

BEGIN_EVENT_TABLE( MainWindow, wxFrame )

////@begin MainWindow event table entries
    EVT_CHECKBOX( SelectAll_Checkbox, MainWindow::OnSelectAllCheckboxClick )

    EVT_BUTTON( Refresh_Button, MainWindow::OnRefreshButtonClick )

    EVT_LISTBOX( Mods_CheckboxList1, MainWindow::OnModsCheckboxList1Selected )
    EVT_CHECKLISTBOX( Mods_CheckboxList1, MainWindow::OnModsCheckboxList1Toggled )

    EVT_UPDATE_UI( ID_STATUSBAR, MainWindow::OnStatusbarUpdate )

    EVT_BUTTON( Install_Button, MainWindow::OnInstallButtonClick )

    EVT_RADIOBUTTON( Sep_RadioButton, MainWindow::OnSepRadioButtonSelected )

    EVT_RADIOBUTTON( NoSep_RadioButton, MainWindow::OnNoSepRadioButtonSelected )

    EVT_RADIOBUTTON( Seperated_RadioButton, MainWindow::OnSeperatedRadioButtonSelected )

    EVT_RADIOBUTTON( Complete_RadioButton, MainWindow::OnCompleteRadioButtonSelected )

    EVT_BUTTON( ReGlobalize_Button, MainWindow::OnReGlobalizeButtonClick )

    EVT_MENU( wxID_LOAD, MainWindow::OnLoadClick )

    EVT_MENU( wxID_SAVE, MainWindow::OnSaveClick )

    EVT_MENU( wxID_EXIT, MainWindow::OnExitClick )

    EVT_MENU( wxID_OPTIONS, MainWindow::OnOptionsClick )

    EVT_MENU( wxID_ABOUT, MainWindow::OnAboutClick )

	EVT_BUTTON( Dir_Button, MainWindow::OnDirButtonClick )
////@end MainWindow event table entries

END_EVENT_TABLE()


/*
* MainWindow constructors
*/

MainWindow::MainWindow()
{  
	Init();
}

MainWindow::MainWindow( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
	Init();
	Create( parent, id, caption, pos, size, style );
}


/*
* MainWindow creator
*/

bool MainWindow::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
	////@begin MainWindow creation
    wxFrame::Create( parent, id, caption, pos, size, style );

    CreateControls();
    SetIcon(GetIconResource(wxT("aelogosmall.png")));
    Centre();
	////@end MainWindow creation
	return true;
}

/*
* MainWindow destructor
*/

MainWindow::~MainWindow()
{
	////@begin MainWindow destruction
	////@end MainWindow destruction
}

/*
* Member initialisation
*/

void MainWindow::Init()
{
	////@begin MainWindow member initialisation
    MainSplitter = NULL;
    SelectAll = NULL;
    RefreshButton = NULL;
    Mods_CheckboxList = NULL;
    titleText = NULL;
    creatorText = NULL;
    descriptionText = NULL;
    StatusArea = NULL;
    ProgressBar = NULL;
    InstallButton = NULL;
    OptionsPanel = NULL;
    SepRadio = NULL;
    NoSepRadio = NULL;
    SeperatedRadio = NULL;
    CompleteRadio = NULL;
    ReglobalizeButton = NULL;

	ChangeDirectoryButton = NULL;
	////@end MainWindow member initialisation
}

/*
* Control creation for MainWindow
*/
wxStatusBar **TheStatusBar;
wxButton* TheInstallButton;
wxGauge* TheProgressBar;
void MainWindow::CreateControls()
{    
	////@begin MainWindow content construction
    MainWindow* itemFrame1 = this;

    wxMenuBar* menuBar = new wxMenuBar;
    wxMenu* itemMenu37 = new wxMenu;
    {
        wxMenuItem* menuItem = new wxMenuItem(itemMenu37, wxID_LOAD, _("&Load Configuration..."), wxEmptyString, wxITEM_NORMAL);
        wxBitmap bitmap(itemFrame1->GetBitmapResource(wxT("fileopen.xpm")));
        menuItem->SetBitmap(bitmap);
        itemMenu37->Append(menuItem);
    }
    {
        wxMenuItem* menuItem = new wxMenuItem(itemMenu37, wxID_SAVE, _("&Save Configuration..."), wxEmptyString, wxITEM_NORMAL);
        wxBitmap bitmap(itemFrame1->GetBitmapResource(wxT("filesaveas.xpm")));
        menuItem->SetBitmap(bitmap);
        itemMenu37->Append(menuItem);
    }
    itemMenu37->AppendSeparator();
    {
        wxMenuItem* menuItem = new wxMenuItem(itemMenu37, wxID_EXIT, _("Exit"), wxEmptyString, wxITEM_NORMAL);
        wxBitmap bitmap(itemFrame1->GetBitmapResource(wxT("quit.xpm")));
        menuItem->SetBitmap(bitmap);
        itemMenu37->Append(menuItem);
    }
    menuBar->Append(itemMenu37, _("&File"));
    wxMenu* itemMenu42 = new wxMenu;
    itemMenu42->Append(wxID_OPTIONS, _("Show Advanced Options..."), wxEmptyString, wxITEM_CHECK);
    menuBar->Append(itemMenu42, _("Options"));
//#ifdef WIN32
//	itemMenu44->Append(wxID_ABOUT, _("About"), wxEmptyString, wxITEM_NORMAL);
//	menuBar->Append(itemMenu44, _("Help"));
//#else
	itemMenu37->Append(wxID_ABOUT, _("About"), wxEmptyString, wxITEM_NORMAL);
//#endif	

    itemFrame1->SetMenuBar(menuBar);

    wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxVERTICAL);
    itemFrame1->SetSizer(itemBoxSizer2);

    MainSplitter = new wxSplitterWindow( itemFrame1, ID_SPLITTERWINDOW, wxDefaultPosition, wxSize(100, 100), wxSP_LIVE_UPDATE|wxNO_BORDER );
    MainSplitter->SetMinimumPaneSize(1);
    MainSplitter->SetName(_T("MainSplitter"));

    wxPanel* itemPanel4 = new wxPanel( MainSplitter, ID_PANEL, wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER|wxTAB_TRAVERSAL );
    wxBoxSizer* itemBoxSizer5 = new wxBoxSizer(wxVERTICAL);
    itemPanel4->SetSizer(itemBoxSizer5);

    wxBoxSizer* itemBoxSizer6 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer5->Add(itemBoxSizer6, 0, wxGROW|wxALL, 0);
    SelectAll = new wxCheckBox( itemPanel4, SelectAll_Checkbox, _("Select All/None"), wxDefaultPosition, wxDefaultSize, wxCHK_3STATE );
    SelectAll->SetValue(false);
    SelectAll->SetName(_T("SelectAll_Checkbox"));
    itemBoxSizer6->Add(SelectAll, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    RefreshButton = new wxBitmapButton( itemPanel4, Refresh_Button, itemFrame1->GetBitmapResource(wxT("undo.xpm")), wxDefaultPosition, wxDefaultSize, wxBU_AUTODRAW );
    RefreshButton->SetName(_T("RefreshButton"));
    itemBoxSizer6->Add(RefreshButton, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxTOP|wxBOTTOM, 5);

    wxArrayString Mods_CheckboxListStrings;
    Mods_CheckboxList = new wxCheckListBox( itemPanel4, Mods_CheckboxList1, wxDefaultPosition, wxDefaultSize, Mods_CheckboxListStrings, wxLB_HSCROLL );
    Mods_CheckboxList->SetName(_T("Mods_CheckboxList"));
    itemBoxSizer5->Add(Mods_CheckboxList, 1, wxGROW|wxALL, 0);

    wxPanel* itemPanel10 = new wxPanel( MainSplitter, DescriptionHolder_Panel, wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER|wxTAB_TRAVERSAL );
    itemPanel10->SetName(_T("DescriptionHolder_Panel"));
    wxBoxSizer* itemBoxSizer11 = new wxBoxSizer(wxVERTICAL);
    itemPanel10->SetSizer(itemBoxSizer11);

    wxBoxSizer* itemBoxSizer12 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer11->Add(itemBoxSizer12, 0, wxGROW|wxALL, 0);
    wxBoxSizer* itemBoxSizer13 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer12->Add(itemBoxSizer13, 1, wxALIGN_CENTER_VERTICAL|wxALL, 0);
    titleText = new wxTextCtrl( itemPanel10, Title_Text, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxTE_READONLY );
    titleText->SetName(_T("Title_Text"));
    titleText->SetBackgroundColour(wxColour(240, 240, 240));
    itemBoxSizer13->Add(titleText, 1, wxGROW|wxLEFT, 5);

    wxBoxSizer* itemBoxSizer15 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer12->Add(itemBoxSizer15, 1, wxGROW|wxALL, 0);
    creatorText = new wxTextCtrl( itemPanel10, Author_Text, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxTE_READONLY|wxTE_RIGHT );
    creatorText->SetName(_T("Author_Text"));
    creatorText->SetBackgroundColour(wxColour(240, 240, 240));
    itemBoxSizer15->Add(creatorText, 1, wxGROW|wxRIGHT, 5);

    wxStaticLine* itemStaticLine17 = new wxStaticLine( itemPanel10, wxID_STATIC, wxDefaultPosition, wxDefaultSize, wxLI_HORIZONTAL );
    itemStaticLine17->Show(false);
    itemBoxSizer11->Add(itemStaticLine17, 0, wxGROW|wxALL, 5);

    descriptionText = new wxTextCtrl( itemPanel10, Description_Text, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE|wxTE_READONLY|wxTE_RICH|wxTE_RICH2 );
    descriptionText->SetName(_T("DescriptionName"));
    descriptionText->SetBackgroundColour(wxColour(240, 240, 240));
    itemBoxSizer11->Add(descriptionText, 1, wxGROW|wxLEFT|wxRIGHT, 5);

    MainSplitter->SplitVertically(itemPanel4, itemPanel10, 200);
    itemBoxSizer2->Add(MainSplitter, 1, wxGROW|wxALL, 0);

    StatusArea = new wxStatusBar( itemFrame1, ID_STATUSBAR, 0 );
    StatusArea->SetName(_T("StatusArea"));
    StatusArea->SetFieldsCount(1);
	string versionText = "AE Installer v" + (string)INSTALLER_VERSION;
    StatusArea->SetStatusText(versionText.c_str(), 0);
    itemBoxSizer2->Add(StatusArea, 0, wxGROW|wxALL, 0);

    wxBoxSizer* itemBoxSizer20 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer2->Add(itemBoxSizer20, 0, wxGROW|wxALL, 0);

    ProgressBar = new wxGauge( itemFrame1, ProgressBar_Gauge, 1000, wxDefaultPosition, wxDefaultSize, wxGA_SMOOTH );
    ProgressBar->SetValue(0);
    itemBoxSizer20->Add(ProgressBar, 1, wxGROW|wxALL, 0);

    InstallButton = new wxButton( itemFrame1, Install_Button, _("Install!"), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer20->Add(InstallButton, 0, wxGROW|wxALL, 0);

    wxBoxSizer* itemBoxSizer23 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer2->Add(itemBoxSizer23, 0, wxGROW|wxALL, 0);

    OptionsPanel = new wxPanel( itemFrame1, ID_PANEL1, wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER|wxTAB_TRAVERSAL );
    itemBoxSizer2->Add(OptionsPanel, 0, wxGROW, 0);

    wxBoxSizer* itemBoxSizer25 = new wxBoxSizer(wxHORIZONTAL);
    OptionsPanel->SetSizer(itemBoxSizer25);

    wxBoxSizer* itemBoxSizer26 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer25->Add(itemBoxSizer26, 0, wxGROW|wxALL, 5);

    SepRadio = new wxRadioButton( OptionsPanel, Sep_RadioButton, _("Sep"), wxDefaultPosition, wxDefaultSize, wxRB_GROUP );
    SepRadio->SetValue(false);
    if (MainWindow::ShowToolTips())
        SepRadio->SetToolTip(_("For PC Demo and Mac"));
    itemBoxSizer26->Add(SepRadio, 0, wxALIGN_LEFT|wxALL, 5);

    NoSepRadio = new wxRadioButton( OptionsPanel, NoSep_RadioButton, _("NoSep"), wxDefaultPosition, wxDefaultSize, 0 );
    NoSepRadio->SetValue(false);
    if (MainWindow::ShowToolTips())
        NoSepRadio->SetToolTip(_("For PC Retail"));
    itemBoxSizer26->Add(NoSepRadio, 0, wxALIGN_LEFT|wxALL, 5);

    wxStaticLine* itemStaticLine29 = new wxStaticLine( OptionsPanel, wxID_STATIC, wxDefaultPosition, wxDefaultSize, wxLI_VERTICAL );
    itemBoxSizer25->Add(itemStaticLine29, 0, wxGROW|wxALL, 5);

    wxBoxSizer* itemBoxSizer30 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer25->Add(itemBoxSizer30, 0, wxGROW|wxALL, 5);

    SeperatedRadio = new wxRadioButton( OptionsPanel, Seperated_RadioButton, _("Separated Level0"), wxDefaultPosition, wxDefaultSize, wxRB_GROUP );
    SeperatedRadio->SetValue(false);
    SeperatedRadio->SetName(_T("Seperated_RadioButton"));
    itemBoxSizer30->Add(SeperatedRadio, 0, wxALIGN_LEFT|wxALL, 5);

    CompleteRadio = new wxRadioButton( OptionsPanel, Complete_RadioButton, _("Complete Level0"), wxDefaultPosition, wxDefaultSize, 0 );
    CompleteRadio->SetValue(false);
    CompleteRadio->SetName(_T("Complete_RadioButton"));
    itemBoxSizer30->Add(CompleteRadio, 0, wxALIGN_LEFT|wxALL, 5);

    wxStaticLine* itemStaticLine33 = new wxStaticLine( OptionsPanel, wxID_STATIC, wxDefaultPosition, wxDefaultSize, wxLI_VERTICAL );
    itemBoxSizer25->Add(itemStaticLine33, 0, wxGROW|wxALL, 5);

    wxBoxSizer* itemBoxSizer34 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer25->Add(itemBoxSizer34, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    ReglobalizeButton = new wxButton( OptionsPanel, ReGlobalize_Button, _("Reglobalize"), wxDefaultPosition, wxDefaultSize, 0 );
    ReglobalizeButton->SetName(_T("Reglobalize_Button"));
    itemBoxSizer34->Add(ReglobalizeButton, 0, wxGROW|wxALL, 5);

    wxStaticLine* itemStaticLine100 = new wxStaticLine( OptionsPanel, wxID_STATIC, wxDefaultPosition, wxDefaultSize, wxLI_VERTICAL );
    itemBoxSizer25->Add(itemStaticLine100, 0, wxGROW|wxALL, 5);

	ChangeDirectoryButton =  new wxButton( OptionsPanel, Dir_Button, _("Change Dir"), wxDefaultPosition, wxDefaultSize, 0 );
	ChangeDirectoryButton->SetName(_T("Dir_Button"));
	itemBoxSizer34->Add(ChangeDirectoryButton, 0, wxGROW|wxALL, 5);

	// Connect events and objects
    Mods_CheckboxList->Connect(Mods_CheckboxList1, wxEVT_CREATE, wxWindowCreateEventHandler(MainWindow::ModList_OnCreate), NULL, this);
	////@end MainWindow content construction
#ifdef WIN32
	Handle = (HWND)GetHWND();
	::CoCreateInstance(CLSID_TaskbarList, NULL, CLSCTX_INPROC_SERVER, IID_ITaskbarList, (void **)&pTaskbarList);
#endif

	updateStatus = GetUpdateStatus(&currentAE, &updateAE, &installerJustUpdated);
	
	globalPackages = getPackages();
	globalInstalledMods = getInstallString();
	for (unsigned int i = 0; i < globalPackages.size(); i++)
	{
		Mods_CheckboxList->Append(globalPackages[i].name.c_str());
		if (binary_search(globalInstalledMods.begin(), globalInstalledMods.end(), globalPackages[i].modStringName)) Mods_CheckboxList->Check(i);
	}

	TheStatusBar = &StatusArea;
	TheInstallButton = InstallButton;
	TheProgressBar = ProgressBar;
	OptionsPanel->Hide();
	
	if(splitInstances) SeperatedRadio->SetValue(true);
	else CompleteRadio->SetValue(true);
	if(strImportOption == "-import:nosep") NoSepRadio->SetValue(true);
	else SepRadio->SetValue(true);

#ifdef WIN32
	RedirectIOToConsole(); 
	HWND hWnd = GetConsoleWindow(); 
	ShowWindow( hWnd, SW_HIDE ); 
#endif
}

/*
* wxEVT_COMMAND_CHECKBOX_CLICKED event handler for SelectAll_Checkbox
*/

void MainWindow::OnSelectAllCheckboxClick( wxCommandEvent& event )
{
	switch(SelectAll->Get3StateValue()) {
	case wxCHK_UNCHECKED:
		for(unsigned int i = 0; i < globalPackages.size(); i++) Mods_CheckboxList->Check(i, false);
		break;
	case wxCHK_CHECKED:
		for(unsigned int i = 0; i < globalPackages.size(); i++) Mods_CheckboxList->Check(i, true);
		break;
	case wxCHK_UNDETERMINED:
		for(unsigned int i = 0; i < globalPackages.size(); i++) Mods_CheckboxList->Check(i, false);
		break;
	}
}

/*
* wxEVT_CREATE event handler for Mods_CheckboxList
*/

void MainWindow::ModList_OnCreate( wxWindowCreateEvent& event )
{

}


/*
* Should we show tooltips?
*/

bool MainWindow::ShowToolTips()
{
	return true;
}

/*
* Get bitmap resources
*/

wxBitmap MainWindow::GetBitmapResource( const wxString& name )
{
	// Bitmap retrieval
	////@begin MainWindow bitmap retrieval
    wxUnusedVar(name);
    if (name == _T("undo.xpm"))
    {
        wxBitmap bitmap( undo_xpm);
        return bitmap;
    }
    else if (name == _T("fileopen.xpm"))
    {
        wxBitmap bitmap( fileopen_xpm);
        return bitmap;
    }
    else if (name == _T("filesaveas.xpm"))
    {
        wxBitmap bitmap( filesaveas_xpm);
        return bitmap;
    }
    else if (name == _T("quit.xpm"))
    {
        wxBitmap bitmap( quit_xpm);
        return bitmap;
    }
    return wxNullBitmap;
	////@end MainWindow bitmap retrieval
}

/*
* Get icon resources
*/

wxIcon MainWindow::GetIconResource( const wxString& name )
{
	// Icon retrieval
	////@begin MainWindow icon retrieval
    wxUnusedVar(name);
    if (name == _T("aelogosmall.png"))
    {
        wxIcon icon(aelogosmall_xpm);
        return icon;
    }
    return wxNullIcon;
	////@end MainWindow icon retrieval
}

/*
* wxEVT_COMMAND_LISTBOX_SELECTED event handler for Mods_CheckboxList1
*/

void MainWindow::OnModsCheckboxList1Selected( wxCommandEvent& event )
{
	titleText->SetValue(globalPackages[event.GetSelection()].name.c_str());
	creatorText->SetValue(globalPackages[event.GetSelection()].creator.c_str());
	descriptionText->SetValue(globalPackages[event.GetSelection()].readme.c_str());
}

/*
* wxEVT_COMMAND_CHECKLISTBOX_TOGGLED event handler for Mods_CheckboxList1
*/

void MainWindow::OnModsCheckboxList1Toggled( wxCommandEvent& event )
{
	SelectAll->Set3StateValue(wxCHK_UNDETERMINED);
	if(event.GetInt()) {
		/*
		switch(SelectAll->Get3StateValue()) {
		case wxCHK_UNCHECKED:
		break;
		case wxCHK_CHECKED:
		break;
		case wxCHK_UNDETERMINED :
		break;
		}
		*/
	}
}


/*
* wxEVT_COMMAND_MENU_SELECTED event handler for wxID_OPTIONS
*/

void MainWindow::OnOptionsClick( wxCommandEvent& event )
{
	if (!event.GetInt() ) {
		OptionsPanel->Hide(); 
		
		this->SetSize(this->GetRect().GetWidth(), this->GetRect().GetHeight()-OptionsPanel->GetRect().GetHeight());}
	else {
		wxMessageDialog* YesNoDialog = new wxMessageDialog(this, "WARNING: These options are for advanced users only, use with caution.",
														   "AE Installer Alert",  wxOK | wxICON_EXCLAMATION	, wxDefaultPosition);
		YesNoDialog->ShowModal();
		OptionsPanel->Show();
		this->SetSize(this->GetRect().GetWidth(), this->GetRect().GetHeight()+OptionsPanel->GetRect().GetHeight()+1);
		this->SetSize(this->GetRect().GetWidth(), this->GetRect().GetHeight()-1);
	}
}

/*
* wxEVT_COMMAND_MENU_SELECTED event handler for wxID_EXIT
*/

void MainWindow::OnExitClick( wxCommandEvent& event )
{
	exit(0);
}

/*
* wxEVT_COMMAND_BUTTON_CLICKED event handler for Install_Button
*/

struct recompile
{
	recompile(vector<string> localPackages) : thePackages(localPackages) { }
	void operator()()
	{
		TheInstallButton->Disable();
		recompileAll(thePackages);
		TheInstallButton->Enable();
		
	}
	vector<string> thePackages;
};

void globalize2(void) {
		TheInstallButton->Disable();
		globalizeData();
		TheInstallButton->Enable();
}

void MainWindow::OnInstallButtonClick( wxCommandEvent& event )
{
	vector<string> localPackages;
	localPackages.push_back("00000Globalize");
	for(unsigned int i = 0; i < globalPackages.size(); i++) if(Mods_CheckboxList->IsChecked(i)) localPackages.push_back( globalPackages[i].modStringName );
	if ( !localPackages.empty() )	{
		sort(localPackages.begin(), localPackages.end());
		localPackages[0] = "Globalize";
		this->InstallButton->Disable();
		this->ReglobalizeButton->Disable();
#ifdef WIN32
		recompile packages(localPackages);
		boost::thread thrd(packages);
#else
		recompileAll(localPackages);
#endif
		this->InstallButton->Enable();
		this->ReglobalizeButton->Enable();
	}
}

void setProgressBar( int i )
{
#ifdef WIN32
if (SUCCEEDED(pTaskbarList->QueryInterface(IID_ITaskbarList3, (void **)&pTaskbarList3)))
{
	pTaskbarList3->SetProgressValue(Handle,i, 1000);
	if ( i == 0 )
	{
		pTaskbarList3->SetProgressState(Handle,TBPF_NOPROGRESS);
	}
}
#endif
	TheProgressBar->SetValue(i);
}

/*
* wxEVT_UPDATE_UI event handler for ID_STATUSBAR
*/

void MainWindow::OnStatusbarUpdate( wxUpdateUIEvent& event )
{
	////@begin wxEVT_UPDATE_UI event handler for ID_STATUSBAR in MainWindow.
    // Before editing this code, remove the block markers.
    event.Skip();
	////@end wxEVT_UPDATE_UI event handler for ID_STATUSBAR in MainWindow. 
}

/*
* wxEVT_COMMAND_MENU_SELECTED event handler for wxID_ABOUT
*/

void MainWindow::OnAboutClick( wxCommandEvent& event )
{
	////@begin wxEVT_COMMAND_MENU_SELECTED event handler for wxID_ABOUT in MainWindow.
    // Before editing this code, remove the block markers.
    About* window = new About(this);
	window->ShowModal();
    window->Destroy();
	////@end wxEVT_COMMAND_MENU_SELECTED event handler for wxID_ABOUT in MainWindow. 
}

/*
* wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for NoSep_RadioButton
*/
 
void MainWindow::OnNoSepRadioButtonSelected( wxCommandEvent& event )
{
	static_cast<string>("-import:nosep");
}

/*
* wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for Sep_RadioButton
*/

void MainWindow::OnSepRadioButtonSelected( wxCommandEvent& event )
{
	static_cast<string>("-import:sep");
}

/*
* wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for Separated_RadioButton
*/

/*
* wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for Complete_RadioButton
*/

void MainWindow::OnCompleteRadioButtonSelected( wxCommandEvent& event )
{
	splitInstances = false;
}

/*
* wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BITMAPBUTTON
*/

void MainWindow::OnRefreshButtonClick( wxCommandEvent& event )
{
	globalPackages = getPackages();
	refreshMods(globalInstalledMods);
}

/*
* wxEVT_COMMAND_MENU_SELECTED event handler for wxID_LOAD
*/

void MainWindow::refreshMods (vector<string> s)
{
	Mods_CheckboxList->Clear();
	for (unsigned int i = 0; i < globalPackages.size(); i++) {
		Mods_CheckboxList->Append(globalPackages[i].name.c_str());
		if( binary_search(s.begin(), s.end(), globalPackages[i].modStringName ) )
			Mods_CheckboxList->Check(i);
	}
}

void MainWindow::OnLoadClick( wxCommandEvent& event )
{
	if (busy == 1) return;
	static const wxChar *FILETYPES = _T(
		"Mod Loadouts (*.cfg)|*.cfg|"
		"All files (*.*)|*.*"
		);

	wxFileDialog* openFileDialog =
		new wxFileDialog( this, _("Open Mod Loadout"), "", "", FILETYPES,
		wxOPEN, wxDefaultPosition);

	if ( openFileDialog->ShowModal() == wxID_OK )
	{
		refreshMods(getInstallString( string(openFileDialog->GetPath()) ));
	}
}

/*
* wxEVT_COMMAND_MENU_SELECTED event handler for wxID_SAVE
*/

void MainWindow::OnSaveClick( wxCommandEvent& event )
{
	if (busy == 1) return;
	static const wxChar *FILETYPES = _T(
		"Mod Loadouts (*.cfg)|*.cfg|"
		"All files (*.*)|*.*"
		);

	wxFileDialog* openFileDialog =
		new wxFileDialog( this, _("Open file"), "", "", FILETYPES,
		wxSAVE, wxDefaultPosition);

	if ( openFileDialog->ShowModal() == wxID_OK )
	{
		if ( exists( openFileDialog->GetPath().c_str() ) )
		{
			remove( openFileDialog->GetPath().c_str() );
		}

		ofstream file(openFileDialog->GetPath().c_str());

		vector<string>list;
		for(unsigned int i = 0; i < globalPackages.size(); i++) if(Mods_CheckboxList->IsChecked(i)) list.push_back( globalPackages[i].modStringName );
		vector<string>::iterator begin_iter = list.begin(); 
		vector<string>::iterator end_iter = list.end();

		sort( list.begin(), list.end() );

		for( ; begin_iter != end_iter; ++begin_iter) {
			file << *begin_iter << " ";
		}

		file.close();
		file.clear();
	}
}

/*
* wxEVT_COMMAND_BUTTON_CLICKED event handler for ReGlobalize_Button
*/

void MainWindow::OnReGlobalizeButtonClick( wxCommandEvent& event )
{
	string YesNoMsg = "WARNING: This will DELETE the Edition's GameDataFolder and recreate it from the vanilla Oni game data.\n";
	YesNoMsg = YesNoMsg + "Are you SURE you want to do this?";
	wxMessageDialog* YesNoDialog = new wxMessageDialog(this, YesNoMsg.c_str(), "AE Installer Alert",  wxYES_NO | wxICON_EXCLAMATION	, wxDefaultPosition);

	if (YesNoDialog->ShowModal() == wxID_NO)
	{
		//if the user said no...
	}
	else
	{
		this->InstallButton->Disable();
		this->ReglobalizeButton->Disable();
#ifdef WIN32
		boost::thread thrd2(globalizeData);
		//globalizeData();
		//boost::thread::create_thread(&globalizeData);
		//	 boost::thread_group Tg;
		// Tg.create_thread( &globalizeData(), this );
#else
		globalizeData();
#endif
		this->InstallButton->Enable();
		this->ReglobalizeButton->Enable();
	}
}
/*
* wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for Separated_RadioButton
*/

/*
 * wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for Seperated_RadioButton
 */

void MainWindow::OnSeperatedRadioButtonSelected( wxCommandEvent& event )
{
	splitInstances = true;
}

void MainWindow::OnDirButtonClick( wxCommandEvent& event )
{
	wxDirDialog* newDir = new wxDirDialog(this, "Set current directory", "", wxDD_DEFAULT_STYLE,
		wxDefaultPosition, wxDefaultSize, "wxDirCtrl");
	newDir->ShowModal();
	if(newDir->GetPath()[0]) current_path( (path)newDir->GetPath() );
	OnRefreshButtonClick(event);
}