#pragma once
#ifndef FLATLINE_H
#define FLATLINE_H

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
//#define DDrStartupMessage printf

#include <string.h>
#include "bool.h"
////#include <stdint.h>

#define thread __thread

#ifdef WIN32
#include <winsock2.h>
#include "Flatline_Win32.h"
#else
#include <sys/ioctl.h> 
#include <sys/types.h>
#include <sys/socket.h> 
#include <unistd.h> 
#include <stropts.h>
#include <arpa/inet.h>
#include <netinet/in.h>

#define NetPlatform_Initalize() /* */
#define NetPlatform_Shutdown() /* */
#define closesocket close
#define ioctlsocket ioctl
#endif

#include "Daodan.h"
#include "BFW_Utility.h"
#include "Daodan_Console.h"
#include "Oni_Character.h"


#define pad1_size (sizeof(int64_t) - sizeof(short))
#define pad2_size (128 - (sizeof(short) + pad1_size + sizeof(int64_t)))

#define breakpoint asm("int3")

typedef struct {
	short ss_family;
	char pad1[pad1_size];
	uint64_t pad64;
	char pad2[pad2_size];
} sockaddr_storage;

typedef struct sockaddr sockaddr;
typedef struct sockaddr_in sockaddr_in;
typedef sockaddr_storage sockaddr_in6;

bool NetUDPServer_Listen(uint16_t port, bool (*packet_callback)(char* data, int datalen, int from));
bool NetUDPServer_Send(sockaddr* address, char* data, int datalen);

int NetUDPSocket_Create(uint16_t port);
int NetUDPSocket_Send(int socket, const sockaddr* address, const char* data, int datalen);
void NetUDPSocket_Close(int sock);
bool NetUDPSocket_Recieve(int socket, sockaddr_storage* address, char* data, uint16_t* datalen);

DWORD WINAPI StartServer(void* lol);
DWORD WINAPI StartClient(void* lol);

//oh snap, I just realized this is rossy's version of flatline_packet. :|
typedef struct {
	char signature[8];
	uint16_t protocol_version;
	char data[0];				//data[0] doesn't work well with simple casts, btw. If you allocate enough space for a handshake_packet
} handshake_packet;				//there won't be enough room for data. You would have to manually manage the memory (ew)

//initial connection
typedef struct {
	char country[2];
	char name[256];
} connect_send; //signature="CONNECT\0"

//reply to connection.
//goodtogo is if it is going to let you in
//message is optional, only used for denial message
typedef struct {
	bool goodtogo;
	int player_slot;
	char message[256];
} connect_reply;

//um, status of the server? :/
typedef struct {
	char name[256];
	uint32_t numplayers; //signature="STATUS\0\0"
} server_status;

typedef struct {
	uint16_t	 Playernumber;
	CharacterObject Character;
} new_player;

extern int update_rate;

typedef struct {
	float MouseDeltaX;
	float MouseDeltaY;
	uint32_t Actions1;
	uint32_t Actions2;
} input_struct;

//TODO:
//Varient
//Figure out + fix overlays
//AC->HeadFacing
//AC->HeadPitch
typedef struct {
	uint16_t PlayerNum;
	Vector3 Position;
	Vector3 LastPosition;
	Vector3 Location;
	float Facing;
	float DesiredFacing;
	float CosmeticFacing;
	uint32_t Health;
	uint32_t MaxHealth;
	input_struct Inputs;
#if 0
	uint16_t Frame;
	char Animation[32];
	uint16_t AnimationToState;
	uint16_t AnimationFromState;
	uint16_t AnimationType;
	uint16_t NextAnimationType;
	uint16_t AnimationType2;
	__int16 InterpolationCurrentFrame;
	__int16 InterpolationFromState;
	__int16	InterpolationLength;
	Quaternion InterpolationStartRotations[19];
	Vector3 StitchVelocity;
	int		StitchHeight;
	char	Stitch;
	Quaternion BoneMatrices[19];
	int Overlay;
	Quaternion OverlayRotations[19];
#endif
} player_data;

//used for storing data about each player
typedef struct {
	int	FLATLINE;
	char	id;
	int		packet_index;
	union	payload
	{
		char			data[1080];
		connect_reply	connect_reply;
		connect_send	connect_send;
		input_struct	input_struct;
		new_player		new_player;
		server_status	server_status;
		player_data		player_data;
	};
} flatline_packet;
#define FLATLINE_HEADER sizeof(flatline_packet)-sizeof(char)*1080
//#define FLATLINE_PACKET_SIZE sizeof(flatline_packet) 


bool FLrServer_PacketCallback(char* data, int datalen, int from);
bool FLrServer_Run();
bool FLrClient_Run(flatline_packet* packet);
extern int sock;

enum {
	CONNECT_SEND,
	CONNECT_REPLY,
	STATUS,
	MESSAGE,
	CHANGE_NAME,
	ECHO,
	NEW_PLAYER,
	PLAYER_INPUT,
	PLAYER_DATA,
};


typedef struct {
	int	 ip;
	char name[32];
	char country[2];
	Character* Chr;
	uint16_t spawnnumber;
	uint16_t list_slot;
	uint32_t Actions1;
	uint32_t Actions2;
	float MouseDeltaX;
	float MouseDeltaY;
} player_info;

player_info * FLr_FindEmptySlot();
uint16_t FLr_FindEmptyListSlot();
void * ONICALL FLrInput_Update_Keys(void);

void NetCatchError();
#define MAX_PLAYERS 128
#define CONNECTION_TIMEOUT 15
#define MAX_CONNECTIONS 32
#define NetTCPSocket_Send NetUDPSocket_Send
#define NetTCPServer_Send NetUDPServer_Send
extern int client_sock;
//these two could probably be combined
extern sockaddr_in client_address;
extern sockaddr_in address;
extern player_info Players[];
extern player_info * PlayerList[];
int UDPServer_SendToAll(void* packet, int size);
extern bool client_connected;
extern bool server_started;
extern char player_name[];

#endif