#include <stdio.h>
#include "bool.h"
#include <string.h>
#include "inifile.h"

bool ini_callback(char* section, bool newsection, char* name, char* value)
{
	if (newsection)
		puts("New Section!");
	printf("Section: %s Name: %s Value: %s\n", section, name, value);
	if (!_stricmp(name, "cleantest"))
		printf("  CleanTest: \"%s\" = \"%s\"\n", value, inifile_cleanstr(value));
	if (!_stricmp(name, "inttest"))
		printf("  IntTest: %s = %u\n", value, (uint32_t)inifile_parseint(value, false));
	if (!_stricmp(name, "sinttest"))
		printf("  IntTest: %s = %d\n", value, (int32_t)inifile_parseint(value, true));
	return true;
}

int main()
{
	if (!inifile_read("testini.ini", ini_callback))
		puts("Read error!");
	return 0;
}
