#include "Daodan_Patch.h"
#include <windows.h>
#include <stdlib.h>
#include <string.h>

bool DDrPatch_MakeJump(void* from, void* to)
{
	DWORD oldp;
	
	if (VirtualProtect(from, 5, PAGE_EXECUTE_READWRITE, &oldp))
	{
		*((char*)from)++ = 0xe9; // jmp rel32
		*(int*)from = (unsigned int)to - (unsigned int)from - 4;
		VirtualProtect(from, 5, oldp, &oldp);
		return true;
	}
	else
		return false;
}

bool DDrPatch_MakeCall(void* from, void* to)
{
	DWORD oldp;
	
	if (VirtualProtect(from, 5, PAGE_EXECUTE_READWRITE, &oldp))
	{
		*((char*)from)++ = 0xe8; // call rel32
		*(int*)from = (unsigned int)to - (unsigned int)from - 4;
		VirtualProtect(from, 5, oldp, &oldp);
		return true;
	}
	else
		return false;
}

bool DDrPatch_String(char* dest, const char* string, int length)
{
	DWORD oldp;
	
	if (VirtualProtect(dest, length, PAGE_EXECUTE_READWRITE, &oldp))
	{
		memcpy(dest, string, length);
		VirtualProtect(dest, length, oldp, &oldp);
		return true;
	}
	else
		return false;
}

bool DDrPatch_Byte(char* dest, char value)
{
	DWORD oldp;
	
	if (VirtualProtect(dest, 1, PAGE_EXECUTE_READWRITE, &oldp))
	{
		*dest = value;
		VirtualProtect(dest, 1, oldp, &oldp);
		return true;
	}
	else
		return false;
}

bool DDrPatch_Int32(int* dest, int value)
{
	DWORD oldp;
	
	if (VirtualProtect(dest, 4, PAGE_EXECUTE_READWRITE, &oldp))
	{
		*dest = value;
		VirtualProtect(dest, 4, oldp, &oldp);
		return true;
	}
	else
		return false;
}

bool DDrPatch_Int16(char* dest, short value)
{
	DWORD oldp;
	
	if (VirtualProtect(dest, 2, PAGE_EXECUTE_READWRITE, &oldp))
	{
		*dest = value;
		VirtualProtect(dest, 2, oldp, &oldp);
		return true;
	}
	else
		return false;
}

bool DDrPatch__strdup(int* dest, const char* value)
{
	DWORD oldp;
	
	if (VirtualProtect(dest, 4, PAGE_EXECUTE_READWRITE, &oldp))
	{
		*dest = (int)_strdup(value);
		VirtualProtect(dest, 4, oldp, &oldp);
		return true;
	}
	else
		return false;
}

bool DDrPatch_NOOP(char* dest, unsigned int length)
{
	DWORD oldp;
	
	if (VirtualProtect(dest, length, PAGE_EXECUTE_READWRITE, &oldp))
	{
		memset(dest, 0x90, length);
		VirtualProtect(dest, length, oldp, &oldp);
		return true;
	}
	else
		return false;
}
