#include "Flatline.h"
#include "Flatline_Server.h"

int total_players = 0;
uint16_t max_connections = MAX_CONNECTIONS;

player_info* FLrServer_AddPlayer(int ip, char* name, bool is_server, bool is_bot) {
	flatline_packet new_char = {0};
	CharacterObject* Char;
	uint32_t player_slot = 0;
	int playerlist_slot = 0;
	if(is_server) goto server;
	if(total_players < max_connections) {
		char* zero = strchr(name, 0);
		int i = 0;
		int k = 0;
		playerlist_slot = FLr_FindEmptyListSlot();
		

		total_players++;

		//send new player packet to all players
		//char tempname[32] = {0};

		//checks to see if a name exists or not
		//then appends [#] on the end of it if it does
		
		if(zero - name > 28) zero = name + 28; 
		for(i = 0; i < max_connections; i++) {
			if(PlayerList[i] != 0 && !strcmp(name, PlayerList[i]->name)) {
				k++;				
				sprintf(zero, "[%i]", k);
				i = 0;
			}
		}

server:		;
		//memset( new_char, 0, sizeof(new_char);
		//new_char = {0};
		new_char.new_player.Playernumber = playerlist_slot; 
		Char = &new_char.new_player.Character;
		memset(Char, 0, sizeof(CharacterObject));
		Char->Header.Type = 'CHAR';
		//Char->OSD.Options = char_dontaim;
		sprintf(Char->OSD.Name,"%s",name);
		sprintf(Char->OSD.Class, "%s", "konoko_generic");
		if(is_bot) {
			Char->OSD.MeleeID = 22;
			Char->OSD.JobID = 1;
			Char->OSD.MinimalAlertLevel = 4;
			Char->OSD.InvestigatingAlertLevel = 4;
			Char->OSD.InitialAlertLevel = 4;
			Char->OSD.StartJobAlertLevel = 4;
		}
		else if( !is_server )
		{
			Char->Header.Position.X = PlayerList[0]->Chr->Position.X;
			Char->Header.Position.Y = PlayerList[0]->Chr->Position.Y;
			Char->Header.Position.Z = PlayerList[0]->Chr->Position.Z;
		}
		
		//TMrInstance_GetDataPtr('ONCC', "striker_easy_1", PlayerList[playerlist_slot]->Chr->ONCC);
		

		new_char.id = NEW_PLAYER;
		if(!is_server) { 
			ONrGameState_NewCharacter(Char, NULL, NULL, &(player_slot));
			//move this to a set up characters function...
			if(!is_bot) ONgGameState->CharacterStorage[player_slot].charType = 0;

			PlayerList[playerlist_slot] = Players+player_slot;
			PlayerList[playerlist_slot]->spawnnumber = player_slot;
			PlayerList[playerlist_slot]->Chr = &((Character *)(((GameState * )(ONgGameState))->CharacterStorage))[player_slot];
//			PlayerList[playerlist_slot]->Chr->Flags = chr_dontaim | chr_unkillable; //&= 0xFFBFFFFF; //WTF
			if(!is_bot) PlayerList[playerlist_slot]->Chr->Flags &= 0xFFBFFFFF; //WTF
			sprintf(PlayerList[playerlist_slot]->Chr->Name, "%.31s", name);		
			UDPServer_SendToAll( (char*)&new_char, sizeof(new_player) + FLATLINE_HEADER );
			
		}
		else {
			PlayerList[0] = Players;
			PlayerList[0]->Chr = (Character *)(((GameState * )(ONgGameState))->CharacterStorage);
		}

		//add player to list
		
		PlayerList[playerlist_slot]->ip = ip;
		PlayerList[playerlist_slot]->list_slot = playerlist_slot;
		sprintf(PlayerList[playerlist_slot]->name,"%.31s",name);
		
		return &Players[player_slot];
	}
	return (player_info*)(-1);
}

void FLrServer_Initialize(){
	FLrServer_AddPlayer(inet_addr("127.0.0.1"), "host", 1, 0);
}

//UDPServer_SendToAll
//Sends a packet to all the clients currently connected.
//Returns the number of players sent to.
int UDPServer_SendToAll(void* packet, int size) {
	int j;
	int players = 0;
	sockaddr_in address;
	memset(&address, 0, sizeof(sockaddr_in)); 
	address.sin_family = AF_INET;
	address.sin_addr.s_addr = htonl(INADDR_ANY);
	address.sin_port = htons(27777);
	for(j = 0; j < max_connections; j++) {
		if (PlayerList[j] != 0 && PlayerList[j]->ip && (PlayerList[j]->ip != inet_addr("127.0.0.1"))) {
			int sent_bytes;
			address.sin_addr.s_addr = htonl(PlayerList[j]->ip);//*((struct in_addr*)(int*)&(Players[j].ip));		
			sent_bytes = NetUDPServer_Send((sockaddr *) &address, (char*)packet, size);
			if(sent_bytes == SOCKET_ERROR) NetCatchError();
			else players++;
		}
	}
	return players;
}

//Always make sure you send a pointer to this, even if it is just one arg. ;)
void FLsPublic_Event( unsigned int eventIndex, int * args )
{
	int numArgs = FLrEvent_GetNumArgs( eventIndex );
	flatline_packet eventPacket = {0};
	eventPacket.id = FLATLINE_EVENT;
	eventPacket.flatline_event.event_index = eventIndex;
	memcpy( eventPacket.flatline_event.intArray, args, sizeof(int) * numArgs );
	UDPServer_SendToAll( &eventPacket, sizeof(int) * (numArgs + 1) + FLATLINE_HEADER );
}

