/*;symbol(name, value)  .global name; .set name, 0x00400000 + value
symbol macro name, value
.global name
mov name, value
endm

;MSVC6.0 stdlib
DefVar( , _oni_malloc                               , 0x0051fc24 )
DefVar( , _oni_free                                 , 0x0051fbf5 )

DefVar( , _oni_fopen                                , 0x0051ea9f )
DefVar( , _oni_fflush                               , 0x0051eab2 )
DefVar( , _oni_fprintf                              , 0x0051ebbf )
DefVar( , _oni_vsprintf                             , 0x0051e860 )

;Oni Engine
DefVar( , _ONiMain                                  , 0x004d3280 )
symbol ( @ONrPlatform_Initialize@4                 , 0x0050f670 )
DefVar( , _ONrPlatform_WindowProc@16                , 0x0050f7a0 )
symbol ( @ONrCheater@4                             , 0x004f5c30 )

DefVar( , _g_Instance                               , 0x0021f9e4 )
DefVar( , _ONgPlatformData                          , 0x0023100c )
DefVar( , _ONgGameState                             , 0x005ece7c )
DefVar( , _ai2_deaf								   , 0x005ec0c1 )
DefVar( , _AKgDebug_DebugMaps                       , 0x002b2204 )
DefVar( , _BFgDebugFileEnable                       , 0x0055c8d0 )
DefVar( , _SSgSearchOnDisk                          , 0x005eb758 )

DefVar( , _opt_sound                                , 0x002370fc )
DefVar( , _opt_ignore_private_data                  , 0x002370f0 )

;Oni Persistance
symbol ( @ONrPersist_GetGamma@0                    , 0x0050f450 )
symbol ( @ONrPersist_GetWonGame@0                  , 0x0050f660 )

;BFW_Utility
DefVar( , _UUrStartupMessage                        , 0x00424860 )
symbol ( @UUrMachineTime_High@0                    , 0x00426480 )
symbol ( @UUrMachineTime_High_Frequency@0          , 0x004264b0 )
symbol ( @UUrMachineTime_Sixtieths@0               , 0x004263e0 )
symbol ( @UUrPlatform_Initialize@0                 , 0x00426010 )
symbol ( @UUrPlatform_Terminate@0                  , 0x00426310 )
DefVar( , _AUrMessageBox                            , 0x004378c0 )

DefVar( , _ONgFileStartup                           , 0x005711b8 )

LMotoko

DefVar( , _M3gResolutionSwitch                      , 0x00531634 )

L OpenGL
symbol ( @gl_enumerate_valid_display_modes@4       , 0x004083a0 )
symbol ( @gl_platform_set_pixel_format@4           , 0x00407b50 )
symbol ( @gl_platform_initialize@0                 , 0x00407da0 )



; Character
symbol ( @ONrGameState_NewCharacter@16             , 0x004dac50 )
symbol ( @ONrGameState_GetPlayerCharacter@0        , 0x004b63a7 )
symbol ( @ONrGetActiveCharacter@4				   , 0x004f1180 )

; Console
symbol ( @TSrContext_DrawText@20                   , 0x0042DF00 )
symbol ( @TSrContext_New@24                        , 0x0042EA30 )
symbol ( @TMrInstance_GetDataPtr@12                , 0x004232E0 )
symbol ( @TMrInstance_GetInstanceName@4			   , 0x00423D90 )
symbol ( @COrTextArea_Print@28                     , 0x00431340 )

DefVar( , _COgConsoleLines                          , 0x005cb468 )
DefVar( , _COgFadeTimeValue                         , 0x00533f68 )
DefVar( , _COgDefaultTextShade                      , 0x00533f70 )
DefVar( , _COgDefaultTextShadow                     , 0x00533f74 )

DefVar( , _TStColorFormattingCharacter			   , 0x00533DA0 )

symbol ( @COrMessage_Print@12					   , 0x004304B0 )
symbol ( @COrMessage_Remove@4					   , 0x00430640 )

; ScriptingLanguage
;symbol ( @SLrScript_Command_Register_ReturnType@20 , 0x00477b20 )
;symbol ( @SLrScript_Command_Register_Void@16       , 0x00477b40 )
;symbol ( @SLrGlobalVariable_Register_Int32@12      , 0x00477e30 )
;symbol ( @SLrGlobalVariable_Register_Float@12      , 0x00477ec0 )
;symbol ( @SLrGlobalVariable_Register_String@12      , 0x00477fe0 )

; Messages
symbol ( @SSrMessage_Find@4						   , 0x0047F550 )
symbol ( @ONiGameState_FindAutoPromptMessage@8	   , 0x004FDBE0 )

; Data
symbol ( @TMrInstance_GetDataPtr_List@16		   , 0x00423540 )
*/
#include "Daodan.h"
#include "Oni.h"

//////////////////////////////////////////////////////////////////////
//Functions need:
//In Oni_Symbols.c
//1. DefFunc( name, address )
//In Oni_Symbols.h
//1. typedef return_type ( [calling_convention] *_name)( arguments );
//2. ExtFunc( name )
//////////////////////////////////////////////////////////////////////
//Variables need:
//In Oni_Symbols.c
//1. DefVar( type, name, address );
//In Oni_Symbols.h
//1. DefVar( type, name, address <ignored> );
//2. #define name *(_name)
//Please do not use variable names that could be parts of other
//names like "gl". That will screw things up. If you insist on doing
//this, omit the #define step and dereference them yourself.
//////////////////////////////////////////////////////////////////////
//Please keep everything alphabatized. Kthanxbai
//////////////////////////////////////////////////////////////////////

#define DefFunc(name, address) _##name name = (_##name)address
DefFunc( gl_enumerate_valid_display_modes       , 0x004083a0 );
DefFunc( gl_platform_set_pixel_format           , 0x00407b50 );
DefFunc( gl_platform_initialize                 , 0x00407da0 );

DefFunc( oni_fopen                              , 0x0051ea9f );
DefFunc( oni_fflush                             , 0x0051eab2 );
DefFunc( oni_fprintf                            , 0x0051ebbf );


DefFunc( AI2iScript_Spawn						, 0x004B4780 );
DefFunc( AUrMessageBox                          , 0x004378c0 );

DefFunc( COrMessage_Print						, 0x004304B0 );
DefFunc( COrTextArea_Print						, 0x00431340 );
//DefFunc( COrConsole_StatusLine_Display			, 0x00431E70 );

DefFunc( OBJrObjectType_EnumerateObjects		, 0x004D0080 );
//DefFunc( OBJiObjectGroup_GetNumObjects			, 

//DefFunc( ONiGameState_FindAutoPromptMessage		, 0x004FDBE0 );
DefFunc( ONiMain								, 0x004d3280 );

DefFunc( ONrCharacter_NewAnimationHook			, 0x004E97A0 );
DefFunc( ONrCheater                             , 0x004f5c30 );
DefFunc( ONrCorpse_Create						, 0x004EF340 );
DefFunc( ONrGameState_NewCharacter				, 0x004dac50 );
DefFunc( ONrGameState_DeleteCharacter			, 0x004DC480 );
DefFunc( ONrGetActiveCharacter					, 0x004f1180 );
DefFunc( ONrPersist_GetGamma                    , 0x0050f450 );
DefFunc( ONrPersist_GetWonGame                  , 0x0050f660 );
DefFunc( ONrPlatform_Initialize					, 0x0050f670 );
DefFunc( ONrPlatform_WindowProc					, 0x0050f7a0 );
DefFunc( ONrCharacter_SetHitPoints				, 0x004EB220 );

DefFunc( iSetCharacterClass						, 0x004D99D0 );


DefFunc( SLrGlobalVariable_Register_Int32		, 0x00477e30 );
DefFunc( SLrGlobalVariable_Register_Float		, 0x00477ec0 );
DefFunc( SLrGlobalVariable_Register_String		, 0x00477fe0 );
DefFunc( SLrScript_Command_Register_ReturnType	, 0x00477b20 );
DefFunc( SLrScript_Command_Register_Void		, 0x00477b40 );

DefFunc( SSrMessage_Find						, 0x0047F550 );

DefFunc( TMrInstance_GetInstanceName			, 0x00423D90 );
DefFunc( TMrInstance_GetDataPtr					, 0x004232E0 );

DefFunc( TSrContext_DrawText					, 0x0042DF00 );
DefFunc( TSrContext_New							, 0x0042EA30 );
DefFunc( TSrContext_SetShade					, 0x0042EE50 );
DefFunc( TRrAnimation_GetDuration				, 0x00428740 );
DefFunc( TRrAnimation_GetFrom					, 0x00428720 );
DefFunc( TRrAnimation_GetTo						, 0x00428730 );

DefFunc( UUrMachineTime_High					, 0x04026480 );
DefFunc( UUrMachineTime_High_Frequency			, 0x040264b0 );
DefFunc( UUrMachineTime_Sixtieths				, 0x040263e0 );
DefFunc( UUrPlatform_Initialize					, 0x04026010 );
DefFunc( UUrPlatform_Terminate					, 0x04026310 );
DefFunc( UUrStartupMessage                      , 0x00424860 );
DefFunc( OBJrDoor_Open							, 0x004C26C0 );
DefFunc( OBJrDoor_ForceOpen						, 0x004C1EE0 );
//DefFunc( OBJrConsole_GetByID					, 0x004C0950 );
DefFunc( OBJrConsole_OnActivate					, 0x004C0880 );
DefFunc( ONrCharacter_SetAnimationExternal		, 0x004EB340 );
DefFunc( ONrGameState_Timer_Start				, 0x004FD370 );
#define DefVar(type, name, address) //type* _##name = (type*)address

DefVar( onibool,		ai2_deaf,				0x005ec0c1 );

DefVar(	HINSTANCE,		g_Instance,				0x0061F9E4 );

DefVar( gl_api_t*,		gl_api,					0x00560604 );
DefVar( gl_engine_t*,	gl_eng,					0x00560600 );
DefVar( WORD*,			gl_gamma_ramp,			0x0055fdfc );
DefVar( int,			gl_gamma_ramp_valid,	0x005603fc );

DefVar(	char,			opt_ignore_private_data,0x006370f0 );
DefVar( char,			opt_sound,				0x006370fc ); 

DefVar( char,			AKgDebug_DebugMaps,		0x002b2204 );

DefVar( bool,			BFgDebugFileEnable,		0x0055c8d0 );

DefVar( uint32_t,		COgConsoleLines,		0x005cb468 );
DefVar( uint32_t,		COgDefaultTextShade,	0x00533f70 );
DefVar( uint32_t,		COgDefaultTextShadow,	0x00533f74 );
DefVar( uint32_t,		COgFadeTimeValue,		0x00533f68 );

DefVar( FILE*,			ONgFileStartup,			0x005711b8 );
DefVar( GameState*,		ONgGameState,			0x005ece7c );
DefVar( ONtPlatformData,ONgPlatformData,		0x0053100c );

DefVar( char,			M3gResolutionSwitch,	0x00531634 );

DefVar( bool,			SSgSearchOnDisk,		0x005eb758 );

/*
extern gl_engine_t* gl;
extern gl_api_t* gl_api;
extern WORD gl_gamma_ramp[3 * 256];
extern int gl_gamma_ramp_valid;
*/

#undef DefVar
void _DDrDefine_Symbols() {

}
