#include "Flatline.h"

bool DoWeUpdateThis( uint16_t BitSet, uint16_t Flag )
{
	if( BitSet & (1 << Flag) ) return true;
	return false;
}

//Long winded?

void FLcPacketBufferToPlayerData( PlayerData* PD)
{
	player_info* PI = PlayerList[PD->ID];
	uint8_t * DataPointer = PD->data;

	if(!PI)
	{
		//TODO: Store this data and then apply it once we have a character that matches!
		return;
	}

	if( DoWeUpdateThis( PD->UpdateFlags, PFlag_Input) )
	{
		PI->Input = *(PlayerInput*)DataPointer;
		DataPointer += FLpData_PartSize( PFlag_Input);
	}

	if( DoWeUpdateThis( PD->UpdateFlags, PFlag_Facing) )
	{
		PI->Facings = *(PlayerFacing*)DataPointer;
		DataPointer += FLpData_PartSize( PFlag_Facing);
	}

	if( DoWeUpdateThis( PD->UpdateFlags, PFlag_Health) )
	{
		PI->Health = *(PlayerHealth*)DataPointer;
		DataPointer += FLpData_PartSize( PFlag_Health);
	}

	//Not done
	if( DoWeUpdateThis( PD->UpdateFlags, PFlag_Score) )
	{
		PI->Score = *(PlayerScore*)DataPointer;
		DataPointer += FLpData_PartSize( PFlag_Score);
	}
	
	if( DoWeUpdateThis( PD->UpdateFlags, PFlag_FramePing) )
	{
		PlayerFP* FP = (PlayerFP*)DataPointer;
		PI->Ping = FP->Ping;
		
		if(FP->Frame != -1)
		{
			PI->Frame = FP->Frame;
		}
		else
		{
			PD->UpdateFlags &= ~( 1 << PFlag_FramePing );
		}
		DataPointer += FLpData_PartSize( PFlag_FramePing);
	}
	
	//Not done
	if( DoWeUpdateThis( PD->UpdateFlags, PFlag_Inventory) )
	{
		PI->Inventory = *(PlayerInventory*)DataPointer;
		DataPointer += FLpData_PartSize( PFlag_Inventory );
	}
		
	if( DoWeUpdateThis( PD->UpdateFlags, PFlag_Class ) )
	{
		TMrInstance_GetDataPtr( 'ONCC', (char*)DataPointer, &PI->Class );
		DataPointer += FLpData_PartSize( PFlag_Class );
	}
		
	if( DoWeUpdateThis( PD->UpdateFlags, PFlag_Position ) )
	{
		PI->Position = *(Vector3*)DataPointer;
		DataPointer += FLpData_PartSize( PFlag_Position );
	}
		
	if( DoWeUpdateThis( PD->UpdateFlags, PFlag_Animation ) )
	{
		TMrInstance_GetDataPtr( 'TRAM', (char*)DataPointer, &PI->Animation );
		DataPointer += FLpData_PartSize( PFlag_Animation );
	}
		
	if( DoWeUpdateThis( PD->UpdateFlags, PFlag_Throws ) )
	{
		PI->ThrowData = *(PlayerThrowData*)DataPointer;
		DataPointer += FLpData_PartSize( PFlag_Throws );
	}


	PI->UpdateFlags |= PD->UpdateFlags;
}

void FLcReadPlayerData( flatline_packet* Packet, int16_t Size )
{
	PlayerData* PDCast = (PlayerData*)Packet->data;
	Size -= FLATLINE_HEADER;
	while(Size > 0)
	{
		if(PDCast->Size > Size)
		{
			DDrConsole_PrintF( "Warning, (almost) read %hi bytes too much of player data buffer", -Size );
			break;
		}
		FLcPacketBufferToPlayerData( PDCast );
		Size -= PDCast->Size;
		PDCast = (PlayerData*)((char*)PDCast + PDCast->Size);
	}

	//Packet
}