#ifndef FLATLINE_NET_H
#define FLATLINE_NET_H

#define pad1_size (sizeof(int64_t) - sizeof(short))
#define pad2_size (128 - (sizeof(short) + pad1_size + sizeof(int64_t)))


typedef struct hostent hostent ;
typedef struct in_addr in_addr;

typedef struct {
	short ss_family;
	char pad1[pad1_size];
	uint64_t pad64;
	char pad2[pad2_size];
} sockaddr_storage;

typedef struct sockaddr sockaddr;
typedef struct sockaddr_in sockaddr_in;
typedef sockaddr_storage sockaddr_in6;

void NetCatchError();

bool NetUDPServer_Listen(uint16_t port, bool (*packet_callback)(char* data, int datalen, int from));
bool NetUDPServer_Send(sockaddr* address, char* data, int datalen);

int NetUDPSocket_Create(uint16_t port, sockaddr_in* address);
int NetTCPSocket_Create(uint16_t port, sockaddr_in* address);
int NetUDPSocket_Send(int socket, const sockaddr* address, const char* data, int datalen);
void NetUDPSocket_Close(int sock);
bool NetUDPSocket_Recieve(int socket, sockaddr_storage* address, char* data, uint16_t* datalen);

#endif