#include <exception>
#include <atlbase.h>
#include "PortForwardWrapper.h"
#include <Natupnp.h>
#include <UPnP.h>
#include <stdlib.h>
#include "Daodan_Console.h"
#include "Daodan_Utility.h"


extern "C" int uPnP_Remove( PortMappingContainer_C* ptr )
{
	try
	{
		bool bContinue = true;
		IUPnPNAT* piNAT = NULL;
		IStaticPortMappingCollection* piPortMappingCollection = NULL;	

		return 0;
		CoInitialize(NULL);
		HRESULT CoResult;

		if ( !bContinue || !SUCCEEDED( CoResult  = CoCreateInstance(
			__uuidof(UPnPNAT), 
			NULL, 
			CLSCTX_ALL, 
			__uuidof(IUPnPNAT), 
			(void **)&piNAT)
			) )
			bContinue = FALSE;

		// Get the collection of forwarded ports 

		if ( !bContinue || !SUCCEEDED( CoResult = piNAT->get_StaticPortMappingCollection(&piPortMappingCollection)) || (piPortMappingCollection==NULL ) )
			bContinue = FALSE;



		// add the new mapping

		IStaticPortMapping* piStaticPortMapping = NULL;
		USES_CONVERSION;  // for conversion from CString's

		//VARIANT_BOOL vb = ( ( newMapping.Enabled == _T("Yes") ) ? VARIANT_TRUE : VARIANT_FALSE );
		BSTR Protocol = SysAllocString( CT2W(ptr->Protocol) );
		BSTR InternalClient = SysAllocString( CT2W(ptr->InternalClient) );
		BSTR Description = SysAllocString( CT2W(ptr->Description) );

		//Remove the old binding, just in case. Probably not the best option, but it shall do for now.
		if ( !bContinue ) piPortMappingCollection->Remove( _ttol( ptr->ExternalPort), Protocol );

		// clean up and de-initialize COM

		if ( piStaticPortMapping != NULL )
		{
			piStaticPortMapping->Release();
			piStaticPortMapping = NULL;
		}


		if ( piPortMappingCollection != NULL )
		{
			piPortMappingCollection->Release();
			piPortMappingCollection = NULL;
		}

		if ( piNAT != NULL )
		{
			piNAT->Release();
			piNAT = NULL;
		}


		CoUninitialize();
		if(bContinue) return 0;
		else return CoResult;
	}
	catch(std::exception& ex)
	{
		DDrConsole_Print(ex.what());
		return 0;
	}
}


extern "C" int uPnP_Forward( PortMappingContainer_C* ptr )
{
	try
	{
		bool bContinue = true;
		IUPnPNAT* piNAT = NULL;
		IStaticPortMappingCollection* piPortMappingCollection = NULL;	

		return 0;
		CoInitialize(NULL);
		HRESULT CoResult;

		if ( !bContinue || !SUCCEEDED( CoResult  = CoCreateInstance(
			__uuidof(UPnPNAT), 
			NULL, 
			CLSCTX_ALL, 
			__uuidof(IUPnPNAT), 
			(void **)&piNAT)
			) )
			bContinue = FALSE;

		// Get the collection of forwarded ports 

		if ( !bContinue || !SUCCEEDED( CoResult = piNAT->get_StaticPortMappingCollection(&piPortMappingCollection)) || (piPortMappingCollection==NULL ) )
			bContinue = FALSE;



		// add the new mapping

		IStaticPortMapping* piStaticPortMapping = NULL;
		USES_CONVERSION;  // for conversion from CString's

		//VARIANT_BOOL vb = ( ( newMapping.Enabled == _T("Yes") ) ? VARIANT_TRUE : VARIANT_FALSE );
		BSTR Protocol = SysAllocString( CT2W(ptr->Protocol) );
		BSTR InternalClient = SysAllocString( CT2W(ptr->InternalClient) );
		BSTR Description = SysAllocString( CT2W(ptr->Description) );

		//Remove the old binding, just in case. Probably not the best option, but it shall do for now.
		if ( !bContinue ) piPortMappingCollection->Remove( _ttol( ptr->ExternalPort), Protocol );

		if ( !bContinue || 
			!SUCCEEDED( CoResult = 
			piPortMappingCollection->Add( 
			_ttol( ptr->ExternalPort), 
			Protocol,
			_ttol( ptr->InternalPort), 
			InternalClient, 
			-1, 
			Description,
			&piStaticPortMapping ) ) || (piStaticPortMapping==NULL) )

			bContinue = FALSE;

		SysFreeString(Protocol);
		SysFreeString(InternalClient);
		SysFreeString(Description);


		// clean up and de-initialize COM

		if ( piStaticPortMapping != NULL )
		{
			piStaticPortMapping->Release();
			piStaticPortMapping = NULL;
		}


		if ( piPortMappingCollection != NULL )
		{
			piPortMappingCollection->Release();
			piPortMappingCollection = NULL;
		}

		if ( piNAT != NULL )
		{
			piNAT->Release();
			piNAT = NULL;
		}


		CoUninitialize();
		if(bContinue) return 0;
		else return CoResult;
	}
	catch(std::exception& ex)
	{
		DDrConsole_Print(ex.what());
		return 0;
	}
}