//to client
#include "Mariusnet_Public.h"
enum
{
pt_RoomList = 0x0000,
pt_PlayerList = 0x0001,
pt_GameList = 0x0002,
pt_UserLoggedIn = 0x7,//0x0003,
pt_EncryptionKey = 0x0006,
pt_LoginInfo = 0x3,//0x0007,
pt_PlayerInfo = 0x0008,
pt_PlayerId = 0x0009,
pt_BlueBarMsg = 0x000A,
pt_PasswordAck = 0x000C,
pt_FindResponse = 0x000E,
pt_BuddyList = 0x000F, // the actual buddy list - i.e. names and such
pt_OrderList = 0x0010,
pt_PlayerInfoResponse = 0x0011,
pt_UpdatePlayerStats = 0x0012,
pt_UpdateBuddyList = 0x0013, // buddy status - i.e. online/offline
pt_UpdateOrderList = 0x0014,
};

//from client
enum
{
pt_PlayerLogin = 0x0064,
pt_ChatRoomLogin = 0x0065,
pt_RoomPlayerInfo = 0x0067,
pt_GameInfo = 0x0068,
pt_RemoveGame = 0x0069,
pt_SetPlayerState = 0x006B,
pt_Password = 0x006D,
pt_RequestRefresh = 0x006E,
pt_GamePlayerList = 0x006F, // game start player list
pt_PlayerScores = 0x0070, // game over player scores
pt_ResetScoring = 0x0071, // reset metaserver game scoring
pt_StartGame = 0x0072,
pt_Localization = 0x0073,
pt_GameSearchQuery = 0x0074,
pt_FindPlayer = 0x0075,
pt_BuddyListQuery = 0x0076, // request a buddy list update
pt_OrderListQuery = 0x0077,
pt_UpdateBuddy = 0x0078, // add/remove buddy
pt_PlayerInfoQuery = 0x0079,
pt_SetPlayerStats = 0x007A, // change player stats (city/state/profile)
pt_ChatMessage = 0x00C8,
pt_WhisperMessage = 0x00C9,
pt_KeepAlive = 0x00CA,
pt_SessionKey = 0x00CB,
};

enum
{
ctMyth1 = 0,
ctMyth2 = 1,
// ctMyth3 = 2;
ctMarathon = 3,
ctMyth1Unified = 4,
ctMyth2Unified = 5,
ctMyth3Unified = 6,
};


typedef struct
{
	short PacketSignature;// = 0xDEAD;
    short PacketId;
    unsigned int PacketSize;
} marius_header;

typedef struct
{
	short Red;
    short Green;
    short Blue;
    short Flags;
} m_colour;

typedef struct
{
	char Icon;
	char pad;
	short Flags; // 0=active, 1=inactive, in a game, grayed out, can't see chat
	m_colour Colors[2];
	short orderIndex;
	short clientVersion;
	char stupid_14byte_pad[14];
	char Name[112];     // 2 #0 terminated fields - Name, Team Name
} m_player_info;

typedef struct
{
	short Platform; //Windows - 1
	short MetaVersion; //0
	char pad[3]; 
    char UpdateAppearance;                      // save player settings on server,     change to bits, bit 0=update, bit 1=demo
    int PlayerId; //0
    short EncryptionType;  //0 - kCRYPT_PLAINTEXT, screw encryption for now
    short PlayerInfoSize;  //40 + strlen(playername) + strlen(plaerteam(
    char AppName[32];		//MARATHON...later ONI ;)
    char BuildDate[32];		//_DATE_
    char BuildTime[32];		//_TIME_
    char LoginId[32];		//username
    m_player_info PlayerInfo;       
} m_player_login;

typedef struct
{
	short EncryptionType;
	unsigned char salt[16];
} m_salt;

typedef struct
{
	int one;
	int two;
	int three;
	int zero;
} m_localization;

typedef struct
{
	unsigned char passHash[16];
} m_password;

typedef struct
{
	int userID;
	short order;
	short unused;
	char Token[32];
		
} m_login_success;

typedef struct
{
	int code;
	char DenialMessage[];
} m_login_denied;

typedef struct
{
	short RoomIndex;
	short PlayerCount;
	int IPAddress;
	short Port;
	short GameCount;
	int pad[3];
} m_room;

typedef struct
{
	m_room Rooms[64];
} m_roomlist;

typedef struct
{
	char RoomKey[32];
	char Name[32];
} m_chatroom_join;

typedef struct
{
	char Message[512];
} m_motd;

typedef struct
{
	m_colour	PrimaryColor;
	m_colour	SecondaryColor;
	int    SenderId;
    int		TargetId;
    char Message[256];
} m_message;

typedef struct
{
	unsigned int	gameID;
	unsigned int	ipAddress;
	unsigned short	port;
	unsigned char	verb;
	unsigned char	gameEnable;
	unsigned int	timeRemaining;
	unsigned int	hostPlayerID;
	unsigned short	len;
	int unused1;
	int unused2;
	short pad;
	m_gamedescription g;
} m_gameinfo;

typedef struct
{
	m_gameinfo Games[];
} m_gamelist;
typedef struct
{
	marius_header header;
	union
	{
		m_player_login login;
		m_password password;
		m_localization localization;
		m_salt salt;
		m_login_success login_success;
		m_login_denied login_denied;
		m_roomlist roomlist;
		m_chatroom_join chatroom_join;
		m_player_info player_info;
		m_motd motd;
		m_message message;
		m_announcegame newgame;
		m_gamelist gamelist;
	};
} marius_packet;