/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.type;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuilderConfig;
import org.javabuilders.Node;
import org.javabuilders.handler.ITypeHandlerFinishProcessor;

public class ContainerTypeHandler
implements ITypeHandlerFinishProcessor {
    private static final ContainerTypeHandler singleton = new ContainerTypeHandler();
    private Set<Class<?>> ignored = new HashSet();

    public static ContainerTypeHandler getInstance() {
        return singleton;
    }

    private ContainerTypeHandler() {
        this.ignored.add(JMenuBar.class);
    }

    public void finish(BuilderConfig config, BuildProcess process, Node current, String key, Map<String, Object> typeDefinition) throws BuildException {
        Container c = (Container)current.getMainObject();
        Node content = current.getChildNode("content");
        if (content != null && !content.containsType(LayoutManager.class) && !current.isCustomPropertyEqualTo("ignoreLayoutManager", (Object)Boolean.TRUE)) {
            for (Node child : content.getChildNodes(new Class[]{Component.class})) {
                if (this.isIgnored(child.getMainObject()) || c instanceof JFrame && child.getMainObject() instanceof JDesktopPane) continue;
                c.add((Component)child.getMainObject());
            }
            if ("packed".equals(current.getProperty(new String[]{"size"}))) {
                try {
                    Method pack = c.getClass().getMethod("pack", new Class[0]);
                    pack.invoke((Object)c, new Object[0]);
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
            }
        }
    }

    private boolean isIgnored(Object child) {
        boolean ignore = false;
        if (child != null) {
            for (Class<?> ignoredClass : this.ignored) {
                if (!ignoredClass.isAssignableFrom(child.getClass())) continue;
                ignore = true;
                break;
            }
        } else {
            ignore = true;
        }
        return ignore;
    }
}

