/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.type.layout;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Map;
import javax.swing.JComponent;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuilderConfig;
import org.javabuilders.Node;
import org.javabuilders.handler.ITypeHandlerFinishProcessor;
import org.javabuilders.swing.SwingJavaBuilderUtils;

public class CardLayoutTypeHandler
implements ITypeHandlerFinishProcessor {
    private static final CardLayoutTypeHandler singleton = new CardLayoutTypeHandler();

    public static CardLayoutTypeHandler getInstance() {
        return singleton;
    }

    private CardLayoutTypeHandler() {
    }

    public void finish(BuilderConfig config, BuildProcess process, Node current, String key, Map<String, Object> typeDefinition) throws BuildException {
        Container container = SwingJavaBuilderUtils.getParentContainer(current);
        if (container != null) {
            CardLayout layout = (CardLayout)current.getMainObject();
            container.setLayout(layout);
            Node content = current.getParent();
            if (content != null) {
                for (Node child : content.getChildNodes(new Class[]{JComponent.class})) {
                    Component c = (Component)child.getMainObject();
                    container.add(c, c.getName());
                }
            }
        } else {
            throw new BuildException("Unable to process CardLayout since no parent JComponent was found: {0}", new Object[]{typeDefinition});
        }
    }
}

