/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.event;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.List;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuildResult;
import org.javabuilders.BuilderConfig;
import org.javabuilders.IPropertyList;
import org.javabuilders.Node;
import org.javabuilders.ValueListDefinition;
import org.javabuilders.Values;
import org.javabuilders.handler.AbstractPropertyHandler;
import org.javabuilders.util.BuilderUtils;

public class ComponentMouseMotionListenerHandler
extends AbstractPropertyHandler
implements IPropertyList {
    public static final String ON_MOUSE_DRAGGED = "onMouseDragged";
    public static final String ON_MOUSE_MOVED = "onMouseMoved";
    private static final ComponentMouseMotionListenerHandler singleton = new ComponentMouseMotionListenerHandler();
    private static final List<ValueListDefinition> defs = ValueListDefinition.getCommonEventDefinitions((Class[])new Class[]{MouseEvent.class});

    public static ComponentMouseMotionListenerHandler getInstance() {
        return singleton;
    }

    private ComponentMouseMotionListenerHandler() {
        super(new String[]{ON_MOUSE_DRAGGED, ON_MOUSE_MOVED});
    }

    public void handle(BuilderConfig config, final BuildProcess process, final Node node, String key) throws BuildException {
        Component component = (Component)node.getMainObject();
        final Values onDragged = (Values)node.getProperty(new String[]{ON_MOUSE_DRAGGED});
        final Values onMoved = (Values)node.getProperty(new String[]{ON_MOUSE_MOVED});
        component.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (onDragged != null) {
                    BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Node)node, (Collection)onDragged.values(), (Object)e);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (onMoved != null) {
                    BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Node)node, (Collection)onMoved.values(), (Object)e);
                }
            }
        });
    }

    public Class<?> getApplicableClass() {
        return Component.class;
    }

    public List<ValueListDefinition> getValueListDefinitions(String propertyName) {
        return defs;
    }

    public boolean isList(String propertyName) {
        return true;
    }
}

