/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.type;

import java.text.Format;
import java.util.Map;
import javax.swing.JFormattedTextField;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuilderConfig;
import org.javabuilders.Node;
import org.javabuilders.handler.AbstractTypeHandler;

public class JFormattedTextFieldTypeHandler
extends AbstractTypeHandler {
    public static final String FORMAT = "format";
    private static final JFormattedTextFieldTypeHandler singleton = new JFormattedTextFieldTypeHandler();

    public static JFormattedTextFieldTypeHandler getInstance() {
        return singleton;
    }

    private JFormattedTextFieldTypeHandler() {
        super(new String[]{FORMAT});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Node createNewInstance(BuilderConfig config, BuildProcess process, Node parent, String key, Map<String, Object> typeDefinition) throws BuildException {
        JFormattedTextField instance = null;
        String formatName = (String)typeDefinition.get(FORMAT);
        if (formatName != null) {
            if (!formatName.matches("\\$\\$\\{[a-zA-Z0-9]+\\}")) throw new BuildException("{0} is not a valid global format name.", new Object[]{formatName});
            Format format = (Format)config.getGlobalVariable(formatName, Format.class);
            instance = new JFormattedTextField(format);
            return this.useExistingInstance(config, process, parent, key, typeDefinition, instance);
        } else {
            instance = new JFormattedTextField();
        }
        return this.useExistingInstance(config, process, parent, key, typeDefinition, instance);
    }

    public Node useExistingInstance(BuilderConfig config, BuildProcess process, Node parent, String key, Map<String, Object> typeDefinition, Object instance) throws BuildException {
        Node node = new Node(parent, key, typeDefinition);
        node.setMainObject(instance);
        return node;
    }

    public Class<JFormattedTextField> getApplicableClass() {
        return JFormattedTextField.class;
    }
}

