/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.type;

import java.util.Map;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuilderConfig;
import org.javabuilders.Node;
import org.javabuilders.handler.AbstractTypeHandler;
import org.javabuilders.handler.ITypeHandlerFinishProcessor;
import org.javabuilders.util.JBStringUtils;

public class TableColumnTypeHandler
extends AbstractTypeHandler
implements ITypeHandlerFinishProcessor {
    public static final String FOR_HEADER = "forHeader";
    public static final String IDENTIFIER = "identifier";
    public static final String HEADER_VALUE = "headerValue";
    public static final String FILTER = "filter";
    public static final String EDITABLE = "editable";
    public static final String INTERNAL_MODEL_INDEX = "__modelIndex";
    private static final TableColumnTypeHandler singleton = new TableColumnTypeHandler();

    public static TableColumnTypeHandler getInstance() {
        return singleton;
    }

    private TableColumnTypeHandler() {
        super(new String[]{FOR_HEADER, FILTER, EDITABLE});
    }

    public Node createNewInstance(BuilderConfig config, BuildProcess process, Node parent, String key, Map<String, Object> typeDefinition) throws BuildException {
        Integer index;
        TableColumn instance = null;
        JTable table = (JTable)parent.getParentObject(new Class[]{JTable.class});
        if (table != null && (index = (Integer)typeDefinition.get(INTERNAL_MODEL_INDEX)) != null) {
            int count = table.getColumnModel().getColumnCount();
            for (int i = 0; i < count; ++i) {
                TableColumn col = table.getColumnModel().getColumn(i);
                if (col.getModelIndex() != index.intValue()) continue;
                instance = col;
                break;
            }
        }
        if (instance == null) {
            instance = new TableColumn();
        }
        return this.useExistingInstance(config, process, parent, key, typeDefinition, instance);
    }

    public Node useExistingInstance(BuilderConfig config, BuildProcess process, Node parent, String key, Map<String, Object> typeDefinition, Object instance) throws BuildException {
        Node node = new Node(parent, key, typeDefinition, instance);
        return node;
    }

    public void finish(BuilderConfig config, BuildProcess process, Node current, String key, Map<String, Object> typeDefinition) throws BuildException {
        TableColumn col = (TableColumn)current.getMainObject();
        Set renderers = current.getContentNodes(new Class[]{TableCellRenderer.class});
        for (Node renderer : renderers) {
            TableCellRenderer r = (TableCellRenderer)renderer.getMainObject();
            if (Boolean.TRUE.equals(renderer.getProperty(new String[]{FOR_HEADER}))) {
                col.setHeaderRenderer(r);
                continue;
            }
            col.setCellRenderer(r);
        }
        Set editors = current.getContentNodes(new Class[]{TableCellEditor.class, JComboBox.class, JCheckBox.class, JTextField.class});
        for (Node editor : editors) {
            Object e;
            if (editor.getMainObject() instanceof TableCellEditor) {
                e = (TableCellEditor)editor.getMainObject();
                col.setCellEditor((TableCellEditor)e);
                continue;
            }
            if (editor.getMainObject() instanceof JComboBox) {
                e = (JComboBox)editor.getMainObject();
                col.setCellEditor(new DefaultCellEditor((JComboBox<?>)e));
                continue;
            }
            if (editor.getMainObject() instanceof JCheckBox) {
                e = (JCheckBox)editor.getMainObject();
                col.setCellEditor(new DefaultCellEditor((JCheckBox)e));
                continue;
            }
            if (!(editor.getMainObject() instanceof JTextField)) continue;
            e = (JTextField)editor.getMainObject();
            col.setCellEditor(new DefaultCellEditor((JTextField)e));
        }
        String headerValue = current.getStringProperty(new String[]{HEADER_VALUE});
        if (headerValue == null) {
            headerValue = String.valueOf(col.getHeaderValue());
            col.setHeaderValue(JBStringUtils.getDisplayName((String)headerValue));
        }
    }

    public Class<TableColumn> getApplicableClass() {
        return TableColumn.class;
    }
}

