/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.type.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.Map;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuilderConfig;
import org.javabuilders.Node;
import org.javabuilders.layout.mig.AbstractMigLayoutHandler;
import org.javabuilders.swing.SwingJavaBuilderUtils;

public class MigLayoutHandler
extends AbstractMigLayoutHandler {
    private static final MigLayoutHandler singleton = new MigLayoutHandler();

    public static MigLayoutHandler getInstance() {
        return singleton;
    }

    private MigLayoutHandler() {
        super(JLabel.class, "text");
    }

    public Node createNewInstance(BuilderConfig config, BuildProcess result, Node parent, String key, Map<String, Object> typeDefinition) throws BuildException {
        MigLayout instance = new MigLayout();
        return this.useExistingInstance(config, result, parent, key, typeDefinition, instance);
    }

    public Class<?> getApplicableClass() {
        return MigLayout.class;
    }

    protected void applyControlConstraints(BuildProcess process, Node node, Node components, Map<String, String> layoutConstraints) throws BuildException {
        Container parentContainer = (Container)node.getParent().getParent().getMainObject();
        for (String componentName : layoutConstraints.keySet()) {
            String componentConstraint = layoutConstraints.get(componentName);
            Component component = SwingJavaBuilderUtils.getComponent(components, String.valueOf(componentName));
            if (component == null) {
                throw new BuildException("Unable to find component for name: {0}", new Object[]{componentName});
            }
            if (logger.isDebugEnabled()) {
                logger.debug("MigLayout constraints for " + componentName + " : " + componentConstraint);
            }
            parentContainer.add(component, componentConstraint);
        }
    }

    protected Object getComponent(BuildProcess result, Node components, String name) throws BuildException {
        Component component = SwingJavaBuilderUtils.getComponent(components, String.valueOf(name));
        return component;
    }

    protected void setLayout(BuildProcess result, Node node, Object migLayout) {
        Node parent = node.getParent().getParent();
        Container parentContainer = (Container)parent.getMainObject();
        MigLayout layout = (MigLayout)node.getMainObject();
        parentContainer.setLayout((LayoutManager)layout);
    }

    protected void setLayoutConstraints(Object layout, String constraints) {
        ((MigLayout)layout).setLayoutConstraints((Object)constraints);
    }

    protected void setRowConstraints(Object layout, String constraints) {
        ((MigLayout)layout).setRowConstraints((Object)constraints);
    }

    protected void setColumnConstraints(Object layout, String constraints) {
        ((MigLayout)layout).setColumnConstraints((Object)constraints);
    }

    protected void setControlName(Object control, String name) {
        ((Component)control).setName(name);
    }
}

