/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import org.javabuilders.BuildException;
import org.javabuilders.Node;

public class SwingJavaBuilderUtils {
    public static final String MNEMONIC = "&";
    public static final String SEPARATOR = "+";
    private static final String SEPARATOR_ESCAPED = "__";
    private static Map<String, Integer> mnemonics = new HashMap<String, Integer>();
    private static Map<String, Integer> actionEvents = new HashMap<String, Integer>();
    private static List<String> functionKeys = new ArrayList<String>();
    private static char[] letters;

    public static ActionDefinition getActionDefintion(String text) {
        int index;
        KeyStroke acc = null;
        ActionDefinition def = new ActionDefinition();
        String[] parts = null;
        if (text.indexOf("\t") >= 0) {
            parts = text.split("\t");
        } else if (text.indexOf("\\t") >= 0) {
            index = text.indexOf("\\t");
            parts = new String[]{text.substring(0, index), text.substring(index + 2)};
        }
        if (parts != null && parts.length >= 2) {
            text = parts[0];
            acc = SwingJavaBuilderUtils.getAccelerator(parts[1]);
            def.setAccelerator(acc);
            def.setAcceleratorText(parts[1]);
        }
        if ((index = text.indexOf(MNEMONIC)) >= 0 && index < text.length() - 1) {
            String mnemonicLetter = String.valueOf(text.charAt(index + 1)).toLowerCase();
            if (mnemonics.containsKey(mnemonicLetter)) {
                text = text.replace(MNEMONIC, "");
                def.setText(text);
                def.setMnemonic(mnemonics.get(mnemonicLetter));
            }
        } else {
            def.setText(text);
        }
        return def;
    }

    public static KeyStroke getAccelerator(String accelerator) {
        accelerator = accelerator.toLowerCase();
        accelerator = accelerator.replace(SEPARATOR, SEPARATOR_ESCAPED);
        String[] parts = accelerator.split(SEPARATOR_ESCAPED);
        int keyEvent = 0;
        KeyStroke keyStroke = null;
        if (parts.length == 1 && functionKeys.contains(accelerator)) {
            keyStroke = KeyStroke.getKeyStroke(accelerator.toUpperCase());
        } else if (parts.length >= 2) {
            int actionEvent = 0;
            for (String part : parts) {
                if (mnemonics.containsKey(part)) {
                    keyEvent = mnemonics.get(part);
                } else if (actionEvents.containsKey(part)) {
                    actionEvent += actionEvents.get(part).intValue();
                } else {
                    throw new BuildException("Invalid accelerator value: {0}. Valid values: ctrl|shift|alt|meta+key, e.g. Ctrl+S", new Object[]{accelerator});
                }
                keyStroke = KeyStroke.getKeyStroke(keyEvent, actionEvent);
            }
        }
        return keyStroke;
    }

    public static Component getComponent(Node componentsNode, String name) throws BuildException {
        if (name != null && name.startsWith("$")) {
            name = name.substring(1);
        }
        if ("content".equals(componentsNode.getKey())) {
            Component component = null;
            for (Node child : componentsNode.getChildNodes()) {
                Component temp;
                if (!(child.getMainObject() instanceof Component) || !name.equals((temp = (Component)child.getMainObject()).getName())) continue;
                component = temp;
                break;
            }
            return component;
        }
        throw new BuildException("componentsNode is not a valid Components node", new Object[0]);
    }

    public static boolean isComponentAlreadyAdded(Container parent, Component component) {
        boolean isAdded = false;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            if (!parent.getComponent(i).equals(component)) continue;
            isAdded = true;
            break;
        }
        return isAdded;
    }

    public static Component getTopLevelParent(Object component) {
        Component top = null;
        if (component instanceof Component) {
            Component c = (Component)component;
            while (c.getParent() != null) {
                c = c.getParent();
            }
            top = c;
        }
        return top;
    }

    public static Container getParentContainer(Node current) {
        Container c = null;
        for (Node parent = current.getParent(); parent != null; parent = parent.getParent()) {
            Object main = parent.getMainObject();
            if (main instanceof Container) {
                c = (Container)main;
            } else if (main instanceof JFrame) {
                c = ((JFrame)main).getContentPane();
            } else if (main instanceof JDialog) {
                c = ((JDialog)main).getContentPane();
            } else if (main instanceof JWindow) {
                c = ((JWindow)main).getContentPane();
            }
            if (c != null) break;
        }
        return c;
    }

    static {
        for (char letter : letters = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'z', 'x', 'c', 'v', 'b', 'n', 'm'}) {
            mnemonics.put(String.valueOf(letter), Integer.valueOf(letter));
        }
        mnemonics.put("0", 48);
        mnemonics.put("1", 49);
        mnemonics.put("2", 50);
        mnemonics.put("3", 51);
        mnemonics.put("4", 52);
        mnemonics.put("5", 53);
        mnemonics.put("6", 54);
        mnemonics.put("7", 55);
        mnemonics.put("8", 56);
        mnemonics.put("9", 57);
        mnemonics.put("q", 81);
        mnemonics.put("w", 87);
        mnemonics.put("e", 69);
        mnemonics.put("r", 82);
        mnemonics.put("t", 84);
        mnemonics.put("y", 89);
        mnemonics.put("u", 85);
        mnemonics.put("i", 73);
        mnemonics.put("o", 79);
        mnemonics.put("p", 80);
        mnemonics.put("a", 65);
        mnemonics.put("s", 83);
        mnemonics.put("d", 68);
        mnemonics.put("f", 70);
        mnemonics.put("g", 71);
        mnemonics.put("h", 72);
        mnemonics.put("j", 74);
        mnemonics.put("k", 75);
        mnemonics.put("l", 76);
        mnemonics.put("z", 90);
        mnemonics.put("x", 88);
        mnemonics.put("c", 67);
        mnemonics.put("v", 86);
        mnemonics.put("b", 66);
        mnemonics.put("n", 78);
        mnemonics.put("m", 77);
        actionEvents.put("ctrl", 2);
        actionEvents.put("alt", 8);
        actionEvents.put("shift", 1);
        actionEvents.put("meta", 4);
        functionKeys.add("f1");
        functionKeys.add("f2");
        functionKeys.add("f3");
        functionKeys.add("f4");
        functionKeys.add("f5");
        functionKeys.add("f6");
        functionKeys.add("f7");
        functionKeys.add("f8");
        functionKeys.add("f9");
        functionKeys.add("f10");
        functionKeys.add("f11");
        functionKeys.add("f12");
    }

    public static class ActionDefinition {
        private String text;
        private Integer mnemonic;
        private KeyStroke accelerator;
        private String acceleratorText;

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public Integer getMnemonic() {
            return this.mnemonic;
        }

        public void setMnemonic(Integer mnemonic) {
            this.mnemonic = mnemonic;
        }

        public KeyStroke getAccelerator() {
            return this.accelerator;
        }

        public void setAccelerator(KeyStroke accelerator) {
            this.accelerator = accelerator;
        }

        public String getAcceleratorText() {
            return this.acceleratorText;
        }

        public void setAcceleratorText(String acceleratorText) {
            this.acceleratorText = acceleratorText;
        }
    }
}

