/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler;

import java.awt.Component;
import javax.accessibility.AccessibleContext;
import javax.swing.JOptionPane;
import org.javabuilders.BuildResult;
import org.javabuilders.handler.validation.IValidationMessageHandler;
import org.javabuilders.handler.validation.ValidationMessage;
import org.javabuilders.handler.validation.ValidationMessageList;
import org.javabuilders.swing.SwingJavaBuilderUtils;

public class SwingValidationMessageHandler
implements IValidationMessageHandler {
    private static final SwingValidationMessageHandler singleton = new SwingValidationMessageHandler();

    public static SwingValidationMessageHandler getInstance() {
        return singleton;
    }

    private SwingValidationMessageHandler() {
    }

    public void handleValidationMessages(ValidationMessageList list, BuildResult result) {
        if (list.size() > 0) {
            Component firstObject = null;
            StringBuilder builder = new StringBuilder();
            for (ValidationMessage msg : list) {
                Object focusable;
                if (builder.length() > 0) {
                    builder.append("\n");
                }
                builder.append(msg.getMessage());
                if (firstObject != null || msg.getProperty() == null || !((focusable = result.get((Object)msg.getProperty().getName())) instanceof Component)) continue;
                firstObject = (Component)focusable;
            }
            Component parent = null;
            if (result.getRoot() instanceof Component) {
                parent = SwingJavaBuilderUtils.getTopLevelParent(result.getRoot());
            }
            String title = list.size() == 1 ? "title.validationError" : "title.validationErrors";
            JOptionPane.showMessageDialog(parent, builder.toString(), result.getResource(title), 0);
            if (firstObject != null) {
                firstObject.requestFocus();
            }
        }
    }

    public String getNamedObjectLabel(Object namedObject) {
        Component c;
        AccessibleContext ac;
        String label = null;
        if (namedObject instanceof Component && (ac = (c = (Component)namedObject).getAccessibleContext()) != null && (label = ac.getAccessibleDescription()) != null && label.endsWith(":")) {
            label = label.substring(0, label.length() - 1);
        }
        return label;
    }
}

