/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.property;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuilderConfig;
import org.javabuilders.IAllowedPropertyCombinations;
import org.javabuilders.IAllowedPropertyFormat;
import org.javabuilders.Node;
import org.javabuilders.PropertyCombination;
import org.javabuilders.handler.AbstractPropertyHandler;

public class ComponentSizeHandler
extends AbstractPropertyHandler
implements IAllowedPropertyFormat,
IAllowedPropertyCombinations {
    public static final String SIZE = "size";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String PACKED = "packed";
    private static final ComponentSizeHandler singleton = new ComponentSizeHandler();
    private PropertyCombination combination = new PropertyCombination();

    public static ComponentSizeHandler getInstance() {
        return singleton;
    }

    public ComponentSizeHandler() {
        super(new String[]{SIZE, WIDTH, HEIGHT});
        this.combination.add(new String[]{SIZE});
        this.combination.add(new String[]{WIDTH, HEIGHT});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handle(BuilderConfig config, BuildProcess result, Node node, String key) throws BuildException {
        Component component = (Component)node.getMainObject();
        if (node.getProperties().containsKey(SIZE)) {
            String size = (String)node.getProperties().get(SIZE);
            if (PACKED.equals(size)) {
                if (component instanceof Window) {
                    Window window = (Window)component;
                    window.pack();
                    return;
                } else {
                    if (!(component instanceof Frame)) throw new BuildException("'size : packed' is only valid for Window/Frame and subclasses", new Object[0]);
                    Frame frame = (Frame)component;
                    frame.pack();
                }
                return;
            } else {
                String[] parts = size.split("x");
                Integer width = Integer.parseInt(parts[0]);
                Integer height = Integer.parseInt(parts[1]);
                component.setSize(width, height);
            }
            return;
        } else {
            int width = node.getLongProperty(new String[]{WIDTH}).intValue();
            int height = node.getLongProperty(new String[]{HEIGHT}).intValue();
            component.setSize(width, height);
        }
    }

    public Class<?> getApplicableClass() {
        return Component.class;
    }

    public String getRegexPattern(String propertyName) {
        if (SIZE.equals(propertyName)) {
            return "\\d+x\\d+|packed";
        }
        if (WIDTH.equals(propertyName)) {
            return "\\d+";
        }
        if (HEIGHT.equals(propertyName)) {
            return "\\d+";
        }
        return "?";
    }

    public String getValidSample(String propertyName) {
        if (SIZE.equals(propertyName)) {
            return "800x400 | packed";
        }
        if (WIDTH.equals(propertyName)) {
            return "800";
        }
        if (HEIGHT.equals(propertyName)) {
            return "400";
        }
        return "?";
    }

    public PropertyCombination getAllowedCombinations() {
        return this.combination;
    }
}

