/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.property;

import java.awt.event.ActionListener;
import javax.swing.JTextField;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuilderConfig;
import org.javabuilders.Node;
import org.javabuilders.handler.AbstractPropertyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JTextFieldActionCommandHandler
extends AbstractPropertyHandler {
    private static final Logger logger = LoggerFactory.getLogger(JTextFieldActionCommandHandler.class);
    private static final JTextFieldActionCommandHandler singleton = new JTextFieldActionCommandHandler();

    public static JTextFieldActionCommandHandler getInstance() {
        return singleton;
    }

    private JTextFieldActionCommandHandler() {
        super(new String[]{"actionCommand"});
    }

    public void handle(BuilderConfig config, BuildProcess result, Node node, String key) throws BuildException {
        JTextField field = (JTextField)node.getMainObject();
        String actionCommand = String.valueOf(node.getProperties().get(key));
        field.setActionCommand(actionCommand);
        if (result.getCaller() != null && result.getCaller() instanceof ActionListener) {
            field.addActionListener((ActionListener)result.getCaller());
            if (logger.isDebugEnabled()) {
                logger.debug("Added calling ActionListener for actionCommand '{}' on button '{}'", (Object)actionCommand, (Object)field.getName());
            }
        }
    }

    public Class<JTextField> getApplicableClass() {
        return JTextField.class;
    }
}

