/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.handler.validation;

import java.util.LinkedList;
import java.util.List;
import org.javabuilders.BuildException;
import org.javabuilders.BuildResult;
import org.javabuilders.handler.validation.ICustomValidator;
import org.javabuilders.handler.validation.IPropertyValidator;
import org.javabuilders.handler.validation.IValidationMessageHandler;
import org.javabuilders.handler.validation.IValidator;
import org.javabuilders.handler.validation.PropertyValidations;
import org.javabuilders.handler.validation.ValidationMessageList;
import org.javabuilders.handler.validation.validator.AbstractValidator;
import org.javabuilders.handler.validation.validator.DateFormatValidator;
import org.javabuilders.handler.validation.validator.EmailAddressValidator;
import org.javabuilders.handler.validation.validator.MandatoryValidator;
import org.javabuilders.handler.validation.validator.MaxLengthValidator;
import org.javabuilders.handler.validation.validator.MaxValueValidator;
import org.javabuilders.handler.validation.validator.MinLengthValidator;
import org.javabuilders.handler.validation.validator.MinValueValidator;
import org.javabuilders.handler.validation.validator.RegexValidator;
import org.javabuilders.handler.validation.validator.TypeValidator;
import org.javabuilders.util.PropertyUtils;

public class BuilderValidators
extends LinkedList<PropertyValidations> {
    private BuildResult result;
    private static String defaultMandatoryMessage = "message.error.mandatory";
    private static String defaultMinLengthMessage = "message.error.minLength";
    private static String defaultMaxLengthMessage = "message.error.maxLength";
    private static String defaultDateFormatMessage = "message.error.dateFormat";
    private static String defaultMinValueMessage = "message.error.minValue";
    private static String defaultMaxValueMessage = "message.error.maxValue";
    private static String defaultNumericMessage = "message.error.numeric";
    private static String defaultEmailAddressMessage = "message.error.emailAddress";
    private static String defaultRegexMessage = "message.error.regex";
    private String mandatoryMessage = defaultMandatoryMessage;
    private String minLengthMessage = defaultMinLengthMessage;
    private String maxLengthMessage = defaultMaxLengthMessage;
    private String dateFormatMessage = defaultDateFormatMessage;
    private String minValueMessage = defaultMinValueMessage;
    private String maxValueMessage = defaultMaxValueMessage;
    private String numericMessage = defaultNumericMessage;
    private String emailAddressMessage = defaultEmailAddressMessage;
    private String regexMessage = defaultRegexMessage;
    private List<IValidator> validators = new LinkedList<IValidator>();
    private boolean validatorsCreated = false;

    public BuilderValidators(BuildResult result) {
        this.result = result;
    }

    public ValidationMessageList getValidationMessages(IValidationMessageHandler validationMessageHandler) {
        ValidationMessageList list = new ValidationMessageList();
        this.createValidators(validationMessageHandler);
        for (PropertyValidations validator : this) {
            boolean isMandatory;
            Object value;
            Object namedObject = this.result.get(validator.getProperty().getName());
            boolean isEmptyValue = false;
            try {
                value = PropertyUtils.getNestedProperty(namedObject, validator.getProperty().getPropertyExpression());
                if (value == null || String.valueOf(value).trim().length() == 0) {
                    isEmptyValue = true;
                }
            }
            catch (Exception e) {
                throw new BuildException("Error while processing validator for \"{0}\": {1}", namedObject, e);
            }
            boolean bl = isMandatory = this.getValidator(validator.getProperty().getName(), validator.getProperty().getPropertyExpression(), MandatoryValidator.class) != null;
            if (!isMandatory && isEmptyValue) continue;
            for (IValidator routine : this.getValidators()) {
                IPropertyValidator pRoutine;
                if (!(routine instanceof IPropertyValidator) || !(pRoutine = (IPropertyValidator)routine).getProperty().equals(validator.getProperty())) continue;
                pRoutine.validate(value, list);
            }
        }
        for (IValidator routine : this.getValidators()) {
            if (!(routine instanceof ICustomValidator)) continue;
            ((ICustomValidator)routine).validate(list);
        }
        return list;
    }

    public static String getDefaultMandatoryMessage() {
        return defaultMandatoryMessage;
    }

    public static void setDefaultMandatoryMessage(String defaultMandatoryMessage) {
        BuilderValidators.defaultMandatoryMessage = defaultMandatoryMessage;
    }

    public String getMandatoryMessage() {
        return this.mandatoryMessage;
    }

    public BuilderValidators setMandatoryMessage(String mandatoryMessage) {
        this.mandatoryMessage = mandatoryMessage;
        return this;
    }

    public String getMinLengthMessage() {
        return this.minLengthMessage;
    }

    public BuilderValidators setMinLengthMessage(String minLengthMessage) {
        this.minLengthMessage = minLengthMessage;
        return this;
    }

    public String getMaxLengthMessage() {
        return this.maxLengthMessage;
    }

    public BuilderValidators setMaxLengthMessage(String maxLengthMessage) {
        this.maxLengthMessage = maxLengthMessage;
        return this;
    }

    public static String getDefaultMinLengthMessage() {
        return defaultMinLengthMessage;
    }

    public static void setDefaultMinLengthMessage(String defaultMinLengthMessage) {
        BuilderValidators.defaultMinLengthMessage = defaultMinLengthMessage;
    }

    public static String getDefaultMaxLengthMessage() {
        return defaultMaxLengthMessage;
    }

    public static void setDefaultMaxLengthMessage(String defaultMaxLengthMessage) {
        BuilderValidators.defaultMaxLengthMessage = defaultMaxLengthMessage;
    }

    public static String getDefaultDateFormatMessage() {
        return defaultDateFormatMessage;
    }

    public static void setDefaultDateFormatMessage(String defaultDateFormatMessage) {
        BuilderValidators.defaultDateFormatMessage = defaultDateFormatMessage;
    }

    public String getDateFormatMessage() {
        return this.dateFormatMessage;
    }

    public BuilderValidators setDateFormatMessage(String dateFormatMessage) {
        this.dateFormatMessage = dateFormatMessage;
        return this;
    }

    public static String getDefaultNumericMessage() {
        return defaultNumericMessage;
    }

    public static void setDefaultNumericMessage(String defaultNumericMessage) {
        BuilderValidators.defaultNumericMessage = defaultNumericMessage;
    }

    public String getNumericMessage() {
        return this.numericMessage;
    }

    public BuilderValidators setNumericMessage(String numericMessage) {
        this.numericMessage = numericMessage;
        return this;
    }

    public List<IValidator> getValidators() {
        return this.validators;
    }

    public BuilderValidators add(ICustomValidator validator) {
        this.getValidators().add(validator);
        return this;
    }

    public BuilderValidators add(IPropertyValidator validator) {
        this.getValidators().add(validator);
        return this;
    }

    private void createValidators(IValidationMessageHandler validationMessageHandler) {
        if (!this.validatorsCreated) {
            for (PropertyValidations validator : this) {
                AbstractValidator v;
                Object namedObject = this.result.get(validator.getProperty().getName());
                String parsedLabel = validator.getLabel();
                parsedLabel = parsedLabel == null || parsedLabel.length() == 0 ? validationMessageHandler.getNamedObjectLabel(namedObject) : this.result.getResource(parsedLabel);
                if (validator.isMandatory()) {
                    v = new MandatoryValidator(validator.getProperty(), parsedLabel, this.getMandatoryMessage(), this.result);
                    this.validators.add(v);
                }
                if (validator.getType() != null) {
                    v = new TypeValidator(validator.getProperty(), parsedLabel, null, this.result, validator.getType());
                    this.validators.add(v);
                }
                if (validator.getMinLength() != null) {
                    v = new MinLengthValidator(validator.getProperty(), parsedLabel, this.getMinLengthMessage(), this.result, validator.getMinLength());
                    this.validators.add(v);
                }
                if (validator.getMaxLength() != null) {
                    v = new MaxLengthValidator(validator.getProperty(), parsedLabel, this.getMaxLengthMessage(), this.result, validator.getMaxLength());
                    this.validators.add(v);
                }
                if (validator.getDateFormat() != null) {
                    v = new DateFormatValidator(validator.getProperty(), parsedLabel, this.getDateFormatMessage(), this.result, validator.getDateFormat(), validator.getLocaleInstance());
                    this.validators.add(v);
                }
                if (validator.isEmailAddress()) {
                    v = new EmailAddressValidator(validator.getProperty(), parsedLabel, this.getEmailAddressMessage(), this.result);
                    this.validators.add(v);
                }
                if (validator.getRegex() != null) {
                    String msgFormat = validator.getRegexMessage() == null ? this.getRegexMessage() : validator.getRegexMessage();
                    RegexValidator v2 = new RegexValidator(validator.getProperty(), parsedLabel, msgFormat, this.result, validator.getRegex());
                    this.validators.add(v2);
                }
                if (validator.getMinValue() != null) {
                    v = new MinValueValidator(validator.getProperty(), parsedLabel, this.getMinValueMessage(), this.result, validator.getMinValue());
                    this.validators.add(v);
                }
                if (validator.getMaxValue() == null) continue;
                v = new MaxValueValidator(validator.getProperty(), parsedLabel, this.getMaxValueMessage(), this.result, validator.getMaxValue());
                this.validators.add(v);
            }
            this.validatorsCreated = true;
        }
    }

    public static String getDefaultEmailAddressMessage() {
        return defaultEmailAddressMessage;
    }

    public static void setDefaultEmailAddressMessage(String defaultEmailAddressMessage) {
        BuilderValidators.defaultEmailAddressMessage = defaultEmailAddressMessage;
    }

    public String getEmailAddressMessage() {
        return this.emailAddressMessage;
    }

    public void setEmailAddress(String emailAddressMessage) {
        this.emailAddressMessage = emailAddressMessage;
    }

    public static String getDefaultRegexMessage() {
        return defaultRegexMessage;
    }

    public static void setDefaultRegexMessage(String defaultRegexMessage) {
        BuilderValidators.defaultRegexMessage = defaultRegexMessage;
    }

    public String getRegexMessage() {
        return this.regexMessage;
    }

    public void setRegexMessage(String regexMessage) {
        this.regexMessage = regexMessage;
    }

    public static String getDefaultMaxValueMessage() {
        return defaultMaxValueMessage;
    }

    public static void setDefaultMaxValueMessage(String defaultMaxValueMessage) {
        BuilderValidators.defaultMaxValueMessage = defaultMaxValueMessage;
    }

    public static String getDefaultMinValueMessage() {
        return defaultMinValueMessage;
    }

    public static void setDefaultMinValueMessage(String defaultMinValueMessage) {
        BuilderValidators.defaultMinValueMessage = defaultMinValueMessage;
    }

    public String getMinValueMessage() {
        return this.minValueMessage;
    }

    public void setMinValueMessage(String minValueMessage) {
        this.minValueMessage = minValueMessage;
    }

    public String getMaxValueMessage() {
        return this.maxValueMessage;
    }

    public void setMaxValueMessage(String maxValueMessage) {
        this.maxValueMessage = maxValueMessage;
    }

    public IValidator getValidator(String objectName, String propertyExpression, Class<?> validatorType) {
        IValidator v = null;
        for (IValidator validator : this.getValidators()) {
            IPropertyValidator pv;
            if (!(validator instanceof IPropertyValidator) || !objectName.equals((pv = (IPropertyValidator)validator).getProperty().getName()) || !propertyExpression.equals(pv.getProperty().getPropertyExpression()) || !validator.getClass().equals(validatorType)) continue;
            v = validator;
            break;
        }
        return v;
    }
}

