/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.handler.validation.validator;

import org.javabuilders.BuildException;
import org.javabuilders.BuildResult;
import org.javabuilders.NamedObjectProperty;
import org.javabuilders.handler.validation.BuilderValidators;
import org.javabuilders.handler.validation.ValidationMessage;
import org.javabuilders.handler.validation.ValidationMessageList;
import org.javabuilders.handler.validation.validator.AbstractValidator;

public class MinValueValidator
extends AbstractValidator {
    private Object minValue = null;
    private Long minValueLong = null;
    private Double minValueDouble = null;

    public MinValueValidator(NamedObjectProperty property, String label, String messageFormat, BuildResult result, Object minValue) {
        super(property, label, messageFormat, result);
        this.minValue = minValue;
        try {
            this.minValueDouble = Double.parseDouble(minValue.toString());
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (this.minValueDouble == null) {
                this.minValueLong = Long.parseLong(minValue.toString());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.minValueDouble == null && this.minValueLong == null) {
            throw new BuildException("{0} is not a valid Long or Double comparison value", minValue);
        }
    }

    @Override
    public void validate(Object value, ValidationMessageList list) {
        String sValue = String.valueOf(value);
        if (this.minValueDouble != null) {
            try {
                Double dbl = Double.parseDouble(sValue);
                if (dbl < this.minValueDouble) {
                    list.add(new ValidationMessage(this.getProperty(), this.getMessage(this.getLabel(), this.minValue)));
                }
            }
            catch (NumberFormatException ex) {
                list.add(new ValidationMessage(this.getProperty(), this.getMessageForFormat(BuilderValidators.getDefaultNumericMessage(), this.getLabel())));
            }
        } else if (this.minValueLong != null) {
            try {
                Long lng = Long.parseLong(sValue);
                if (lng < this.minValueLong) {
                    list.add(new ValidationMessage(this.getProperty(), this.getMessage(this.getLabel(), this.minValue)));
                }
            }
            catch (NumberFormatException ex) {
                list.add(new ValidationMessage(this.getProperty(), this.getMessageForFormat(BuilderValidators.getDefaultNumericMessage(), this.getLabel())));
            }
        }
    }
}

