/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.event.background;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.swing.SwingWorker;
import org.javabuilders.BuildException;
import org.javabuilders.BuildResult;
import org.javabuilders.event.BackgroundEvent;
import org.javabuilders.event.IBackgroundCallback;
import org.javabuilders.event.IBackgroundProcessingHandler;
import org.javabuilders.swing.handler.event.background.BackgroundDialog;

public class SwingBackgroundProcessingHandler
implements IBackgroundProcessingHandler {
    private static final SwingBackgroundProcessingHandler singleton = new SwingBackgroundProcessingHandler();

    public static SwingBackgroundProcessingHandler getInstance() {
        return singleton;
    }

    private SwingBackgroundProcessingHandler() {
    }

    public void doInBackground(BuildResult result, final Object target, final Method method, final BackgroundEvent event, final IBackgroundCallback callbackWhenFinished) throws IOException, BuildException {
        Component componentForEvent;
        Component component = null;
        if (event.getSource() != null && event.getSource() instanceof Component) {
            component = (Component)event.getSource();
        }
        final boolean enabled = (componentForEvent = component) == null ? true : componentForEvent.isEnabled();
        final BackgroundDialog progressDialog = event.isBlocking() ? new BackgroundDialog(event, result) : null;
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                Object value = method.invoke(target, event);
                return value;
            }

            @Override
            protected void done() {
                if (progressDialog != null) {
                    progressDialog.setVisible(false);
                    progressDialog.dispose();
                }
                if (componentForEvent != null) {
                    componentForEvent.setEnabled(enabled);
                }
                try {
                    callbackWhenFinished.done(this.get());
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e, "Unexpected exception when getting back background method return value", new Object[0]);
                }
            }
        };
        if (componentForEvent != null) {
            componentForEvent.setEnabled(false);
        }
        worker.execute();
        if (progressDialog != null) {
            progressDialog.setVisible(true);
        }
    }
}

