/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.type;

import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuilderConfig;
import org.javabuilders.Node;
import org.javabuilders.handler.ITypeHandlerFinishProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ButtonGroupTypeHandler
implements ITypeHandlerFinishProcessor {
    private static final ButtonGroupTypeHandler singleton = new ButtonGroupTypeHandler();
    private static final Logger logger = LoggerFactory.getLogger(ButtonGroupTypeHandler.class);

    public static ButtonGroupTypeHandler getInstance() {
        return singleton;
    }

    private ButtonGroupTypeHandler() {
    }

    public void finish(BuilderConfig config, BuildProcess process, Node current, String key, Map<String, Object> typeDefinition) throws BuildException {
        block6: {
            try {
                ButtonGroup group = (ButtonGroup)current.getMainObject();
                Object content = current.getProperty(new String[]{"content"});
                if (content instanceof List) {
                    List buttons = (List)content;
                    for (String buttonName : buttons) {
                        Object button = process.getByName(buttonName);
                        if (button != null) {
                            if (button instanceof AbstractButton) {
                                AbstractButton btn = (AbstractButton)button;
                                group.add(btn);
                                continue;
                            }
                            throw new BuildException("ButtonGroup: ''{0}'' is not an instance of AbstractButton", new Object[]{buttonName});
                        }
                        throw new BuildException("ButtonGroup: ''{0}'' is not a valid named object", new Object[]{buttonName});
                    }
                    break block6;
                }
                throw new BuildException("ButtonGroup:content should be a list instead of: {0}", new Object[]{content});
            }
            catch (BuildException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }
}

