/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuildResult;
import org.javabuilders.BuilderConfig;
import org.javabuilders.BuilderPreProcessor;
import org.javabuilders.IAllowedPropertyCombinations;
import org.javabuilders.IAllowedPropertyFormat;
import org.javabuilders.IAllowedValues;
import org.javabuilders.IKeyValueConsumer;
import org.javabuilders.IPropertyList;
import org.javabuilders.ITypeAsValueSupport;
import org.javabuilders.InvalidParentTypeException;
import org.javabuilders.InvalidPropertyValueException;
import org.javabuilders.InvalidTypeException;
import org.javabuilders.MissingRequiredPropertyException;
import org.javabuilders.MissingRequiredTypeException;
import org.javabuilders.NamedObjectPropertyValue;
import org.javabuilders.Node;
import org.javabuilders.PrefixControlDefinition;
import org.javabuilders.TypeDefinition;
import org.javabuilders.ValueListDefinition;
import org.javabuilders.Values;
import org.javabuilders.annotations.BuildFile;
import org.javabuilders.event.BuildEvent;
import org.javabuilders.event.BuildListener;
import org.javabuilders.exception.InvalidFormatException;
import org.javabuilders.handler.GlobalVariablePropertyHandler;
import org.javabuilders.handler.IPropertyHandler;
import org.javabuilders.handler.ITypeAsValueHandler;
import org.javabuilders.handler.ITypeChildrenHandler;
import org.javabuilders.handler.ITypeHandler;
import org.javabuilders.handler.ITypeHandlerAfterCreationProcessor;
import org.javabuilders.handler.ITypeHandlerFinishProcessor;
import org.javabuilders.util.BuilderUtils;
import org.javabuilders.util.ChildrenCardinalityUtils;
import org.javabuilders.util.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class Builder {
    private static final Logger logger = LoggerFactory.getLogger(Builder.class);
    private static final Pattern prefixNameSplitter = Pattern.compile("([a-z]+)([A-Z0-9]+[a-zA-Z0-9]*)");
    public static final Map<String, ?> EMPTY_PROPERTIES = null;
    public static final String NAME = "name";
    public static final String CONTENT = "content";
    public static final String CONSTRAINTS = "constraints";
    public static final String BIND = "bind";
    public static final String VALIDATE = "validate";
    public static final String VALUE = "value";
    public static final String LAYOUT = "layout";
    public static final String ON_ACTION = "onAction";
    public static final String ON_FOCUS = "onFocus";
    public static final String ON_FOCUS_LOST = "onFocusLost";
    public static final String THIS = "this";
    public static final String NAMED_OBJECT_REGEX = "\\$\\{[a-zA-Z0-9]+\\}";
    private static final int NAMED_OBJECT_PREFIX_LENGTH = 2;
    private static final int NAMED_OBJECT_SUFFIX_LENGTH = 1;
    public static final String RESOURCE_BUNDLE = "org/javabuilders/Resources";
    public static final String VALIDATE_CUSTOM_COMMAND = "$validate";
    public static final String CONFIRM_CUSTOM_COMMAND = "$confirm";
    public static final String BOOLEAN_FALSE = "false";
    public static final String BOOLEAN_TRUE = "true";
    public static final String INTERNAL_FIELD_PREFIX = "__";
    public static final String PROTOTYPE_FIELD_PREFIX = "$";

    public static BuildResult build(BuilderConfig config, Object caller, ResourceBundle ... resourceBundles) {
        return Builder.build(config, caller, EMPTY_PROPERTIES, resourceBundles);
    }

    public static BuildResult build(BuilderConfig config, Object caller, Map<String, ?> customProperties, ResourceBundle ... resourceBundles) {
        Class<?> type = caller.getClass();
        String fileName = null;
        if (type.isAnnotationPresent(BuildFile.class)) {
            fileName = type.getAnnotation(BuildFile.class).value();
        } else {
            Class<?> declaringType = type.getDeclaringClass();
            if (declaringType == null) {
                fileName = type.getSimpleName() + config.getYamlExtension();
            } else {
                StringBuilder bld = new StringBuilder(type.getSimpleName());
                while (declaringType != null) {
                    bld.insert(0, declaringType.getSimpleName());
                    bld.insert(declaringType.getSimpleName().length(), ".");
                    declaringType = declaringType.getDeclaringClass();
                }
                bld.append(config.getYamlExtension());
                fileName = bld.toString();
            }
        }
        BuildResult result = Builder.build(config, caller, fileName, customProperties, resourceBundles);
        return result;
    }

    public static BuildResult build(BuilderConfig config, Object caller, String fileName, ResourceBundle ... resourceBundles) {
        return Builder.build(config, caller, fileName, null, resourceBundles);
    }

    public static BuildResult build(BuilderConfig config, Object caller, String fileName, Map<String, ?> customProperties, ResourceBundle ... resourceBundles) {
        if (caller == null) {
            throw new NullPointerException("Caller cannot be null or empty");
        }
        InputStream input = null;
        if (BuilderConfig.getDevSourceFolder() == null || caller.getClass().getPackage().getName().startsWith(Builder.class.getPackage().getName())) {
            input = caller.getClass().getResourceAsStream(fileName);
        } else {
            String yamlFileName = fileName;
            try {
                URI bin = caller.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
                URI src = bin.resolve(new URI(BuilderConfig.getDevSourceFolder() + "/" + caller.getClass().getPackage().getName().replace(".", "/") + "/" + fileName));
                yamlFileName = src.toString();
                input = new FileInputStream(new File(src));
            }
            catch (Exception e) {
                throw new BuildException(e, "Unable to process file {0}.\n{1}", yamlFileName, e);
            }
        }
        if (input == null) {
            throw new BuildException("No YAML file found: {0}.\nMaybe you are using an older extension (.yaml)  and need to change it via config.setYamlExtension(String) in your main().\nThe default was changed to ''.yml'' as of version 1.1 to be compatible with the YAML standard.", fileName);
        }
        StringBuilder bld = new StringBuilder();
        try {
            BufferedReader rdr = new BufferedReader(new InputStreamReader(input));
            String line = rdr.readLine();
            while (line != null) {
                bld.append(line).append("\n");
                line = rdr.readLine();
            }
            rdr.close();
        }
        catch (IOException ex) {
            throw new BuildException(ex);
        }
        return Builder.buildFromString(config, caller, bld.toString(), fileName, customProperties, resourceBundles);
    }

    public static BuildResult buildFromString(BuilderConfig config, Object caller, String yamlContent, ResourceBundle ... resourceBundles) {
        return Builder.buildFromString(config, caller, yamlContent, null, null, resourceBundles);
    }

    public static BuildResult buildFromString(BuilderConfig config, Object caller, String yamlContent, Map<String, ?> customProperties, ResourceBundle ... resourceBundles) {
        return Builder.buildFromString(config, caller, yamlContent, null, customProperties, resourceBundles);
    }

    public static BuildResult buildFromString(BuilderConfig config, Object caller, String yamlContent, String fileName, Map<String, ?> customProperties, ResourceBundle ... resourceBundles) {
        if (caller == null) {
            throw new NullPointerException("Caller cannot be null or empty");
        }
        BuildProcess process = new BuildProcess(config, caller, resourceBundles);
        if (customProperties != null) {
            for (String key : customProperties.keySet()) {
                process.getBuildResult().getProperties().put(key, customProperties.get(key));
            }
        }
        BuilderUtils.validateYamlContent(yamlContent, fileName);
        Yaml yaml = new Yaml();
        Object document = yaml.load(yamlContent);
        Builder.executeBuild(document, config, process);
        return process.getBuildResult();
    }

    public static Object buildControlFromName(BuildProcess process, Node parent, String name) {
        PrefixControlDefinition def;
        String suffix;
        if (logger.isDebugEnabled()) {
            logger.debug("Build control from name: {}, name");
        }
        Class<?> clazz = null;
        String yamlContent = null;
        if (name.startsWith(PROTOTYPE_FIELD_PREFIX)) {
            yamlContent = process.getConfig().getPrototype(name.substring(1));
            if (yamlContent != null) {
                yamlContent = yamlContent.trim();
                String key = BuilderUtils.getRealKey(yamlContent);
                clazz = process.getConfig().getClassType(key);
                if (clazz != null) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    BuilderUtils.uncompressYaml(yamlContent, map);
                    Builder.processDocumentNode(process.getConfig(), process, parent, clazz.getSimpleName(), map);
                    return process.getByName(name.substring(1));
                }
                throw new BuildException("Unable to find type for protype {0}", yamlContent);
            }
            throw new BuildException("Unable to find prototype definition for {0}", name);
        }
        Matcher m = prefixNameSplitter.matcher(name);
        if (m.find() && m.groupCount() == 2) {
            String prefix = m.group(1);
            suffix = m.group(2);
            def = process.getConfig().getPrefix(prefix);
            if (def == null) {
                throw new BuildException("Unable to find type for prefix {0} for {1}", prefix, name);
            }
        } else {
            throw new BuildException("Unable to parse prefix and suffix from control name: {0}", name);
        }
        clazz = def.getType();
        yamlContent = def.getDefaultsAsYaml(process, name, suffix);
        Yaml yaml = new Yaml();
        Object rawDocumentNode = yaml.load(yamlContent);
        Builder.processDocumentNode(process.getConfig(), process, parent, clazz.getSimpleName(), rawDocumentNode);
        return process.getByName(name);
    }

    private static void executeBuild(Object document, BuilderConfig config, BuildProcess process) throws BuildException {
        BuildListener[] listeners = config.getBuildListeners();
        BuildEvent buildEvent = new BuildEvent(process.getCaller(), process.getBuildResult());
        if (listeners.length > 0) {
            for (BuildListener listener : listeners) {
                listener.buildStarted(buildEvent);
            }
        }
        document = BuilderPreProcessor.preprocess(config, process, document, null);
        process.setDocument(document);
        if (logger.isDebugEnabled()) {
            logger.debug("Building from YAML document:\n{}", document);
        }
        if (document instanceof Map) {
            Map map = (Map)document;
            LinkedHashSet<String> systemNodes = new LinkedHashSet<String>();
            systemNodes.add(BIND);
            systemNodes.add(VALIDATE);
            LinkedList<String> priorities = new LinkedList<String>();
            for (String key : map.keySet()) {
                if (systemNodes.contains(key)) continue;
                priorities.add(key);
            }
            for (String systemNode : systemNodes) {
                if (!map.containsKey(systemNode)) continue;
                priorities.add(systemNode);
            }
            for (String key : priorities) {
                Object docNode = map.get(key);
                if (logger.isDebugEnabled()) {
                    logger.debug("Processing root node: {}", (Object)key);
                }
                if (docNode instanceof Map) {
                    Builder.processDocumentNode(config, process, null, key, docNode);
                } else if (docNode instanceof List) {
                    HashMap content = new HashMap();
                    content.put(CONTENT, docNode);
                    docNode = content;
                    Builder.processDocumentNode(config, process, null, key, docNode);
                } else if (docNode instanceof String) {
                    HashMap value = new HashMap();
                    value.put(VALUE, docNode);
                    docNode = value;
                    Builder.processDocumentNode(config, process, null, key, docNode);
                } else {
                    throw new BuildException("Unable to handle the root node :" + key, new Object[0]);
                }
                if (systemNodes.contains(key)) continue;
                for (NamedObjectPropertyValue request : process.getPropertiesAsNamedObjects()) {
                    request.setReference(process);
                }
                process.getPropertiesAsNamedObjects().clear();
            }
        } else {
            Builder.processDocumentNode(config, process, null, null, document);
        }
        BuilderUtils.updateNamedObjectReferencesInCaller(process);
        for (BuildListener listener : listeners = config.getBuildListeners()) {
            listener.buildEnded(buildEvent);
        }
    }

    private static void processDocumentNode(BuilderConfig config, BuildProcess process, Node parent, String currentKey, Object rawDocumentNode) throws BuildException {
        if (rawDocumentNode instanceof Map) {
            if (logger.isDebugEnabled()) {
                logger.debug("Started creating object defined by alias: {}", (Object)currentKey);
            }
            Map data = (Map)rawDocumentNode;
            Class<?> currentType = BuilderUtils.getClassFromAlias(process, currentKey, null);
            if (currentType == null) {
                throw new InvalidTypeException(currentKey);
            }
            Builder.handleType(config, process, parent, currentKey, data, currentType);
        } else if (rawDocumentNode instanceof List) {
            if (parent == null) {
                throw new BuildException("Yaml cannot start with a List as root: {0}", rawDocumentNode);
            }
            List items = (List)rawDocumentNode;
            Class<?> type = BuilderUtils.getClassFromAlias(process, currentKey, null);
            if (CONTENT.equals(currentKey) || type != null) {
                Node itemsNode = new Node(parent, currentKey);
                if (parent != null) {
                    parent.addChildNode(itemsNode);
                    itemsNode.setMainObject(parent.getMainObject());
                    itemsNode.setConsumedKeys(parent.getConsumedKeys());
                }
                boolean treatListAsPropertyValue = true;
                for (Object item : items) {
                    if (!(item instanceof Map)) continue;
                    Map itemMap = (Map)item;
                    for (String itemKey : itemMap.keySet()) {
                        Object itemValue = itemMap.get(itemKey);
                        Builder.processDocumentNode(config, process, itemsNode, itemKey, itemValue);
                        treatListAsPropertyValue = false;
                    }
                }
                if (treatListAsPropertyValue) {
                    Builder.handleProperty(config, process, parent, currentKey);
                }
            } else {
                Builder.handleProperty(config, process, parent, currentKey);
            }
        } else if (parent != null) {
            Builder.handleProperty(config, process, parent, currentKey);
        } else {
            throw new InvalidFormatException("Unable to process document node : {0}", rawDocumentNode);
        }
    }

    public static Object createControlFromCompressedYaml(BuildProcess process, Node parent, String compressedYaml) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        BuilderUtils.uncompressYaml(compressedYaml, data);
        String key = BuilderUtils.getRealKey(compressedYaml);
        Class<?> classType = BuilderUtils.getClassFromAlias(process, key, null);
        return Builder.handleType(process.getConfig(), process, parent, key, data, classType).getMainObject();
    }

    private static Node handleType(BuilderConfig config, BuildProcess process, Node parent, String currentKey, Map<String, Object> data, Class<?> classType) throws BuildException {
        Class<?> parentClass;
        Method method;
        ITypeHandlerFinishProcessor finishProcessor;
        Class<?> currentType = BuilderUtils.getClassFromAlias(process, currentKey, null);
        if (currentType == null) {
            throw new InvalidTypeException(currentKey);
        }
        Builder.handleDefaults(config, process, parent, currentKey, data, currentType);
        Builder.validate(config, process, parent, currentKey, data, currentType);
        ITypeHandler typeHandler = TypeDefinition.getTypeHandler(config, currentType);
        Node current = null;
        Object existingInstance = BuilderUtils.getExistingInstanceIfAvailable(process.getCaller(), currentType, config, data);
        current = existingInstance != null ? typeHandler.useExistingInstance(config, process, parent, currentKey, data, existingInstance) : (parent == null && process.getCaller() != null && currentType.isAssignableFrom(process.getCaller().getClass()) ? typeHandler.useExistingInstance(config, process, parent, currentKey, data, process.getCaller()) : typeHandler.createNewInstance(config, process, parent, currentKey, data));
        if (current == null) {
            return null;
        }
        if (current.getMainObject() == null) {
            throw new BuildException("ITypeHandler for alias " + currentKey + " did not set Node.mainObject to a value", new Object[0]);
        }
        for (String typeHandlerKey : typeHandler.getConsumedKeys()) {
            current.getConsumedKeys().add(typeHandlerKey);
        }
        TypeDefinition def = config.getTypeDefinition(currentType);
        if (def != null && (finishProcessor = config.getTypeDefinition(currentType).getFinishProcessor()) != null && finishProcessor instanceof IKeyValueConsumer) {
            IKeyValueConsumer consumer = (IKeyValueConsumer)((Object)finishProcessor);
            for (String key : consumer.getConsumedKeys()) {
                current.getConsumedKeys().add(key);
            }
        }
        Class<?> createdClassType = current.getMainObject().getClass();
        Set<TypeDefinition> typeDefinitions = config.getTypeDefinitions(createdClassType);
        Set<String> ignored = TypeDefinition.getIgnored(config, current.getMainObject().getClass());
        List<ITypeHandlerAfterCreationProcessor> afterCreationProcessors = TypeDefinition.getAfterCreationProcessors(config, createdClassType);
        for (ITypeHandlerAfterCreationProcessor processor : afterCreationProcessors) {
            processor.afterCreation(config, process, current, currentKey, data);
        }
        if (parent != null && (method = TypeDefinition.getTypeAsMethod(config, parentClass = parent.getMainObject().getClass(), createdClassType)) != null) {
            try {
                Object target = parent.getMainObject();
                Object argument = current.getMainObject();
                method.invoke(target, argument);
            }
            catch (Exception e) {
                throw new BuildException(e, "Unable to call {0} on {1} with type {2}. Error: {3}", method, parentClass.getSimpleName(), createdClassType.getSimpleName(), e.getMessage());
            }
        }
        if (!(typeHandler instanceof ITypeChildrenHandler)) {
            TreeMap<Integer, List<String>> delayedKeysByWeight = new TreeMap<Integer, List<String>>();
            for (String childKey : data.keySet()) {
                Class<?> childClass;
                Object childValue = data.get(childKey);
                if (current.getConsumedKeys().contains(childKey)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Processing child key: {}", (Object)childKey);
                }
                if (childValue instanceof String && TypeDefinition.isLocalizableProperty(childKey, typeDefinitions)) {
                    data.put(childKey, process.getBuildResult().getResource(String.valueOf(childValue)));
                }
                if ((childClass = BuilderUtils.getClassFromAlias(process, childKey, null)) != null) {
                    ITypeHandler childTypeHandler = TypeDefinition.getTypeHandler(config, childClass);
                    Integer delayedWeight = TypeDefinition.getDelayedWeight(childTypeHandler, config.getTypeDefinitions(createdClassType));
                    if (childTypeHandler != null && delayedWeight > 0) {
                        Builder.addToDelayedKeys(delayedKeysByWeight, delayedWeight, childKey);
                        continue;
                    }
                    Builder.processDocumentNode(config, process, current, childKey, childValue);
                    continue;
                }
                if (ignored.contains(childKey) || Builder.isInternal(childKey)) continue;
                Integer delayedWeight = TypeDefinition.getDelayedWeight(typeHandler, childKey, config.getTypeDefinitions(createdClassType));
                if (delayedWeight > 0) {
                    Builder.addToDelayedKeys(delayedKeysByWeight, delayedWeight, childKey);
                    continue;
                }
                Builder.processDocumentNode(config, process, current, childKey, childValue);
            }
            for (Integer delayWeight : delayedKeysByWeight.keySet()) {
                List keys = (List)delayedKeysByWeight.get(delayWeight);
                for (String delayedKey : keys) {
                    Object delayedValue = data.get(delayedKey);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Processing delayed weight: {} / {}", (Object)delayWeight, (Object)delayedKey);
                    }
                    Builder.processDocumentNode(config, process, current, delayedKey, delayedValue);
                }
            }
            ChildrenCardinalityUtils.checkChildrenCardinality(config, current);
        }
        if (parent == null && current.getMainObject() != null) {
            process.getBuildResult().getRoots().add(current.getMainObject());
        }
        if (typeHandler instanceof ITypeHandlerFinishProcessor) {
            ITypeHandlerFinishProcessor postHandler = (ITypeHandlerFinishProcessor)((Object)typeHandler);
            postHandler.finish(config, process, current, currentKey, data);
        }
        List<ITypeHandlerFinishProcessor> postProcessors = TypeDefinition.getFinishProcessors(config, createdClassType);
        for (ITypeHandlerFinishProcessor postProcessor : postProcessors) {
            postProcessor.finish(config, process, current, currentKey, data);
        }
        String name = config.getNameIfAvailable(data);
        if (name != null) {
            process.addNamedObject(name, current.getMainObject());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Finished creating object defined by alias: {}", (Object)currentKey);
        }
        return current;
    }

    private static boolean isInternal(String childKey) {
        return childKey.startsWith(INTERNAL_FIELD_PREFIX);
    }

    private static void addToDelayedKeys(Map<Integer, List<String>> delayedKeysByWeight, Integer delayWeight, String key) {
        List<String> delayedKeys = delayedKeysByWeight.get(delayWeight);
        if (delayedKeys == null) {
            delayedKeys = new LinkedList<String>();
            delayedKeysByWeight.put(delayWeight, delayedKeys);
        }
        delayedKeys.add(key);
    }

    private static void handleProperty(BuilderConfig config, BuildProcess process, Node parent, String currentKey) throws BuildException {
        if (!parent.getConsumedKeys().contains(currentKey)) {
            IPropertyHandler handler;
            block13: {
                String sValue;
                if (parent.getProperty(currentKey) instanceof String && (sValue = parent.getStringProperty(currentKey)).matches(NAMED_OBJECT_REGEX)) {
                    NamedObjectPropertyValue nopValue = new NamedObjectPropertyValue(parent.getMainObject(), currentKey, sValue.substring(2, sValue.length() - 1));
                    process.getPropertiesAsNamedObjects().add(nopValue);
                    parent.getConsumedKeys().add(currentKey);
                    return;
                }
                if (parent.getProperty(currentKey) instanceof String && (sValue = parent.getStringProperty(currentKey)).matches("\\$\\$\\{[a-zA-Z0-9]+\\}")) {
                    GlobalVariablePropertyHandler.getInstance().handle(config, process, parent, currentKey);
                    return;
                }
                handler = TypeDefinition.getPropertyHandler(config, parent.getMainObject().getClass(), currentKey);
                if (logger.isDebugEnabled()) {
                    if (handler.getConsumedKeys().size() == 0) {
                        logger.debug("Handling property '{}' of value '{}' for type alias '{}'", new Object[]{currentKey, parent.getProperties().get(currentKey), parent.getKey()});
                    } else {
                        for (String consumedKey : handler.getConsumedKeys()) {
                            if (!parent.getProperties().containsKey(consumedKey)) continue;
                            logger.debug("Handling property '{}' of value '{}' for type alias '{}'", new Object[]{consumedKey, parent.getProperties().get(consumedKey), parent.getKey()});
                        }
                    }
                }
                if (handler instanceof IPropertyList) {
                    IPropertyList propertyList = (IPropertyList)((Object)handler);
                    for (String consumedKey : handler.getConsumedKeys()) {
                        Object value;
                        if (!propertyList.isList(consumedKey) || (value = parent.getProperties().get(consumedKey)) == null || value instanceof List) continue;
                        ArrayList<Object> valueList = new ArrayList<Object>();
                        valueList.add(value);
                        parent.getProperties().put(consumedKey, valueList);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Converted single value {} to a single item list for property ", (Object)consumedKey);
                    }
                }
                try {
                    Class<?> propertyType;
                    ITypeAsValueHandler<? extends Object> asValueHandler;
                    if (!(handler instanceof ITypeAsValueSupport) || !PropertyUtils.isValid(parent.getMainObject(), currentKey) || (asValueHandler = TypeDefinition.getTypeAsValueHandler(config, propertyType = PropertyUtils.getPropertyType(parent.getMainObject(), currentKey))) == null) break block13;
                    String sValue2 = parent.getStringProperty(currentKey);
                    if (sValue2.matches(asValueHandler.getRegex())) {
                        parent.getProperties().put(currentKey, asValueHandler.getValue(process, parent, currentKey, parent.getProperty(currentKey)));
                        break block13;
                    }
                    throw new BuildException("Invalid {0} value \"{1}\" for {2}.{3}. Must in be in \"{4}\" format, e.g. \"{5}\"", propertyType.getSimpleName(), sValue2, parent.getMainObject().getClass().getSimpleName(), currentKey, asValueHandler.getRegex(), asValueHandler.getInputValueSample());
                }
                catch (Exception e) {
                    throw new BuildException(e, "Unable to process property {0}.{1} : {2}", parent.getMainObject().getClass().getSimpleName(), currentKey, e.getMessage());
                }
            }
            Builder.validateProperty(handler, config, process, parent, currentKey);
            handler.handle(config, process, parent, currentKey);
            parent.getConsumedKeys().add(currentKey);
            for (String key : handler.getConsumedKeys()) {
                parent.getConsumedKeys().add(key);
            }
        }
    }

    private static void validateProperty(IPropertyHandler handler, BuilderConfig config, BuildProcess result, Node parent, String currentKey) throws BuildException {
        IAllowedPropertyCombinations combination;
        if (handler instanceof IAllowedValues) {
            String value = parent.getStringProperty(currentKey);
            IAllowedValues list = (IAllowedValues)((Object)handler);
            if (!list.getAllowedValues().contains(value)) {
                throw new InvalidPropertyValueException(parent.getKey(), currentKey, (Object)value, list.getAllowedValues());
            }
        }
        if (handler instanceof IAllowedPropertyFormat) {
            IAllowedPropertyFormat format = (IAllowedPropertyFormat)((Object)handler);
            for (String consumedKey : handler.getConsumedKeys()) {
                String value;
                if (!parent.containsProperty(consumedKey) || (value = parent.getStringProperty(consumedKey)).matches(format.getRegexPattern(currentKey))) continue;
                throw new InvalidPropertyValueException(parent.getKey(), currentKey, (Object)value, format.getRegexPattern(currentKey), format.getValidSample(currentKey));
            }
        }
        if (handler instanceof IAllowedPropertyCombinations && !(combination = (IAllowedPropertyCombinations)((Object)handler)).getAllowedCombinations().isValid(parent.getProperties().keySet())) {
            throw new BuildException("Invalid combination of properties. Valid are: " + combination.getAllowedCombinations(), new Object[0]);
        }
        if (handler instanceof IPropertyList) {
            IPropertyList listHandler = (IPropertyList)((Object)handler);
            for (String consumedKey : handler.getConsumedKeys()) {
                if (!parent.containsProperty(consumedKey) || !listHandler.isList(consumedKey)) continue;
                List values = (List)parent.getProperties().get(consumedKey);
                Values valueList = null;
                for (ValueListDefinition vlDef : listHandler.getValueListDefinitions(consumedKey)) {
                    if (!vlDef.isExactMatch(values)) continue;
                    valueList = new Values(vlDef);
                    vlDef.validateValues(values, result, parent, valueList);
                    if (valueList.isValid()) break;
                    throw new BuildException(valueList.getErrors(), new Object[0]);
                }
                if (valueList == null) {
                    throw new BuildException(String.format("Values '%s' did not match to any defined value list definition for property '%s'", values, consumedKey), new Object[0]);
                }
                parent.getProperties().put(consumedKey, valueList);
            }
        }
    }

    private static void validate(BuilderConfig config, BuildProcess process, Node parent, String currentKey, Map<String, Object> currentProperties, Class<?> classType) throws InvalidParentTypeException, MissingRequiredPropertyException, MissingRequiredTypeException {
        if (parent != null && !TypeDefinition.isParentAllowed(parent, config.getTypeDefinitions(classType))) {
            throw new InvalidParentTypeException(classType, parent.getMainObject().getClass(), TypeDefinition.getAllowedParents(config, classType));
        }
        for (String string : TypeDefinition.getRequiredKeys(config, classType)) {
            if (currentProperties.containsKey(string)) continue;
            throw new MissingRequiredPropertyException(currentKey, string, currentProperties);
        }
        for (Class clazz : TypeDefinition.getRequiredTypes(config, classType)) {
            boolean found = false;
            for (String key : currentProperties.keySet()) {
                Class<?> type;
                if (!(currentProperties.get(key) instanceof Map) || (type = BuilderUtils.getClassFromAlias(process, key, null)) == null || !clazz.isAssignableFrom(type)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new MissingRequiredTypeException(currentKey, clazz, currentProperties);
        }
    }

    private static void handleDefaults(BuilderConfig config, BuildProcess result, Node parent, String currentKey, Map<String, Object> currentProperties, Class<?> classType) {
        Map<String, Object> defaults = TypeDefinition.getDefaults(config, classType);
        for (String key : defaults.keySet()) {
            if (currentProperties.containsKey(key)) continue;
            currentProperties.put(key, defaults.get(key));
        }
    }
}

