/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuilderConfig;
import org.javabuilders.TypeDefinition;
import org.javabuilders.exception.UnrecognizedAliasException;
import org.javabuilders.handler.ITypeChildrenHandler;
import org.javabuilders.handler.ITypeHandler;
import org.javabuilders.util.BuilderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuilderPreProcessor {
    public static final Logger logger = LoggerFactory.getLogger(BuilderPreProcessor.class);
    public static final Map<Character, Character> listIndicators = new HashMap<Character, Character>();

    public static Object preprocess(BuilderConfig config, BuildProcess process, Object current, Object parent) throws BuildException {
        try {
            if (current instanceof Map) {
                current = BuilderPreProcessor.handleMap(config, process, current, parent);
            } else if (current instanceof List) {
                current = BuilderPreProcessor.handleList(config, process, current, parent);
            } else if (current instanceof String && parent == null) {
                current = BuilderPreProcessor.handleString(config, process, current, parent);
            }
            return current;
        }
        catch (BuildException be) {
            logger.error(be.getMessage(), (Throwable)be);
            throw be;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BuildException(e);
        }
    }

    private static Object handleMap(BuilderConfig config, BuildProcess process, Object current, Object parent) throws BuildException {
        Map map = (Map)current;
        ArrayList<String> keysToRemove = new ArrayList<String>();
        HashMap<String, HashMap<String, Object>> propertiesToAdd = new HashMap<String, HashMap<String, Object>>();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            String realKey = BuilderUtils.getRealKey(key);
            Class<?> typeClass = BuilderUtils.getClassFromAlias(process, realKey, null);
            if (typeClass != null) {
                ITypeHandler handler = TypeDefinition.getTypeHandler(config, typeClass);
                BuilderPreProcessor.explodeShortcutTypeToMap(config, process, handler, key, map);
                HashMap<String, Object> typeMap = (HashMap<String, Object>)map.get(key);
                if (typeMap == null) {
                    typeMap = new HashMap<String, Object>();
                }
                if (!key.equals(realKey)) {
                    BuilderUtils.uncompressYaml(key, typeMap);
                    propertiesToAdd.put(realKey, typeMap);
                    keysToRemove.add(key);
                }
                BuilderPreProcessor.handlePropertyAlias(config, typeClass, typeMap);
                BuilderPreProcessor.handleMappedProperties(config, typeClass, typeMap);
                if (handler instanceof ITypeChildrenHandler) continue;
                BuilderPreProcessor.preprocess(config, process, typeMap, current);
                continue;
            }
            BuilderPreProcessor.preprocess(config, process, value, current);
        }
        for (String key : keysToRemove) {
            map.remove(key);
        }
        for (String key : propertiesToAdd.keySet()) {
            map.put(key, propertiesToAdd.get(key));
        }
        return current;
    }

    private static Object handleList(BuilderConfig config, BuildProcess process, Object current, Object parent) throws BuildException {
        List list = (List)current;
        for (int i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            if (item instanceof String) {
                String stringItem = (String)item;
                String realKey = BuilderUtils.getRealKey(stringItem);
                if (!stringItem.equals(realKey)) {
                    Class<?> typeClass = BuilderUtils.getClassFromAlias(process, realKey, null);
                    if (typeClass != null) {
                        HashMap<String, HashMap<String, Object>> rootMap = new HashMap<String, HashMap<String, Object>>();
                        HashMap<String, Object> typeMap = new HashMap<String, Object>();
                        rootMap.put(realKey, typeMap);
                        BuilderUtils.uncompressYaml(stringItem, typeMap);
                        list.remove(i);
                        list.add(i, rootMap);
                        BuilderPreProcessor.handlePropertyAlias(config, typeClass, typeMap);
                        BuilderPreProcessor.handleMappedProperties(config, typeClass, typeMap);
                        continue;
                    }
                    throw new BuildException("{0} is not a recognized alias", realKey);
                }
                BuilderPreProcessor.preprocess(config, process, item, current);
                continue;
            }
            BuilderPreProcessor.preprocess(config, process, item, current);
        }
        return current;
    }

    private static Object handleString(BuilderConfig config, BuildProcess process, Object current, Object parent) throws BuildException {
        String value = (String)((Object)current);
        String realKey = BuilderUtils.getRealKey(value);
        if (!value.equals(realKey)) {
            Class<?> typeClass = BuilderUtils.getClassFromAlias(process, realKey, null);
            if (typeClass != null) {
                HashMap<String, HashMap<String, Object>> rootMap = new HashMap<String, HashMap<String, Object>>();
                HashMap<String, Object> typeMap = new HashMap<String, Object>();
                rootMap.put(realKey, typeMap);
                BuilderUtils.uncompressYaml(value, typeMap);
                current = rootMap;
                BuilderPreProcessor.preprocess(config, process, rootMap, parent);
                BuilderPreProcessor.handlePropertyAlias(config, typeClass, typeMap);
                BuilderPreProcessor.handleMappedProperties(config, typeClass, typeMap);
            } else {
                throw new UnrecognizedAliasException("\"{0}\" is not a recognized alias", realKey);
            }
        }
        return current;
    }

    public static void explodeShortcutTypeToMap(BuilderConfig config, BuildProcess process, ITypeHandler handler, String key, Map<String, Object> current) throws BuildException {
        HashMap value = current.get(key);
        if (value instanceof List) {
            HashMap childMap = new HashMap();
            childMap.put(handler.getCollectionPropertyName(), value);
            value = childMap;
            current.put(key, childMap);
        }
        if (value instanceof String) {
            Class<?> valueClass;
            String sValue = (String)((Object)value);
            boolean isType = false;
            String realTypeKey = BuilderUtils.getRealKey(sValue);
            if (!realTypeKey.equals(value) && (valueClass = BuilderUtils.getClassFromAlias(process, realTypeKey, null)) != null) {
                HashMap<String, HashMap<String, Object>> rootMap = new HashMap<String, HashMap<String, Object>>();
                HashMap<String, Object> typeMap = new HashMap<String, Object>();
                current.put(key, rootMap);
                rootMap.put(realTypeKey, typeMap);
                BuilderUtils.uncompressYaml(sValue, typeMap);
                isType = true;
            }
            if (!isType) {
                HashMap childMap = new HashMap();
                childMap.put(handler.getSimpleValuePropertyName(), value);
                value = childMap;
                current.put(key, childMap);
            }
        }
    }

    private static void handlePropertyAlias(BuilderConfig config, Class<?> typeClass, Map<String, Object> typeMap) throws BuildException {
        Iterator<String> it = typeMap.keySet().iterator();
        HashMap<String, Object> aliasedPropertiesToAdd = new HashMap<String, Object>();
        while (it.hasNext()) {
            String typeMapKey = it.next();
            String actual = TypeDefinition.getPropertyForAlias(config, typeClass, typeMapKey);
            if (actual == null) continue;
            if (typeMap.containsKey(actual)) {
                throw new BuildException("Both \"{0}\" alias ({1}) and actual \"{2}\" property ({3}) have been specified. Only can of the two is allowed.", typeMapKey, typeMap.get(typeMapKey), actual, typeMap.get(actual));
            }
            aliasedPropertiesToAdd.put(actual, typeMap.get(typeMapKey));
            it.remove();
        }
        for (String typeMapKey : aliasedPropertiesToAdd.keySet()) {
            typeMap.put(typeMapKey, aliasedPropertiesToAdd.get(typeMapKey));
        }
    }

    private static void handleMappedProperties(BuilderConfig config, Class<?> typeClass, Map<String, Object> typeMap) throws BuildException {
        for (String typeMapKey : typeMap.keySet()) {
            Object mappedValue;
            Object typeMapValue = typeMap.get(typeMapKey);
            if (typeMapValue == null || (mappedValue = TypeDefinition.getPropertyValue(config, typeClass, typeMapKey, typeMapValue)).equals(typeMapValue)) continue;
            typeMap.put(typeMapKey, mappedValue);
        }
    }

    static {
        listIndicators.put(Character.valueOf('('), Character.valueOf(')'));
        listIndicators.put(Character.valueOf('['), Character.valueOf(']'));
        listIndicators.put(null, null);
    }
}

