/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.EventMethod;
import org.javabuilders.NamedObject;
import org.javabuilders.Node;
import org.javabuilders.ValueDefinition;
import org.javabuilders.Values;

public class ValueListDefinition {
    private List<ValueDefinition> valueDefs = new LinkedList<ValueDefinition>();

    public static List<ValueListDefinition> getCommonEventDefinitions(Class<?> ... relatedTypes) {
        ArrayList<ValueListDefinition> eventDefs = new ArrayList<ValueListDefinition>();
        ValueListDefinition vlDef = new ValueListDefinition(new ValueDefinition[0]);
        ValueDefinition def = new ValueDefinition("methodName", EventMethod.class);
        def.setVariableLength(true);
        def.setRelatedTypes(relatedTypes);
        vlDef.addValueDefinition(def);
        eventDefs.add(vlDef);
        return eventDefs;
    }

    public ValueListDefinition(ValueDefinition ... valueDefs) {
        this.valueDefs = new LinkedList<ValueDefinition>(Arrays.asList(valueDefs));
        this.validateValueDefinitions();
    }

    public ValueListDefinition addValueDefinition(ValueDefinition valueDef) {
        this.valueDefs.add(0, valueDef);
        this.validateValueDefinitions();
        return this;
    }

    private void validateValueDefinitions() {
        boolean noMoreAllowed = false;
        for (ValueDefinition def : this.valueDefs) {
            if (noMoreAllowed) {
                throw new BuildException("Only the last value definition may have variable length", new Object[0]);
            }
            if (!def.isVariableLength()) continue;
            noMoreAllowed = true;
        }
    }

    public boolean isPotentialMatch(List<Object> values) {
        boolean potential = false;
        for (Object value : values) {
        }
        return potential;
    }

    public void applyDefaults(List<Object> values) {
        int i = 0;
        for (ValueDefinition valueDef : this.valueDefs) {
            if (values.size() > i) {
                Object value = values.get(i);
                if (value == null || String.valueOf(value).length() == 0) {
                    values.set(i, valueDef.getDefaultValue());
                }
            } else {
                values.add(valueDef.getDefaultValue());
            }
            ++i;
        }
    }

    public boolean isExactMatch(List<Object> values) {
        boolean exact = true;
        if (this.valueDefs.size() <= values.size()) {
            ValueDefinition variableDef = null;
            for (int i = 0; i < values.size(); ++i) {
                Class<?> def = null;
                if (variableDef != null) {
                    def = variableDef.getType();
                } else {
                    ValueDefinition valueDef = this.valueDefs.get(i);
                    def = valueDef.getType();
                    if (valueDef.isVariableLength()) {
                        variableDef = valueDef;
                    }
                }
                Class<?> value = values.get(i).getClass();
                if (def.equals(NamedObject.class)) {
                    if (value.equals(String.class)) continue;
                    exact = false;
                } else if (def.equals(EventMethod.class)) {
                    if (value.equals(String.class)) continue;
                    exact = false;
                } else {
                    if (def.isAssignableFrom(value)) continue;
                    exact = false;
                }
                break;
            }
        } else {
            exact = false;
        }
        return exact;
    }

    public Values validateValues(List<Object> values, BuildProcess result, Node node, Values valueList) throws BuildException {
        Values validations = new Values(this);
        ValueDefinition variableDef = null;
        for (int i = 0; i < values.size(); ++i) {
            ValueDefinition def = null;
            if (variableDef != null) {
                def = variableDef;
            } else {
                def = this.valueDefs.get(i);
                if (def.isVariableLength()) {
                    variableDef = def;
                }
            }
            Object value = values.get(i);
            def.validateValue(result, node, value, valueList);
        }
        return validations;
    }
}

