/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.event;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EventObject;
import org.javabuilders.BuildResult;
import org.javabuilders.event.CancelStatus;

public class BackgroundEvent
extends EventObject {
    private Boolean isCancelable = false;
    private CancelStatus cancelStatus = CancelStatus.FORBIDDEN;
    private Integer progressStart = 0;
    private Integer progressEnd = 100;
    private Integer progressValue = 0;
    private String progressMessage = "";
    private Object originalEvent = null;
    private Boolean isProgressIndeterminate = false;
    private Boolean isBlocking = true;
    private PropertyChangeSupport support = null;

    public BackgroundEvent(Object source, Object originalEvent, boolean isBlocking, BuildResult result) {
        super(source);
        this.originalEvent = originalEvent;
        this.support = result.getConfig().createPropertyChangeSupport(this);
        this.progressMessage = result.getResource("label.processing");
        this.isBlocking = isBlocking;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(propertyName, listener);
    }

    public boolean isCancelable() {
        return this.isCancelable;
    }

    public synchronized void setCancelable(Boolean isCancelable) {
        Boolean oldValue = this.isCancelable;
        this.isCancelable = isCancelable;
        this.support.firePropertyChange("cancelable", oldValue, this.isCancelable);
        if (isCancelable.booleanValue()) {
            if (this.cancelStatus == CancelStatus.NONE) {
                this.cancelStatus = CancelStatus.FORBIDDEN;
            }
        } else {
            this.cancelStatus = CancelStatus.FORBIDDEN;
        }
    }

    public CancelStatus getCancelStatus() {
        return this.cancelStatus;
    }

    public synchronized void setCancelStatus(CancelStatus cancelStatus) {
        if (cancelStatus != CancelStatus.FORBIDDEN) {
            CancelStatus oldValue = this.cancelStatus;
            this.cancelStatus = cancelStatus;
            this.support.firePropertyChange("cancelStatus", (Object)oldValue, (Object)this.cancelStatus);
        }
    }

    public Integer getProgressStart() {
        return this.progressStart;
    }

    public synchronized void setProgressStart(Integer progressStart) {
        Integer oldValue = this.progressStart;
        this.progressStart = progressStart;
        this.support.firePropertyChange("progressStart", oldValue, this.progressStart);
    }

    public Integer getProgressEnd() {
        return this.progressEnd;
    }

    public synchronized void setProgressEnd(Integer progressEnd) {
        Integer oldValue = this.progressEnd;
        this.progressEnd = progressEnd;
        this.support.firePropertyChange("progressEnd", oldValue, progressEnd);
    }

    public Integer getProgressValue() {
        return this.progressValue;
    }

    public synchronized void setProgressValue(Integer currentProgressValue) {
        Integer oldValue = this.progressValue;
        this.progressValue = currentProgressValue;
        this.support.firePropertyChange("progressValue", oldValue, this.progressValue);
    }

    public String getProgressMessage() {
        return this.progressMessage;
    }

    public synchronized void setProgressMessage(String progressMessage) {
        String oldValue = this.progressMessage;
        this.progressMessage = progressMessage;
        this.support.firePropertyChange("progressMessage", oldValue, progressMessage);
    }

    public Object getOriginalEvent() {
        return this.originalEvent;
    }

    public Boolean getProgressIndeterminate() {
        return this.isProgressIndeterminate;
    }

    public synchronized void setProgressIndeterminate(Boolean isProgressIndeterminate) {
        Boolean oldValue = this.isProgressIndeterminate;
        this.isProgressIndeterminate = isProgressIndeterminate;
        this.support.firePropertyChange("progressIndeterminate", oldValue, isProgressIndeterminate);
    }

    public boolean isBlocking() {
        return this.isBlocking;
    }
}

