/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.handler;

import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuilderConfig;
import org.javabuilders.Node;
import org.javabuilders.handler.AbstractPropertyHandler;
import org.javabuilders.util.PropertyUtils;

public class GlobalVariablePropertyHandler
extends AbstractPropertyHandler {
    private static final GlobalVariablePropertyHandler instance = new GlobalVariablePropertyHandler();

    public static GlobalVariablePropertyHandler getInstance() {
        return instance;
    }

    private GlobalVariablePropertyHandler() {
        super(new String[0]);
    }

    @Override
    public void handle(BuilderConfig config, BuildProcess process, Node node, String key) throws BuildException {
        Object main = node.getMainObject();
        String name = node.getStringProperty(key);
        try {
            Class<?> type = PropertyUtils.getPropertyType(main, key);
            Object value = config.getGlobalVariable(name, type);
            PropertyUtils.setProperty(main, key, value);
        }
        catch (BuildException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new BuildException("Unable to access or set property \"{0}\" : {1}", key, e);
        }
    }

    public Class<Object> getApplicableClass() {
        return Object.class;
    }
}

