/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.handler.type;

import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.Node;
import org.javabuilders.handler.ITypeAsValueHandler;
import org.javabuilders.util.BuilderUtils;

public class IconAsValueHandler
implements ITypeAsValueHandler<Icon> {
    private static final IconAsValueHandler singleton = new IconAsValueHandler();
    public static final String IMAGE_REGEX = ".+";

    public static IconAsValueHandler getInstance() {
        return singleton;
    }

    private IconAsValueHandler() {
    }

    @Override
    public String getInputValueSample() {
        return "images/save48x48.png";
    }

    @Override
    public String getRegex() {
        return IMAGE_REGEX;
    }

    @Override
    public Icon getValue(BuildProcess process, Node node, String key, Object inputValue) throws BuildException {
        String path = (String)inputValue;
        URL imgURL = BuilderUtils.getResourceURL(process, path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        throw new BuildException("Unable to find Icon defined by path: " + path, new Object[0]);
    }

    @Override
    public Class<?> getApplicableClass() {
        return Icon.class;
    }
}

