/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.handler.type;

import java.awt.Component;
import java.awt.Image;
import java.net.URL;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.Node;
import org.javabuilders.handler.ITypeAsValueHandler;
import org.javabuilders.util.BuilderUtils;

public class ImageAsValueHandler
implements ITypeAsValueHandler<Image> {
    private static final ImageAsValueHandler singleton = new ImageAsValueHandler();

    public static ImageAsValueHandler getInstance() {
        return singleton;
    }

    private ImageAsValueHandler() {
    }

    @Override
    public String getInputValueSample() {
        return "images/save48x48.png";
    }

    @Override
    public String getRegex() {
        return ".+";
    }

    @Override
    public Image getValue(BuildProcess process, Node node, String key, Object inputValue) throws BuildException {
        String path = (String)inputValue;
        URL imgURL = BuilderUtils.getResourceURL(process, path);
        if (imgURL != null) {
            Object c = node.getMainObject();
            if (c instanceof Component) {
                Component comp = (Component)c;
                return comp.getToolkit().getImage(imgURL);
            }
            throw new BuildException("Unable to obtain Toolkit required for Image: " + path, new Object[0]);
        }
        throw new BuildException("Unable to find Image defined by path: " + path, new Object[0]);
    }

    @Override
    public Class<?> getApplicableClass() {
        return Image.class;
    }
}

