/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.javabuilders.layout.ControlConstraint;
import org.javabuilders.layout.Flow;
import org.javabuilders.layout.LayoutCell;
import org.javabuilders.layout.LayoutException;
import org.javabuilders.util.BuilderUtils;
import org.javabuilders.util.JBStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class LayoutConstraints {
    private static final Logger logger = LoggerFactory.getLogger(LayoutConstraints.class);
    private String layoutConstraints = "";
    private List<String> rowConstraints = new ArrayList<String>();
    private List<String> columnConstraints = new ArrayList<String>();
    private Set<LayoutCell> cells = new LinkedHashSet<LayoutCell>();
    private Map<Integer, Set<String>> sizeGroups = new HashMap<Integer, Set<String>>();
    private Map<String, String> additionalControlConstraints = new HashMap<String, String>();

    public LayoutConstraints() {
    }

    public LayoutConstraints(String layoutConstraints) {
        this.layoutConstraints = layoutConstraints;
    }

    public String getLayoutConstraints() {
        return this.layoutConstraints;
    }

    public void setLayoutConstraints(String layoutConstraints) {
        this.layoutConstraints = layoutConstraints;
    }

    public List<String> getRowConstraints() {
        return this.rowConstraints;
    }

    public String toString() {
        return String.format("General: %s\nRow: %s\nColumn: %s\nCells:\n%s", this.layoutConstraints, this.rowConstraints, this.columnConstraints, this.cells);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public List<String> getColumnConstraints() {
        return this.columnConstraints;
    }

    public Set<LayoutCell> getCells() {
        return this.cells;
    }

    public LayoutCell getCellAt(int rowIndex, int columnIndex) {
        for (LayoutCell cell : this.getCells()) {
            if (cell.getRowIndex() != rowIndex || cell.getColumnIndex() != columnIndex) continue;
            return cell;
        }
        return null;
    }

    public Map<Integer, Set<String>> getSizeGroups() {
        return this.sizeGroups;
    }

    public int getRowCount() {
        int maxRow = 0;
        for (LayoutCell cell : this.getCells()) {
            if (cell.getRowIndex() <= maxRow) continue;
            maxRow = cell.getRowIndex();
        }
        return maxRow + 1;
    }

    public int getColumnCount() {
        int maxColumn = 0;
        for (LayoutCell cell : this.getCells()) {
            if (cell.getColumnIndex() <= maxColumn) continue;
            maxColumn = cell.getColumnIndex();
        }
        return maxColumn + 1;
    }

    private void updateSpanForMaxValues() {
        int rows = this.getRowCount();
        int columns = this.getColumnCount();
        for (LayoutCell cell : this.getCells()) {
            if (cell.getControls().size() <= 0) continue;
            ControlConstraint co = cell.getControls().get(0);
            if (co.isMaxHSpan()) {
                co.setHSpan(columns - cell.getColumnIndex());
            }
            if (!co.isMaxVSpan()) continue;
            co.setVSpan(rows - cell.getRowIndex());
        }
    }

    public static LayoutConstraints getParsedLayoutConstraints(String layout, String defaultRowContraint, String defaultColumnConstraint) throws LayoutException {
        LayoutConstraints constraints = new LayoutConstraints();
        String columnConstraintLine = "";
        String[] lines = layout.split("\n");
        if (lines.length > 0) {
            int firstControlLine = -1;
            for (int row = 0; row < lines.length; ++row) {
                String line = lines[row];
                String trimLine = line.trim();
                if (trimLine.length() <= 0) continue;
                if ('[' == trimLine.charAt(0)) {
                    if (trimLine.length() > 1) {
                        if (trimLine.startsWith("[[") && trimLine.endsWith("]]")) {
                            constraints.setLayoutConstraints(trimLine.substring(2, trimLine.length() - 2));
                            continue;
                        }
                        if (trimLine.startsWith("[") && trimLine.endsWith("]")) {
                            columnConstraintLine = line;
                            continue;
                        }
                        throw new LayoutException("Incorrectly formatted constraint line: " + trimLine, new Object[0]);
                    }
                    throw new LayoutException("Incorrectly formatted constraint line: " + trimLine, new Object[0]);
                }
                if ('{' == trimLine.charAt(0)) {
                    LayoutConstraints.handleAdditionalControlConstraintLine(constraints, trimLine);
                    continue;
                }
                if (firstControlLine == -1) {
                    firstControlLine = row;
                }
                LayoutConstraints.handleControlLine(constraints, row - firstControlLine, line, defaultRowContraint);
            }
        }
        if (columnConstraintLine.length() > 0) {
            LayoutConstraints.handleColumnConstraintsLine(constraints, columnConstraintLine, defaultColumnConstraint);
        }
        if (constraints.getCells().size() > 0) {
            TreeSet<Integer> columns = new TreeSet<Integer>();
            for (LayoutCell cell : constraints.getCells()) {
                columns.add(cell.getColumnIndex());
            }
            int column = 0;
            for (Integer originalColumn : columns) {
                for (LayoutCell cell : constraints.getCells()) {
                    if (cell.getColumnIndex() != originalColumn.intValue()) continue;
                    cell.setColumnIndex(column);
                }
                ++column;
            }
        }
        constraints.updateSpanForMaxValues();
        for (LayoutCell cell : constraints.getCells()) {
            if (cell.getHSpan() <= 1 && cell.getVSpan() <= 1) continue;
            for (int rowSpan = 0; rowSpan < cell.getVSpan(); ++rowSpan) {
                for (int cellSpan = 0; cellSpan < cell.getHSpan(); ++cellSpan) {
                    LayoutCell lowerCell;
                    if (rowSpan == 0 && cellSpan == 0 || (lowerCell = constraints.getCellAt(cell.getRowIndex() + rowSpan, cell.getColumnIndex() + cellSpan)) == null) continue;
                    for (ControlConstraint cc : lowerCell.getControls()) {
                        cell.getControls().add(cc);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Moved control " + cc.getControlName() + " from cell " + lowerCell.getColumnIndex() + " " + lowerCell.getRowIndex() + " to cell " + cell.getColumnIndex() + " " + cell.getRowIndex());
                    }
                    lowerCell.getControls().clear();
                }
            }
            if (cell.getHSpan() != 1 || cell.getVSpan() <= 1) continue;
            cell.setFlow(Flow.VERTICAL);
        }
        constraints.updateSpanForMaxValues();
        ArrayList<LayoutCell> tobeRemoved = new ArrayList<LayoutCell>();
        for (LayoutCell cell : constraints.getCells()) {
            if (cell.getControls().size() != 0) continue;
            tobeRemoved.add(cell);
        }
        for (LayoutCell cell : tobeRemoved) {
            constraints.getCells().remove(cell);
        }
        return constraints;
    }

    private static void handleControlLine(LayoutConstraints constraints, int row, String line, String defaultRowConstraint) throws LayoutException {
        int nextSpace = -1;
        String controlData = null;
        int character = 32;
        List<String> controls = null;
        line = line + " ";
        boolean rowConstraintFound = false;
        for (int column = 0; column < line.length(); ++column) {
            character = line.charAt(column);
            if (character == 91) {
                constraints.getRowConstraints().add(line.substring(column).trim());
                rowConstraintFound = true;
                break;
            }
            if (character == 32 && character != 34) continue;
            nextSpace = LayoutConstraints.getNextSpacePosition(line, column);
            controlData = line.substring(column, nextSpace);
            LayoutCell cell = new LayoutCell(row, column);
            controls = JBStringUtils.split(controlData, ',');
            for (String control : controls) {
                ControlConstraint constraint = new ControlConstraint(control);
                cell.getControls().add(constraint);
            }
            constraints.getCells().add(cell);
            column = nextSpace;
        }
        if (!rowConstraintFound) {
            constraints.getRowConstraints().add(defaultRowConstraint);
        }
    }

    private static int getNextSpacePosition(String line, int column) {
        int pos = -1;
        boolean inSpaceLiteral = false;
        for (int i = column; i < line.length(); ++i) {
            if (line.charAt(i) == '\"') {
                inSpaceLiteral = !inSpaceLiteral;
                continue;
            }
            if (line.charAt(i) != ' ' || inSpaceLiteral) continue;
            pos = i;
            break;
        }
        return pos;
    }

    private static void handleColumnConstraintsLine(LayoutConstraints co, String line, String defaultColumnConstraint) {
        TreeMap<Integer, String> columnConstraints = new TreeMap<Integer, String>();
        for (LayoutCell cell : co.getCells()) {
            if (line.length() <= cell.getColumnIndex()) continue;
            char charForCol = line.charAt(cell.getColumnIndex());
            if (charForCol == '[') {
                int nextColCo = line.indexOf("[", cell.getColumnIndex() + 1);
                if (nextColCo == -1) {
                    columnConstraints.put(cell.getColumnIndex(), line.substring(cell.getColumnIndex()).trim());
                    continue;
                }
                columnConstraints.put(cell.getColumnIndex(), line.substring(cell.getColumnIndex(), nextColCo));
                continue;
            }
            columnConstraints.put(cell.getColumnIndex(), defaultColumnConstraint);
        }
        for (String colCo : columnConstraints.values()) {
            co.getColumnConstraints().add(colCo);
        }
    }

    private static void handleAdditionalControlConstraintLine(LayoutConstraints co, String line) {
        Yaml yaml = new Yaml();
        Map constraints = (Map)yaml.load(line);
        for (String name : constraints.keySet()) {
            List<Object> list = BuilderUtils.convertToList(constraints.get(name));
            String value = BuilderUtils.convertListToString(list, ',', line.length());
            co.getAdditionalControlConstraints().put(name, value);
        }
    }

    public Map<String, String> getAdditionalControlConstraints() {
        return this.additionalControlConstraints;
    }
}

