/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.handler;

import java.util.Set;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuilderConfig;
import org.javabuilders.ITypeAsValueSupport;
import org.javabuilders.InvalidPropertyException;
import org.javabuilders.Node;
import org.javabuilders.handler.AbstractPropertyHandler;
import org.javabuilders.util.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropertyHandler
extends AbstractPropertyHandler
implements ITypeAsValueSupport {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPropertyHandler.class);
    private static final DefaultPropertyHandler singleton = new DefaultPropertyHandler(new String[0]);

    public static DefaultPropertyHandler getInstance() {
        return singleton;
    }

    private DefaultPropertyHandler(Set<String> consumedKeys) {
        super(consumedKeys);
    }

    private DefaultPropertyHandler(String ... consumedKeys) {
        super(consumedKeys);
    }

    @Override
    public void handle(BuilderConfig config, BuildProcess result, Node node, String key) throws InvalidPropertyException {
        if (key != "content") {
            Object mainObject = node.getMainObject();
            Object value = node.getProperties().get(key);
            if (config.getNamePropertyName().equals(key) && !PropertyUtils.isValid(mainObject, config.getNamePropertyName())) {
                return;
            }
            try {
                PropertyUtils.setProperty(mainObject, key, value);
            }
            catch (Exception e) {
                StringBuilder builder = new StringBuilder();
                try {
                    builder.append("The known property names for " + mainObject.getClass().getSimpleName() + " are:");
                    Set<String> names = PropertyUtils.getPropertyNames(mainObject);
                    for (String name : names) {
                        if (builder.length() > 0) {
                            builder.append("\n");
                        }
                        builder.append(name);
                    }
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                logger.error(e.getMessage() + "\n" + builder.toString(), (Throwable)e);
                throw new InvalidPropertyException((Throwable)e, node.getKey(), key, value, builder.toString());
            }
        }
    }

    public Class<?> getApplicableClass() {
        return Object.class;
    }
}

