/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.handler.validation;

import java.util.List;
import java.util.Map;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuilderConfig;
import org.javabuilders.NamedObjectProperty;
import org.javabuilders.Node;
import org.javabuilders.handler.AbstractTypeHandler;
import org.javabuilders.handler.ITypeChildrenHandler;
import org.javabuilders.handler.validation.BuilderValidators;
import org.javabuilders.handler.validation.PropertyValidations;
import org.javabuilders.util.BuilderUtils;

public class DefaultValidatorTypeHandler
extends AbstractTypeHandler
implements ITypeChildrenHandler {
    private static final DefaultValidatorTypeHandler singleton = new DefaultValidatorTypeHandler();

    public static DefaultValidatorTypeHandler getInstance() {
        return singleton;
    }

    private DefaultValidatorTypeHandler() {
        super("content");
    }

    @Override
    public Node createNewInstance(BuilderConfig config, BuildProcess process, Node parent, String key, Map<String, Object> typeDefinition) throws BuildException {
        BuilderValidators instance = process.getBuildResult().getValidators();
        return this.useExistingInstance(config, process, parent, key, typeDefinition, instance);
    }

    @Override
    public Node useExistingInstance(BuilderConfig config, BuildProcess process, Node parent, String key, Map<String, Object> typeDefinition, Object instance) throws BuildException {
        Node node = new Node(parent, key, typeDefinition);
        node.setMainObject(instance);
        List contents = (List)typeDefinition.get("content");
        for (Object validatorData : contents) {
            if (validatorData instanceof Map) {
                Map data = (Map)validatorData;
                for (String dataKey : data.keySet()) {
                    NamedObjectProperty property = BuilderUtils.getParsedProperty(dataKey);
                    PropertyValidations validator = new PropertyValidations(property);
                    Map validatorProperties = (Map)data.get(dataKey);
                    BuilderUtils.populateObjectPropertiesFromMap(validator, validatorProperties);
                    process.getBuildResult().getValidators().add(validator);
                }
                continue;
            }
            throw new BuildException("Unable to parse validator data: " + validatorData, new Object[0]);
        }
        return node;
    }

    @Override
    public Class<?> getApplicableClass() {
        return BuilderValidators.class;
    }
}

