/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuildResult;
import org.javabuilders.BuilderConfig;
import org.javabuilders.BuilderPreProcessor;
import org.javabuilders.ICustomCommand;
import org.javabuilders.NamedObjectProperty;
import org.javabuilders.Node;
import org.javabuilders.Values;
import org.javabuilders.annotations.Alias;
import org.javabuilders.annotations.DoInBackground;
import org.javabuilders.event.BackgroundEvent;
import org.javabuilders.event.BackgroundEventListener;
import org.javabuilders.event.CancelStatus;
import org.javabuilders.event.IBackgroundCallback;
import org.javabuilders.event.IBindingListener;
import org.javabuilders.event.IBindingListenerProvider;
import org.javabuilders.event.ObjectMethod;
import org.javabuilders.exception.InvalidFormatException;
import org.javabuilders.util.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class BuilderUtils {
    private static final Logger logger = LoggerFactory.getLogger(BuilderUtils.class);
    private static OperatingSystem os = OperatingSystem.Windows;
    private static Pattern elPattern = Pattern.compile("[${][a-z][a-zA-Z0-9]*(\\.?[a-z][a-zA-Z0-9]*)*}");
    private static String beanPattern = "[a-zA-Z][a-zA-Z09]*(\\.?[a-z]?[a-zA-Z0-9]*)*";
    private static Pattern namePattern = Pattern.compile("([A-Z]{0,1}[0-9a-z]+)");

    public static OperatingSystem getOS() {
        return os;
    }

    public static ObjectMethod getCallerEventMethod(BuildProcess result, Node node, String methodKey, Class<?> ... eventClasses) throws BuildException {
        String methodName = String.valueOf(node.getProperties().get(methodKey));
        return BuilderUtils.getCallerEventMethod(result, methodName, node.getMainObject().getClass(), eventClasses);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ObjectMethod getCallerEventMethod(BuildProcess result, String methodName, Class<?> mainObjectClass, Class<?> ... eventClasses) throws BuildException {
        HashSet<Method> methods = new HashSet<Method>();
        if (result.getConfig().getCustomCommands().containsKey(methodName)) {
            ICustomCommand<? extends Object> command = result.getConfig().getCustomCommands().get(methodName);
            try {
                Method method = command.getClass().getMethod("process", BuildResult.class, Object.class);
                return new ObjectMethod(command, method, ObjectMethod.MethodType.CustomCommand);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                throw new BuildException(ex, "Unable to get custom command method: {0}", ex.getMessage());
            }
        }
        Object target = result.getCaller();
        for (Method method : BuilderUtils.getAllMethods(target.getClass())) {
            if (method.getParameterTypes().length > 2) continue;
            if (method.isAnnotationPresent(Alias.class)) {
                if (!method.getAnnotation(Alias.class).value().equals(methodName)) continue;
                methods.add(method);
                continue;
            }
            if (!method.getName().equals(methodName)) continue;
            methods.add(method);
        }
        Method methodToCall = null;
        TreeMap<Integer, Method> methodsByPreference = new TreeMap<Integer, Method>();
        block8: for (Method method : methods) {
            block1 : switch (method.getParameterTypes().length) {
                case 0: {
                    methodsByPreference.put(0, method);
                    break;
                }
                case 1: {
                    Class<?> parameterType = method.getParameterTypes()[0];
                    if (parameterType.isAssignableFrom(mainObjectClass)) {
                        methodsByPreference.put(2, method);
                        break;
                    }
                    if (eventClasses == null || eventClasses.length <= 0) break;
                    for (Class<?> eventClass : eventClasses) {
                        if (parameterType.isAssignableFrom(eventClass)) {
                            methodsByPreference.put(3, method);
                            break block1;
                        }
                        if (!method.isAnnotationPresent(DoInBackground.class) || !BackgroundEvent.class.isAssignableFrom(method.getParameterTypes()[0])) continue;
                        methodsByPreference.put(5, method);
                    }
                    break;
                }
                case 2: {
                    Class<?> firstParameterType = method.getParameterTypes()[0];
                    Class<?> secondParameterType = method.getParameterTypes()[1];
                    boolean isSecondParameterAnEventClass = false;
                    for (Class<?> eventClass : eventClasses) {
                        if (!secondParameterType.isAssignableFrom(eventClass)) continue;
                        isSecondParameterAnEventClass = true;
                        break;
                    }
                    if (!firstParameterType.isAssignableFrom(mainObjectClass) || !isSecondParameterAnEventClass) break;
                    methodsByPreference.put(4, method);
                    break block8;
                }
            }
        }
        for (int i = 5; i >= 0; --i) {
            if (!methodsByPreference.containsKey(i)) continue;
            methodToCall = (Method)methodsByPreference.get(i);
            break;
        }
        if (methodToCall != null) {
            methodToCall.setAccessible(true);
            return new ObjectMethod(target, methodToCall);
        }
        throw new BuildException("Unable to find method to call for name \"{0}\"", methodName);
    }

    public static void invokeCallerEventMethods(BuildResult result, Node node, Collection<ObjectMethod> methods, Object eventClassInstance) {
        BuilderUtils.invokeCallerEventMethods(result, node.getMainObject(), methods, eventClassInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeCallerEventMethods(final BuildResult result, Object mainObject, Collection<ObjectMethod> methods, Object eventClassInstance) {
        Object invocationResult = null;
        for (ObjectMethod method : methods) {
            try {
                if (method.getType() == ObjectMethod.MethodType.CustomCommand) {
                    method.getMethod().setAccessible(true);
                    invocationResult = method.getMethod().invoke(method.getInstance(), result, mainObject);
                    if (!Boolean.FALSE.equals(invocationResult)) continue;
                    break;
                }
                if (method.getMethod().isAnnotationPresent(DoInBackground.class)) {
                    DoInBackground ann = method.getMethod().getAnnotation(DoInBackground.class);
                    final BackgroundEvent event = new BackgroundEvent(mainObject, eventClassInstance, ann.blocking(), result);
                    event.setCancelable(ann.cancelable());
                    event.setProgressIndeterminate(ann.indeterminateProgress());
                    event.setProgressStart(ann.progressStart());
                    event.setProgressEnd(ann.progressEnd());
                    event.setProgressValue(ann.progressValue());
                    String resource = result.getResource(ann.progressMessage());
                    event.setProgressMessage(resource);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Executing background method: {}", (Object)method.getMethod().getName());
                    }
                    final ArrayList<ObjectMethod> outstandingMethods = new ArrayList<ObjectMethod>();
                    boolean next = false;
                    for (ObjectMethod nextMethod : methods) {
                        if (method.equals(nextMethod)) {
                            next = true;
                            continue;
                        }
                        if (!next) continue;
                        outstandingMethods.add(nextMethod);
                    }
                    IBackgroundCallback callback = new IBackgroundCallback(){

                        @Override
                        public void done(Object returnValue) {
                            if (event.getCancelStatus().getStatus() <= CancelStatus.NONE.getStatus() && outstandingMethods != null && outstandingMethods.size() > 0) {
                                BuilderUtils.invokeCallerEventMethods(result, event.getSource(), (Collection<ObjectMethod>)outstandingMethods, event.getOriginalEvent());
                            }
                        }
                    };
                    try {
                        for (BackgroundEventListener l : result.getConfig().getBackgroundEventListeners()) {
                            l.backgroundTaskStarted(result, event);
                        }
                        for (BackgroundEventListener l : result.getBackgroundEventListeners()) {
                            l.backgroundTaskStarted(result, event);
                        }
                        result.getConfig().getBackgroundProcessingHandler().doInBackground(result, result.getCaller(), method.getMethod(), event, callback);
                    }
                    finally {
                        for (BackgroundEventListener l : result.getBackgroundEventListeners()) {
                            l.backgroundTaskEnded(result, event);
                        }
                        for (BackgroundEventListener l : result.getConfig().getBackgroundEventListeners()) {
                            l.backgroundTaskEnded(result, event);
                        }
                    }
                    if (!logger.isDebugEnabled()) break;
                    logger.debug("Finished executing background method: " + method.getMethod().getName());
                    break;
                }
                switch (method.getMethod().getParameterTypes().length) {
                    case 0: {
                        invocationResult = method.getMethod().invoke(method.getInstance(), new Object[0]);
                        break;
                    }
                    case 1: {
                        Class<?> parameterType = method.getMethod().getParameterTypes()[0];
                        if (parameterType.isAssignableFrom(mainObject.getClass())) {
                            invocationResult = method.getMethod().invoke(method.getInstance(), mainObject);
                            break;
                        }
                        invocationResult = method.getMethod().invoke(method.getInstance(), eventClassInstance);
                        break;
                    }
                    case 2: {
                        invocationResult = method.getMethod().invoke(result.getCaller(), mainObject, eventClassInstance);
                    }
                }
                if (invocationResult != null && invocationResult.equals(Boolean.FALSE)) break;
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Finished executing method: " + method.getMethod().getName());
            }
            catch (Exception ex) {
                throw new BuildException(ex, "Failed to invoke method: {0}. {1}", method.getMethod().getName(), ex.getMessage());
            }
        }
    }

    public static void updateNamedObjectReferencesInCaller(BuildProcess result) {
        Object caller = result.getCaller();
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Class<?> parent = caller.getClass(); parent != null; parent = parent.getSuperclass()) {
            fields.addAll(Arrays.asList(parent.getDeclaredFields()));
        }
        if (caller != null) {
            for (String name : result.getBuildResult().keySet()) {
                for (Field field : fields) {
                    String fromName = field.getName();
                    if (field.isAnnotationPresent(Alias.class)) {
                        fromName = field.getAnnotation(Alias.class).value();
                    }
                    if (!fromName.equals(name)) continue;
                    field.setAccessible(true);
                    Object value = null;
                    try {
                        value = field.get(caller);
                        if (value == null) {
                            Object namedObject = result.getBuildResult().get(name);
                            if (field.getType().isAssignableFrom(namedObject.getClass())) {
                                field.set(caller, namedObject);
                                if (!logger.isDebugEnabled()) continue;
                                logger.debug("Successfully set reference to caller's variable: " + name);
                                continue;
                            }
                            if (!logger.isInfoEnabled()) continue;
                            logger.info("Failed to set value for caller's variable: " + name + ". Incompatible types.");
                            continue;
                        }
                        if (!logger.isInfoEnabled()) continue;
                        logger.info("Unable to set caller's instance variable: " + name + ". It is not null.");
                    }
                    catch (IllegalArgumentException e) {
                        if (!logger.isInfoEnabled()) continue;
                        logger.info("Failed to access property " + name, (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        if (!logger.isInfoEnabled()) continue;
                        logger.info("Failed to access property " + name, (Throwable)e);
                    }
                }
            }
        }
    }

    public static void validateNotNullAndNotEmpty(String name, Object value) {
        if (value == null) {
            throw new NullPointerException(String.format("%s cannot be null", name));
        }
        if (value instanceof String && ((String)value).length() == 0) {
            throw new NullPointerException(String.format("%s cannot be empty String", name));
        }
    }

    public static List<Object> convertToList(Object value) {
        if (value instanceof List) {
            return (List)value;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(value);
        return list;
    }

    public static String convertListToString(List<Object> list, char delimiter, int estimatedLength) {
        StringBuilder builder = new StringBuilder(estimatedLength);
        for (Object value : list) {
            if (builder.length() > 0) {
                builder.append(delimiter).append(" ");
            }
            builder.append(value);
        }
        return builder.toString();
    }

    public static void populateObjectPropertiesFromMap(Object target, Map<String, Object> properties) throws BuildException {
        for (String property : properties.keySet()) {
            Object value = properties.get(property);
            try {
                PropertyUtils.setProperty(target, property, value);
            }
            catch (Exception e) {
                throw new BuildException("Unable to set value on object for key: " + property, new Object[]{e});
            }
        }
    }

    public static List<NamedObjectProperty> getParsedPropertyExpression(String text) throws BuildException {
        ArrayList<NamedObjectProperty> properties = new ArrayList<NamedObjectProperty>();
        Matcher m = elPattern.matcher(text);
        while (m.find()) {
            String path = m.group().split("[${]|[}]")[1];
            NamedObjectProperty property = BuilderUtils.getParsedProperty(path);
            properties.add(property);
        }
        if (properties.size() == 0) {
            if (text.matches(beanPattern)) {
                NamedObjectProperty property = BuilderUtils.getParsedProperty(text);
                properties.add(property);
            } else {
                throw new BuildException("Unable to parse property expression. It is recognized as neither EL or regular Bean: " + text, new Object[0]);
            }
        }
        return properties;
    }

    public static NamedObjectProperty getParsedProperty(String property) throws BuildException {
        int pos;
        if (property.indexOf(46) <= 0) {
            property = String.format("this.%s", property);
        }
        if ((pos = property.indexOf(46)) > 0) {
            NamedObjectProperty objectProperty = new NamedObjectProperty(property.substring(0, pos), property.substring(pos + 1));
            return objectProperty;
        }
        throw new BuildException("Unable to parse named object property: " + property, new Object[0]);
    }

    public static Class<?> getClassFromCallerFields(Object caller, String className, String objectName) {
        Field[] fields;
        Class typeClass = null;
        HashMap classes = new HashMap();
        for (Field field : fields = caller.getClass().getDeclaredFields()) {
            if (!field.getType().getSimpleName().equals(className)) continue;
            classes.put(field.getName(), field.getType());
            typeClass = field.getType();
        }
        if (classes.size() > 1) {
            for (String name : classes.keySet()) {
                if (!name.equals(objectName)) continue;
                typeClass = (Class)classes.get(name);
                break;
            }
        }
        return typeClass;
    }

    public static Class<?> getClassFromAlias(BuildProcess process, String key, String instanceName) {
        Class<?> typeClass = process.getConfig().getClassType(key);
        if (typeClass == null) {
            typeClass = BuilderUtils.getClassFromCallerFields(process.getCaller(), key, instanceName);
        }
        if (typeClass == null) {
            for (Class<?> parent = process.getCaller().getClass(); parent != null; parent = parent.getSuperclass()) {
                if (!parent.getSimpleName().equals(key)) continue;
                typeClass = parent;
                break;
            }
        }
        return typeClass;
    }

    public static Map<String, Field> getAllFields(Class<? extends Object> typeClass) {
        HashMap<String, Field> allFields = new HashMap<String, Field>();
        for (Field field : typeClass.getDeclaredFields()) {
            allFields.put(field.getName(), field);
            field.setAccessible(true);
        }
        for (typeClass = typeClass.getSuperclass(); typeClass != null; typeClass = typeClass.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = typeClass.getDeclaredFields()) {
                int mod = field.getModifiers();
                if (Modifier.isStatic(mod) || !Modifier.isProtected(mod) && !Modifier.isPublic(mod)) continue;
                allFields.put(field.getName(), field);
                field.setAccessible(true);
            }
        }
        return allFields;
    }

    public static Field getField(Object caller, String name, Class<? extends Object> typeClass) {
        Map<String, Field> fields = BuilderUtils.getAllFields(caller.getClass());
        Field field = null;
        for (String fieldName : fields.keySet()) {
            if (!name.equals(fieldName)) continue;
            Field temp = fields.get(fieldName);
            if (!typeClass.isAssignableFrom(temp.getType())) break;
            field = temp;
            break;
        }
        return field;
    }

    public static List<Method> getAllMethods(Class<? extends Object> typeClass) {
        ArrayList<Method> allMethods = new ArrayList<Method>();
        for (Method method : typeClass.getDeclaredMethods()) {
            allMethods.add(method);
            method.setAccessible(true);
        }
        for (typeClass = typeClass.getSuperclass(); typeClass != null; typeClass = typeClass.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = typeClass.getDeclaredMethods()) {
                int mod = method.getModifiers();
                if (Modifier.isStatic(mod) || !Modifier.isProtected(mod) && !Modifier.isPublic(mod)) continue;
                allMethods.add(method);
                method.setAccessible(true);
            }
        }
        return allMethods;
    }

    public static boolean isListenerNeeded(Values<String, ObjectMethod> ... methods) {
        boolean needed = false;
        for (Values<String, ObjectMethod> methodList : methods) {
            if (methodList == null || methodList.size() <= 0) continue;
            needed = true;
            break;
        }
        return needed;
    }

    public static void validateYamlContent(String yaml, String fileName) {
        StringBuilder errors = new StringBuilder();
        String[] lines = yaml.split("\n");
        String previousLine = null;
        for (int i = 0; i < lines.length; ++i) {
            int prevPos;
            String trimmed;
            String line = lines[i];
            int pos = line.indexOf("\t");
            if (pos >= 0) {
                errors.append(MessageFormat.format("Found a tab in line {0} starting at\n{1}\n", i + 1, line.substring(pos)));
            }
            int left = 0;
            int right = 0;
            int startingQuotes = 0;
            int endingQuotes = 0;
            boolean inQuotes = false;
            for (int c = 0; c < line.length(); ++c) {
                char charAt = line.charAt(c);
                if (charAt == '\"') {
                    boolean bl = inQuotes = !inQuotes;
                    if (inQuotes) {
                        ++startingQuotes;
                        continue;
                    }
                    ++endingQuotes;
                    continue;
                }
                if (charAt == '(' && !inQuotes) {
                    ++left;
                    continue;
                }
                if (charAt == ')' && !inQuotes) {
                    ++right;
                    continue;
                }
                if (charAt == '#' && !inQuotes) break;
            }
            if (left != right) {
                errors.append(MessageFormat.format("Unmatched number of left and right parentheses in line {0}: {1}\n", i + 1, line));
            }
            if (startingQuotes != endingQuotes) {
                errors.append(MessageFormat.format("Unmatched number of opening and closing quotes in line {0}: {1}\n", i + 1, line));
            }
            if (previousLine != null && (trimmed = line.trim()).startsWith("-") && (pos = line.indexOf("-")) != (prevPos = previousLine.indexOf("-"))) {
                String noCommentsLine = BuilderUtils.getYamlLineWithoutTrailingComments(previousLine);
                int lineIndent = BuilderUtils.getFirstNoSpacePosition(line);
                int previousLineIndent = BuilderUtils.getFirstNoSpacePosition(previousLine);
                if (!noCommentsLine.trim().endsWith(":") && lineIndent > previousLineIndent) {
                    throw new BuildException("\":\" is missing after \"{0}\", as list is started on next line", noCommentsLine);
                }
            }
            previousLine = line;
        }
        if (errors.length() > 0) {
            if (fileName != null) {
                errors.insert(0, MessageFormat.format("Errors found in file: {0}\n", fileName));
            }
            throw new InvalidFormatException(errors.toString(), new Object[0]);
        }
    }

    private static int getFirstNoSpacePosition(String line) {
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) == ' ') continue;
            return i;
        }
        return -1;
    }

    private static String getYamlLineWithoutTrailingComments(String line) {
        if (line.indexOf("#") < 0) {
            return line;
        }
        boolean inQuotes = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (c != '#' || inQuotes) continue;
            return line.substring(0, i);
        }
        return line;
    }

    public static Object getExistingInstanceIfAvailable(Object caller, Class<?> expectedClass, BuilderConfig config, Map<String, Object> data) {
        Object instance = null;
        if (caller != null) {
            Map<String, Field> fields = BuilderUtils.getAllFields(caller.getClass());
            String name = config.getNameIfAvailable(data);
            if (name != null) {
                Object possible = null;
                try {
                    if (fields.containsKey(name)) {
                        possible = fields.get(name).get(caller);
                    }
                }
                catch (Exception e) {
                    throw new BuildException(e, "Failed to get value for {0}: {1}", name, e.getMessage());
                }
                if (possible != null) {
                    if (expectedClass.isAssignableFrom(possible.getClass())) {
                        instance = possible;
                    } else {
                        throw new BuildException("Found a variable called {0}, but it was of incompatible type {1}, instead of the expected {2}", name, possible.getClass(), expectedClass);
                    }
                }
            }
        }
        return instance;
    }

    public static URL getResourceURL(BuildProcess process, String path) {
        URL url = process.getCaller().getClass().getResource(path);
        if (url == null && process.getBuildResult().isInternationalizationActive() && (path = process.getBuildResult().getResource(path)) != null) {
            url = process.getCaller().getClass().getResource(path);
        }
        return url;
    }

    public static InputStream getResourceInputStream(BuildProcess process, String path) {
        InputStream is = process.getCaller().getClass().getResourceAsStream(path);
        if (is == null && process.getBuildResult().isInternationalizationActive() && (path = process.getBuildResult().getResource(path)) != null) {
            is = process.getCaller().getClass().getResourceAsStream(path);
        }
        return is;
    }

    public static String generateName(BuildResult result, String input, String prefix, String suffix) {
        return BuilderUtils.generateName(result, input, prefix, suffix, 1);
    }

    private static String generateName(BuildResult result, String input, String prefix, String suffix, int instance) {
        String name;
        Matcher m = namePattern.matcher(input);
        StringBuilder bld = new StringBuilder(input.length());
        if (prefix != null) {
            bld.append(prefix);
        }
        while (m.find()) {
            String group = m.group();
            if (group.length() > 1) {
                if (bld.length() == 0) {
                    bld.append(group.substring(0, 1).toLowerCase());
                    bld.append(group.substring(1));
                    continue;
                }
                bld.append(group.substring(0, 1).toUpperCase());
                bld.append(group.substring(1));
                continue;
            }
            bld.append(group.toUpperCase());
        }
        if (instance > 1) {
            bld.append(instance);
        }
        if (suffix != null) {
            bld.append(suffix);
        }
        if (result.get(name = bld.toString()) != null) {
            return BuilderUtils.generateName(result, input, prefix, suffix, ++instance);
        }
        return name;
    }

    public static String getYamlContent(BuilderConfig config, Class<?> baseClass) throws IOException {
        return BuilderUtils.getYamlContent(config, baseClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getYamlContent(BuilderConfig config, Class<?> baseClass, String yamlFileName) throws IOException {
        StringBuilder builder = new StringBuilder();
        if (yamlFileName == null) {
            yamlFileName = baseClass.getSimpleName() + config.getYamlExtension();
        }
        InputStream is = baseClass.getResourceAsStream(yamlFileName);
        InputStreamReader isr = null;
        BufferedReader rdr = null;
        try {
            isr = new InputStreamReader(is);
            rdr = new BufferedReader(isr);
            String line = "";
            while ((line = rdr.readLine()) != null) {
                builder.append(line).append("\n");
            }
        }
        finally {
            if (rdr != null) {
                rdr.close();
            }
            if (isr != null) {
                isr.close();
            }
        }
        return builder.toString();
    }

    public static Class<?> getGenericsTypeFromCollectionField(Field field) {
        Class clazz = null;
        if (List.class.isAssignableFrom(field.getType()) || Set.class.isAssignableFrom(field.getType())) {
            field.setAccessible(true);
            ParameterizedType ptype = (ParameterizedType)field.getGenericType();
            Type[] types = ptype.getActualTypeArguments();
            if (types != null && types.length > 0) {
                clazz = (Class)types[0];
            }
        }
        return clazz;
    }

    public static Object[] getMessageFormatSafeArguments(Object ... arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            Object argument = arguments[i];
            String str = null;
            if (argument instanceof String) {
                str = (String)argument;
            } else if (argument != null) {
                str = String.valueOf(str);
            }
            if (str == null || str.indexOf(123) < 0) continue;
            arguments[i] = str.replace("{", "\\{");
        }
        return arguments;
    }

    public static Object getValue(Map<String, Object> map, Object key, Object defaultValue) {
        Object value = map.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static String getRealKey(String key) {
        if (key.indexOf(40) > 0 && key.endsWith(")")) {
            key = key.substring(0, key.indexOf(40));
        }
        return key;
    }

    public static String handlePotentialHtmlContent(String text) {
        String html = text;
        if (text.contains("<") && text.contains("</")) {
            html = String.format("<html>%s</html>", text);
        }
        return html;
    }

    public static void uncompressYaml(String key, Map<String, Object> current) throws BuildException {
        StringBuilder nameValuePair = new StringBuilder(key.length());
        int start = key.indexOf("(");
        if (start > 0 && key.endsWith(")")) {
            String constructorText = key.substring(start + 1, key.length() - 1);
            LinkedList<String> keyValuePairs = new LinkedList<String>();
            int nestedParentheses = 0;
            boolean isEmbeddedInString = false;
            Character listEnd = null;
            for (int i = 0; i < constructorText.length(); ++i) {
                char currentChar = constructorText.charAt(i);
                if (currentChar == '\"') {
                    boolean bl = isEmbeddedInString = !isEmbeddedInString;
                }
                if (!isEmbeddedInString) {
                    if (BuilderPreProcessor.listIndicators.containsKey(Character.valueOf(currentChar))) {
                        listEnd = BuilderPreProcessor.listIndicators.get(Character.valueOf(currentChar));
                        if (listEnd.charValue() == ')' && BuilderPreProcessor.logger.isWarnEnabled()) {
                            BuilderPreProcessor.logger.warn("'[]' is the new format for lists, '()' is deprecated and will be removed: %s", (Object)constructorText);
                        }
                        ++nestedParentheses;
                    } else if (listEnd != null && currentChar == listEnd.charValue()) {
                        listEnd = null;
                        --nestedParentheses;
                    } else if (currentChar == ',' && nestedParentheses == 0) {
                        keyValuePairs.add(nameValuePair.toString());
                        nameValuePair.setLength(0);
                        continue;
                    }
                }
                nameValuePair.append(currentChar);
            }
            keyValuePairs.add(nameValuePair.toString());
            StringBuilder temp = new StringBuilder();
            for (String keyValuePair : keyValuePairs) {
                if (keyValuePair.length() <= 0) continue;
                String[] pair = keyValuePair.split("=", 2);
                if (pair.length == 2) {
                    pair[0] = pair[0].trim();
                    temp.setLength(0);
                    temp.append(pair[1].trim());
                    boolean isEmbedded = false;
                    for (int i = 0; i < temp.length(); ++i) {
                        char c = temp.charAt(i);
                        if (c == '\"') {
                            boolean bl = isEmbedded = !isEmbedded;
                        }
                        if (isEmbedded) continue;
                        if (c == '(') {
                            temp.setCharAt(i, '[');
                            continue;
                        }
                        if (c != ')') continue;
                        temp.setCharAt(i, ']');
                    }
                    if (current.containsKey(pair[0])) continue;
                    Yaml yaml = new Yaml();
                    Object value = yaml.load(temp.toString());
                    current.put(pair[0], value);
                    continue;
                }
                throw new BuildException("Key/value {0} from virtual constructor {1} not in valid format", keyValuePair, constructorText);
            }
        } else {
            throw new BuildException("Unable to parse virtual constructor: {0}", key);
        }
    }

    public static <T> void fireBindingEvent(BuildResult result, T binding) {
        if (result.getConfig() instanceof IBindingListenerProvider) {
            IBindingListenerProvider provider = (IBindingListenerProvider)((Object)result.getConfig());
            for (IBindingListener<T> iBindingListener : provider.getBindingListeners()) {
                iBindingListener.bindingCreated(result, binding);
            }
        }
    }

    static {
        String name = System.getProperty("os.name").toLowerCase();
        if (name.indexOf("unix") >= 0 || name.indexOf("linux") >= 0) {
            os = OperatingSystem.LinuxUnix;
        } else if (name.indexOf("mac") >= 0) {
            os = OperatingSystem.Mac;
        }
    }

    public static enum OperatingSystem {
        Windows,
        LinuxUnix,
        Mac,
        Other;

    }
}

