package net.oni2.aeinstaller.backend.network;

/**
 * Interface for listeners to status updates during file download
 * 
 * @author Christian Illy
 */
public interface FileDownloadListener {

	/**
	 * Called after checking out / updating a single file
	 * 
	 * @param source
	 *            Source of event
	 * @param state
	 *            Current state of downloader
	 * @param done
	 *            Bytes done
	 * @param total
	 *            Total bytes for the download
	 */
	public void statusUpdate(FileDownloader source,
			FileDownloader.EState state, int done, int total);
}
