package net.oni2.aeinstaller;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;

import javax.swing.JFrame;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UIManager.LookAndFeelInfo;

import net.oni2.aeinstaller.backend.Settings;
import net.oni2.aeinstaller.backend.StuffToRefactorLater;
import net.oni2.aeinstaller.backend.depot.DepotManager;
import net.oni2.aeinstaller.gui.MainWin;

import org.javabuilders.swing.SwingJavaBuilder;

/**
 * @author Christian Illy
 * @version 0.1
 */
public class AEInstaller2 {

	/**
	 * @param args
	 *            Command line arguments
	 */
	public static void main(String[] args) {
		new File(Settings.getPrefsPath()).mkdirs();
		new File(Settings.getDownloadPath()).mkdirs();

		boolean debug = false;
		for (String a : args)
			if (a.equalsIgnoreCase("-debug"))
				debug = true;
		if (!debug) {
			try {
				System.setOut(new PrintStream(Settings.getPrefsPath()
						+ "aei_output.log"));
				System.setErr(new PrintStream(Settings.getPrefsPath()
						+ "aei_error.log"));
			} catch (FileNotFoundException e1) {
				e1.printStackTrace();
			}
		}

		Settings.deserializeFromFile();
		Settings.setDebug(debug);
		DepotManager.getInstance().loadFromFile(
				new File(Settings.getDepotCacheFilename()));

		SwingJavaBuilder.getConfig().addResourceBundle("Images");
		SwingJavaBuilder.getConfig().setMarkInvalidResourceBundleKeys(true);
		SwingJavaBuilder.getConfig().addType("JToolBarSeparator",
				JToolBar.Separator.class);
		// SwingJavaBuilder.getConfig().addType("ScreenshotBrowser",
		// ScreenshotBrowser.class);
		// SwingJavaBuilder.getConfig().addType("HTMLLinkLabel",
		// HTMLLinkLabel.class);

		System.setProperty("networkaddress.cache.ttl", "5");
		System.setProperty("networkaddress.cache.negative.ttl", "1");

		try {
			String laf = Settings.getInstance().get("lookandfeel",
					(String) null);
			if (laf == null) {
				for (LookAndFeelInfo lafInfo : UIManager
						.getInstalledLookAndFeels()) {
					if (lafInfo.getName().equals("Nimbus"))
						laf = lafInfo.getClassName();
				}
			}
			if (laf == null)
				laf = UIManager.getSystemLookAndFeelClassName();
			UIManager.setLookAndFeel(laf);
		} catch (Exception e) {
			e.printStackTrace();
		}
		JFrame.setDefaultLookAndFeelDecorated(true);

		// TODO
		System.out.println("JarPath:   " + Settings.getJarPath());
		System.out.println("PrefsPath: " + Settings.getPrefsPath());
		System.out.println("DataPath:  " + Settings.getDataPath());
		System.out.println("DownPath:  " + Settings.getDownloadPath());
		System.out.println("TempPath:  " + Settings.getTempPath());
		System.out.println("ValidPath: "
				+ StuffToRefactorLater.verifyRunningDirectory());

		SwingUtilities.invokeLater(new Runnable() {

			public void run() {
				try {
					new MainWin().setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});

	}
}
