/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.event;

import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.util.Collection;
import javax.swing.JFrame;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuildResult;
import org.javabuilders.Node;
import org.javabuilders.Values;
import org.javabuilders.event.ObjectMethod;
import org.javabuilders.swing.handler.event.WindowListenerHandler;
import org.javabuilders.util.BuilderUtils;

public class JFrameWindowListenerHandler
extends WindowListenerHandler {
    private static final JFrameWindowListenerHandler singleton = new JFrameWindowListenerHandler();

    public static JFrameWindowListenerHandler getInstance() {
        return singleton;
    }

    private JFrameWindowListenerHandler() {
    }

    @Override
    protected void createListeners(Node node, final BuildProcess process, final Values<String, ObjectMethod> stateValues, final Values<String, ObjectMethod> windowFocusValues, final Values<String, ObjectMethod> windowFocusLostValues, final Values<String, ObjectMethod> windowActivatedValues, final Values<String, ObjectMethod> windowClosedValues, final Values<String, ObjectMethod> windowClosingValues, final Values<String, ObjectMethod> windowDeactivatedValues, final Values<String, ObjectMethod> windowDeiconifiedValues, final Values<String, ObjectMethod> windowIconifiedValues, final Values<String, ObjectMethod> windowOpenedValues) {
        final JFrame control = (JFrame)node.getMainObject();
        if (stateValues != null) {
            control.addWindowStateListener(new WindowStateListener(){

                @Override
                public void windowStateChanged(WindowEvent e) {
                    BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)control, (Collection)stateValues.values(), (Object)e);
                }
            });
        }
        if (BuilderUtils.isListenerNeeded((Values[])new Values[]{windowFocusValues, windowFocusLostValues})) {
            control.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    if (windowFocusValues != null) {
                        BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)control, (Collection)windowFocusValues.values(), (Object)e);
                    }
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    if (windowFocusLostValues != null) {
                        BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)control, (Collection)windowFocusLostValues.values(), (Object)e);
                    }
                }
            });
        }
        if (BuilderUtils.isListenerNeeded((Values[])new Values[]{windowActivatedValues, windowClosedValues, windowClosingValues, windowDeactivatedValues, windowDeiconifiedValues, windowIconifiedValues, windowOpenedValues})) {
            control.addWindowListener(new WindowListener(){

                @Override
                public void windowActivated(WindowEvent e) {
                    if (windowActivatedValues != null) {
                        BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)control, (Collection)windowActivatedValues.values(), (Object)e);
                    }
                }

                @Override
                public void windowClosed(WindowEvent e) {
                    if (windowClosedValues != null) {
                        BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)control, (Collection)windowClosedValues.values(), (Object)e);
                    }
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    if (windowClosingValues != null) {
                        BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)control, (Collection)windowClosingValues.values(), (Object)e);
                    }
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                    if (windowDeactivatedValues != null) {
                        BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)control, (Collection)windowDeactivatedValues.values(), (Object)e);
                    }
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                    if (windowDeiconifiedValues != null) {
                        BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)control, (Collection)windowDeiconifiedValues.values(), (Object)e);
                    }
                }

                @Override
                public void windowIconified(WindowEvent e) {
                    if (windowIconifiedValues != null) {
                        BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)control, (Collection)windowIconifiedValues.values(), (Object)e);
                    }
                }

                @Override
                public void windowOpened(WindowEvent e) {
                    if (windowOpenedValues != null) {
                        BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)control, (Collection)windowOpenedValues.values(), (Object)e);
                    }
                }
            });
        }
    }

    @Override
    public Class<?> getApplicableClass() {
        return JFrame.class;
    }
}

